/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.pri.excel.service.impl;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.elitesland.yst.comm.consumer.dto.ComCurrRpcDTO;
import com.elitesland.yst.comm.consumer.param.ComCurrRpcDtoParam;
import com.elitesland.yst.comm.consumer.service.ComCurrRpcService;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepoProc;
import com.elitesland.yst.supportdomain.pri.convert.PriMainPriceConvert;
import com.elitesland.yst.supportdomain.pri.excel.convert.ItemPriceExcelConvert;
import com.elitesland.yst.supportdomain.pri.excel.entity.ItemPriceExportEntity;
import com.elitesland.yst.supportdomain.pri.excel.entity.ItemPriceUpLoadEntity;
import com.elitesland.yst.supportdomain.pri.excel.listener.ItemPriceUpLoadListener;
import com.elitesland.yst.supportdomain.pri.excel.service.PriExcelService;
import com.elitesland.yst.supportdomain.pri.param.PriMainPriceRowPagingParam;
import com.elitesland.yst.supportdomain.pri.repo.PriMainPriceRowRepoProc;
import com.elitesland.yst.supportdomain.pri.service.PriMainPriceRowService;
import com.elitesland.yst.supportdomain.pri.vo.PriItemPricePagingVO;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PriExcelServiceImpl
implements PriExcelService {
    private static final Logger log = LoggerFactory.getLogger(PriExcelServiceImpl.class);
    private final PriMainPriceRowService priMainPriceRowService;
    private final ItmItemRepoProc itmItemRepoProc;
    private final PriMainPriceRowRepoProc priMainPriceRowRepoProc;
    @DubboReference
    private ComCurrRpcService comCurrRpcService;
    private final UdcService sysUdcService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<PriItemPricePagingVO> itemPriceUpload(MultipartFile file) {
        ArrayList<PriItemPricePagingVO> priItemPricePagingVOList = new ArrayList();
        ExcelReader excelReader = null;
        try {
            excelReader = EasyExcelFactory.read((InputStream)file.getInputStream()).build();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ItemPriceUpLoadListener readListener = new ItemPriceUpLoadListener(this.sysUdcService, this.itmItemRepoProc);
        ReadSheet readSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet().head(ItemPriceUpLoadEntity.class)).headRowNumber(Integer.valueOf(5))).registerReadListener((ReadListener)readListener)).build();
        if (excelReader != null) {
            excelReader.read(new ReadSheet[]{readSheet});
        }
        List<ItemPriceUpLoadEntity> datas = readListener.getDatas();
        priItemPricePagingVOList = PriMainPriceConvert.INSTANCE.upLoadEntityToPriceVO(datas);
        this.price8Set(priItemPricePagingVOList);
        this.currSet(priItemPricePagingVOList);
        return priItemPricePagingVOList;
    }

    @Override
    public void itemPriceExport(PriMainPriceRowPagingParam param, HttpServletResponse response) {
        param.setSize(1000000);
        PagingVO<PriItemPricePagingVO> result = this.priMainPriceRowService.queryPriItemPriceRowByParams(param);
        List priItemPricePagingVOList = result.getRecords();
        List<ItemPriceExportEntity> itemPriceExportEntityList = ItemPriceExcelConvert.INSTANCE.itemPriceVoToItemPriceExport(priItemPricePagingVOList);
    }

    @Override
    public com.el.coordinator.core.common.jpa.vo.PagingVO<ItemPriceExportEntity> getExportData(PriMainPriceRowPagingParam param) {
        PagingVO<PriItemPricePagingVO> result = this.priMainPriceRowService.queryPriItemPriceRowByParams(param);
        List priItemPricePagingVOList = result.getRecords();
        return com.el.coordinator.core.common.jpa.vo.PagingVO.builder().total(result.getTotal()).records(ItemPriceExcelConvert.INSTANCE.itemPriceVoToItemPriceExport(priItemPricePagingVOList)).build();
    }

    private void currSet(List<PriItemPricePagingVO> priItemPricePagingVOList) {
        ComCurrRpcDtoParam currParam;
        List currDtos;
        List currCodes = priItemPricePagingVOList.stream().map(PriItemPricePagingVO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(currCodes) && CollectionUtils.isNotEmpty((Collection)(currDtos = this.comCurrRpcService.findRpcDtoByParam(currParam = ComCurrRpcDtoParam.builder().currCodes(currCodes).build())))) {
            Map<String, String> currMap = currDtos.stream().collect(Collectors.toMap(ComCurrRpcDTO::getCurrCode, ComCurrRpcDTO::getCurrName));
            priItemPricePagingVOList.forEach(dto -> {
                if (StringUtils.isNotBlank((CharSequence)dto.getCurrCode())) {
                    dto.setCurrName(currMap.getOrDefault(dto.getCurrCode(), null));
                }
            });
        }
    }

    private void price8Set(List<PriItemPricePagingVO> priItemPricePagingVOList) {
        List<String> itemCodes = priItemPricePagingVOList.stream().map(PriItemPricePagingVO::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ArrayList priMainPriceRowDOS = this.priMainPriceRowRepoProc.selectItemPriceDetails(itemCodes).stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PriItemPricePagingVO>(Comparator.comparing(o -> o.getItemCode()))), ArrayList::new));
        Map<String, BigDecimal> price8Map = priMainPriceRowDOS.stream().filter(s -> s.getPrice8() != null).collect(Collectors.toMap(PriItemPricePagingVO::getItemCode, PriItemPricePagingVO::getPrice8));
        Map<String, String> uomMap = priMainPriceRowDOS.stream().filter(s -> s.getUom() != null).collect(Collectors.toMap(PriItemPricePagingVO::getItemCode, PriItemPricePagingVO::getUom));
        Map<String, Long> itemIdMap = priMainPriceRowDOS.stream().filter(s -> s.getId() != null).collect(Collectors.toMap(PriItemPricePagingVO::getItemCode, PriItemPricePagingVO::getId));
        Map<String, String> itemNameMap = priMainPriceRowDOS.stream().filter(s -> s.getItemName() != null).collect(Collectors.toMap(PriItemPricePagingVO::getItemCode, PriItemPricePagingVO::getItemName));
        Map<String, String> currMap = priMainPriceRowDOS.stream().filter(s -> s.getCurrCode() != null).collect(Collectors.toMap(PriItemPricePagingVO::getItemCode, PriItemPricePagingVO::getCurrCode));
        priItemPricePagingVOList.forEach(dto -> {
            if (StringUtils.isNotBlank((CharSequence)dto.getItemCode())) {
                dto.setPrice8(price8Map.getOrDefault(dto.getItemCode(), null));
                dto.setId(itemIdMap.getOrDefault(dto.getItemCode(), null));
                dto.setUom(uomMap.getOrDefault(dto.getItemCode(), null));
                dto.setCurrCode(currMap.getOrDefault(dto.getItemCode(), null));
                dto.setItemName(itemNameMap.getOrDefault(dto.getItemCode(), null));
            }
        });
        Map<String, String> uomUdcMap = this.sysUdcService.getCodeMap("COM", "UOM").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        priItemPricePagingVOList.forEach(dto -> {
            if (StringUtils.isNotBlank((CharSequence)dto.getUom())) {
                dto.setUomName(uomUdcMap.getOrDefault(dto.getUom(), null));
            }
        });
    }

    public PriExcelServiceImpl(PriMainPriceRowService priMainPriceRowService, ItmItemRepoProc itmItemRepoProc, PriMainPriceRowRepoProc priMainPriceRowRepoProc, UdcService sysUdcService) {
        this.priMainPriceRowService = priMainPriceRowService;
        this.itmItemRepoProc = itmItemRepoProc;
        this.priMainPriceRowRepoProc = priMainPriceRowRepoProc;
        this.sysUdcService = sysUdcService;
    }
}

