/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.pri.service.impl;

import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.supportdomain.item.dto.ItmItemDTO;
import com.elitesland.yst.supportdomain.item.service.ItmItemService;
import com.elitesland.yst.supportdomain.org.repo.OrgBuRepo;
import com.elitesland.yst.supportdomain.pri.convert.PriMainPriceAlterDConvert;
import com.elitesland.yst.supportdomain.pri.entity.PriMainPriceAlterDRowDO;
import com.elitesland.yst.supportdomain.pri.entity.PriMainPriceRowDO;
import com.elitesland.yst.supportdomain.pri.enums.PriMainPriceUdcEnum;
import com.elitesland.yst.supportdomain.pri.param.PriItemPriceSaveRowParam;
import com.elitesland.yst.supportdomain.pri.param.PriMainPriceAlterSaveRowParam;
import com.elitesland.yst.supportdomain.pri.repo.PriMainPriceAlterDRowRepo;
import com.elitesland.yst.supportdomain.pri.repo.PriMainPriceRowRepo;
import com.elitesland.yst.supportdomain.pri.repo.PriMainPriceRowRepoProc;
import com.elitesland.yst.supportdomain.pri.service.PriMainPriceAlterDRowService;
import com.elitesland.yst.supportdomain.pri.vo.PriItemPricePagingVO;
import com.elitesland.yst.supportdomain.util.ComUdcEnum;
import com.elitesland.yst.system.vo.SysUserDTO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PriMainPriceAlterDRowServiceImpl
implements PriMainPriceAlterDRowService {
    private final PriMainPriceAlterDRowRepo priMainPriceAlterDRowRepo;
    private final PriMainPriceRowRepo priMainPriceRowRepo;
    private final PriMainPriceRowRepoProc priMainPriceRowRepoProc;
    private final OrgBuRepo orgBuRepo;
    private final ItmItemService itmItemService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void priceUpdate(PriMainPriceAlterSaveRowParam param, Long masId, String priceStatus) {
        List<Object> priMainPriceAlterDRowDOs = new ArrayList();
        if (CollectionUtils.isNotEmpty(param.getPriItemPriceSaveRowParams())) {
            priMainPriceAlterDRowDOs = PriMainPriceAlterDConvert.INSTANCE.priceSaveRowToAlterRowList(param.getPriItemPriceSaveRowParams());
        }
        if (CollectionUtils.isNotEmpty(param.getPriCatePriceSaveRowParams())) {
            priMainPriceAlterDRowDOs = PriMainPriceAlterDConvert.INSTANCE.catePriceSaveRowToAlterRowSingle(param.getPriCatePriceSaveRowParams());
        }
        priMainPriceAlterDRowDOs = priMainPriceAlterDRowDOs.stream().peek(s -> s.setMasId(masId)).collect(Collectors.toList());
        this.priMainPriceAlterDRowRepo.deleteAllByMasId(masId);
        this.priMainPriceAlterDRowRepo.saveAll(priMainPriceAlterDRowDOs);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void priceSave(PriMainPriceAlterSaveRowParam param, Long masId, String priceStatus) {
        List<Object> priMainPriceAlterDRowDOs = new ArrayList();
        if (CollectionUtils.isNotEmpty(param.getPriItemPriceSaveRowParams())) {
            List<PriItemPriceSaveRowParam> priItemPriceSaveRowParams = param.getPriItemPriceSaveRowParams();
            List<String> itemCodes = priItemPriceSaveRowParams.stream().map(PriItemPriceSaveRowParam::getItemCode).collect(Collectors.toList());
            Map<String, Long> secOuIdMap = this.itmItemService.findItemDtoByItemCodes(itemCodes).stream().collect(Collectors.toMap(ItmItemDTO::getItemCode, ItmItemDTO::getSecOuId, (t1, t2) -> t1));
            List<PriItemPricePagingVO> result = this.priMainPriceRowRepoProc.searchMainPrice(priItemPriceSaveRowParams.stream().filter(s -> s.getPriMainPriceId() == null).map(s -> s.getItemCode()).distinct().collect(Collectors.toList()), true);
            priItemPriceSaveRowParams.stream().peek(s -> result.forEach(t -> {
                if (s.getItemCode().equals(t.getItemCode())) {
                    s.setPriMainPriceId(t.getId());
                }
            })).collect(Collectors.toList());
            priMainPriceAlterDRowDOs = PriMainPriceAlterDConvert.INSTANCE.priceSaveRowToAlterRowList(priItemPriceSaveRowParams);
            priMainPriceAlterDRowDOs.stream().peek(s -> {
                s.setPriceType(PriMainPriceUdcEnum.PRI_PRICE_TYPE_ITEM_PRICE.getUdcVal());
                s.setSecOuId((Long)secOuIdMap.get(s.getItemCode()));
                if (s.getValidTo() != null) {
                    s.setValidTo(LocalDateTime.of(s.getValidTo().toLocalDate(), LocalTime.MIN));
                }
            }).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(param.getPriCatePriceSaveRowParams())) {
            priMainPriceAlterDRowDOs = PriMainPriceAlterDConvert.INSTANCE.catePriceSaveRowToAlterRowSingle(param.getPriCatePriceSaveRowParams());
            priMainPriceAlterDRowDOs.stream().peek(s -> s.setPriceType(PriMainPriceUdcEnum.PRI_PRICE_TYPE_ITEM_CAT_PRICE.getUdcVal())).collect(Collectors.toList());
        }
        priMainPriceAlterDRowDOs.stream().peek(s -> {
            s.setMasId(masId);
            if (s.getValidTo() != null) {
                s.setValidTo(LocalDateTime.of(s.getValidTo().toLocalDate(), LocalTime.MIN));
            }
        }).collect(Collectors.toList());
        this.priMainPriceAlterDRowRepo.saveAll(priMainPriceAlterDRowDOs);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMainPriceAlterMethod(List<PriMainPriceAlterDRowDO> priMainPriceAlterDRowDOs, String priceType) {
        priMainPriceAlterDRowDOs = this.priceAlterChange(priMainPriceAlterDRowDOs, priceType);
        priMainPriceAlterDRowDOs.stream().filter(t -> t.getPriMainPriceId() != null).map(s -> s.getPriMainPriceId()).distinct().forEach(this.priMainPriceRowRepoProc::deleteById);
        ArrayList priMainPriceRowSingleDOs = priMainPriceAlterDRowDOs.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PriMainPriceAlterDRowDO>(Comparator.comparing(s -> s.getValidFrom() + ";" + s.getValidTo() + ";" + s.getItemCode() + ";" + s.getItemCateCode()))), ArrayList::new));
        List<PriMainPriceRowDO> priMainPriceRowDOs = PriMainPriceAlterDConvert.INSTANCE.alterRowToPriceList(priMainPriceRowSingleDOs);
        priMainPriceRowDOs.stream().peek(s -> s.setModifyTime(LocalDateTime.now())).collect(Collectors.toList());
        this.priMainPriceRowRepo.saveAll(priMainPriceRowDOs);
    }

    public List<PriMainPriceAlterDRowDO> priceAlterChange(List<PriMainPriceAlterDRowDO> priMainPriceAlterDRowDOs, String priceType) {
        ArrayList<PriMainPriceAlterDRowDO> priMainPriceRowDOList = new ArrayList<PriMainPriceAlterDRowDO>();
        priMainPriceAlterDRowDOs.forEach(param -> {
            LocalDateTime changeValidFrom = LocalDateTime.of(param.getValidFrom().toLocalDate(), LocalTime.MIN);
            LocalDateTime changeValidTo = LocalDateTime.of(param.getValidTo().toLocalDate(), LocalTime.MIN);
            long changeValidFromLong = changeValidFrom.toLocalDate().atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
            long changeValidToLong = changeValidTo.toLocalDate().atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
            ArrayList<PriMainPriceRowDO> oldPriMainPriceRowDOs = new ArrayList();
            if (param.getPriMainPriceId() != null) {
                Optional priMainPriceOptional = this.priMainPriceRowRepo.findById(param.getPriMainPriceId());
                LocalDateTime priceValidFrom = LocalDateTime.of(((PriMainPriceRowDO)priMainPriceOptional.get()).getCreateTime().toLocalDate(), LocalTime.MIN);
                oldPriMainPriceRowDOs = StringUtils.isBlank((CharSequence)param.getItemCode()) ? oldPriMainPriceRowDOs : this.priMainPriceRowRepoProc.findByParam(param.getItemCode(), priceValidFrom, null, null);
                oldPriMainPriceRowDOs = StringUtils.isBlank((CharSequence)param.getItemCateCode()) ? oldPriMainPriceRowDOs : this.priMainPriceRowRepoProc.findByParam(null, priceValidFrom, null, param.getItemCateCode());
            } else {
                PriMainPriceRowDO priMainPriceRowDO = PriMainPriceAlterDConvert.INSTANCE.alterRowToPriceSingle((PriMainPriceAlterDRowDO)param);
                oldPriMainPriceRowDOs = Collections.singletonList(priMainPriceRowDO);
            }
            this.priceAlterCommonMethod((List<PriMainPriceRowDO>)oldPriMainPriceRowDOs, param.getMasId(), (PriMainPriceAlterDRowDO)param, changeValidFrom, changeValidTo, changeValidFromLong, changeValidToLong, (List<PriMainPriceAlterDRowDO>)priMainPriceRowDOList, priceType);
        });
        return priMainPriceRowDOList;
    }

    private List<PriMainPriceAlterDRowDO> priceAlterCommonMethod(List<PriMainPriceRowDO> oldPriMainPriceRowDOs, Long masId, PriMainPriceAlterDRowDO newPriMainPriceAlterDRowDOTwo, LocalDateTime changeValidFrom, LocalDateTime changeValidTo, Long changeValidFromLong, Long changeValidToLong, List<PriMainPriceAlterDRowDO> priMainPriceRowDOList, String priceType) {
        oldPriMainPriceRowDOs.forEach(oldPriMainPriceRowDO -> {
            LocalDateTime oldValidFrom = oldPriMainPriceRowDO.getValidFrom();
            LocalDateTime oldValidTo = oldPriMainPriceRowDO.getValidTo();
            long oldValidFromLong = oldPriMainPriceRowDO.getValidFrom().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            long oldValidToLong = oldPriMainPriceRowDO.getValidTo().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            PriMainPriceAlterDRowDO newPriMainPriceAlterDRowDOOne = PriMainPriceAlterDConvert.INSTANCE.priceToAlterRowSingle((PriMainPriceRowDO)oldPriMainPriceRowDO).setMasId(masId);
            newPriMainPriceAlterDRowDOOne.setPriMainPriceId(oldPriMainPriceRowDO.getId());
            newPriMainPriceAlterDRowDOOne.setId(null);
            newPriMainPriceAlterDRowDOOne.setPriceStatus(ComUdcEnum.COM_ACTIVE.getUdcVal());
            newPriMainPriceAlterDRowDOOne.setPriceType(priceType);
            newPriMainPriceAlterDRowDOTwo.setValidFrom(changeValidFrom);
            newPriMainPriceAlterDRowDOTwo.setValidTo(changeValidTo);
            newPriMainPriceAlterDRowDOTwo.setPriceStatus(ComUdcEnum.COM_ACTIVE.getUdcVal());
            newPriMainPriceAlterDRowDOTwo.setPriceType(priceType);
            if (changeValidToLong < oldValidFromLong || changeValidFromLong > oldValidToLong) {
                newPriMainPriceAlterDRowDOOne = changeValidTo.isEqual(oldValidFrom) ? newPriMainPriceAlterDRowDOOne.setValidFrom(oldValidFrom.plusDays(1L)) : newPriMainPriceAlterDRowDOOne;
                newPriMainPriceAlterDRowDOOne = changeValidFrom.isEqual(oldValidTo) ? newPriMainPriceAlterDRowDOOne.setValidTo(oldValidTo.plusDays(-1L)) : newPriMainPriceAlterDRowDOOne;
                PriMainPriceAlterDRowDO priMainPriceDO = ((PriMainPriceAlterDRowDO)SerializationUtils.clone((Serializable)newPriMainPriceAlterDRowDOTwo)).setPriMainPriceId(null);
                priMainPriceRowDOList.add(priMainPriceDO);
            }
            if (changeValidFrom.isAfter(oldValidFrom) && changeValidFromLong <= oldValidToLong && changeValidTo.isAfter(oldValidTo)) {
                newPriMainPriceAlterDRowDOOne.setValidTo(changeValidFrom.plusDays(-1L));
                priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOOne);
                priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOTwo);
            }
            if (changeValidFrom.isBefore(oldValidFrom) && changeValidToLong >= oldValidFromLong && changeValidTo.isBefore(oldValidTo)) {
                newPriMainPriceAlterDRowDOOne.setValidFrom(changeValidTo.plusDays(1L));
                priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOOne);
                priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOTwo);
            }
            if (changeValidFromLong <= oldValidFromLong && changeValidToLong >= oldValidToLong) {
                priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOTwo);
            }
            if (oldValidFromLong <= changeValidFromLong && changeValidToLong <= oldValidToLong) {
                if (oldValidFromLong == changeValidFromLong && changeValidToLong == oldValidToLong) {
                    priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOTwo);
                }
                if (oldValidFromLong == changeValidFromLong && changeValidToLong < oldValidToLong) {
                    priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOOne.setValidFrom(changeValidTo.plusDays(1L)));
                    priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOTwo);
                }
                if (oldValidFromLong < changeValidFromLong && changeValidToLong == oldValidToLong) {
                    priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOOne.setValidTo(changeValidFrom.plusDays(-1L)));
                    priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOTwo);
                }
                if (oldValidFromLong < changeValidFromLong && changeValidToLong < oldValidToLong) {
                    PriMainPriceAlterDRowDO newPriMainPriceAlterDRowDOThree = (PriMainPriceAlterDRowDO)SerializationUtils.clone((Serializable)newPriMainPriceAlterDRowDOOne);
                    newPriMainPriceAlterDRowDOOne.setValidTo(changeValidFrom.plusDays(-1L));
                    newPriMainPriceAlterDRowDOThree.setValidFrom(changeValidTo.plusDays(1L));
                    priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOOne);
                    priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOThree);
                    priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOTwo);
                }
            }
        });
        return priMainPriceRowDOList;
    }

    private SysUserDTO getUserInfo() {
        SysUserDTO sysUserDTO = new SysUserDTO();
        GeneralUserDetails generalUserDetails = SecurityUtil.getUser();
        if (generalUserDetails != null && generalUserDetails.getUser() != null) {
            sysUserDTO = generalUserDetails.getUser();
        }
        return sysUserDTO;
    }

    public PriMainPriceAlterDRowServiceImpl(PriMainPriceAlterDRowRepo priMainPriceAlterDRowRepo, PriMainPriceRowRepo priMainPriceRowRepo, PriMainPriceRowRepoProc priMainPriceRowRepoProc, OrgBuRepo orgBuRepo, ItmItemService itmItemService) {
        this.priMainPriceAlterDRowRepo = priMainPriceAlterDRowRepo;
        this.priMainPriceRowRepo = priMainPriceRowRepo;
        this.priMainPriceRowRepoProc = priMainPriceRowRepoProc;
        this.orgBuRepo = orgBuRepo;
        this.itmItemService = itmItemService;
    }
}

