/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.pri.service.impl;

import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.comm.consumer.dto.ComCurrRpcDTO;
import com.elitesland.yst.comm.consumer.param.ComCurrRpcDtoParam;
import com.elitesland.yst.comm.consumer.service.ComCurrRpcService;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.org.entity.OrgEmpDO;
import com.elitesland.yst.supportdomain.org.repo.OrgBuRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgEmpRepo;
import com.elitesland.yst.supportdomain.org.service.OrgEmpBuService;
import com.elitesland.yst.supportdomain.org.vo.OrgEmpBuVO;
import com.elitesland.yst.supportdomain.pri.convert.PriMainPriceAlterConvert;
import com.elitesland.yst.supportdomain.pri.entity.PriMainPriceAlterDO;
import com.elitesland.yst.supportdomain.pri.entity.PriMainPriceAlterDRowDO;
import com.elitesland.yst.supportdomain.pri.entity.QPriMainPriceAlterDO;
import com.elitesland.yst.supportdomain.pri.enums.PriMainPriceUdcEnum;
import com.elitesland.yst.supportdomain.pri.param.PriItemPriceSaveRowParam;
import com.elitesland.yst.supportdomain.pri.param.PriMainPriceAlterPagingParam;
import com.elitesland.yst.supportdomain.pri.param.PriMainPriceAlterSaveParam;
import com.elitesland.yst.supportdomain.pri.param.PriMainPriceAlterSaveRowParam;
import com.elitesland.yst.supportdomain.pri.repo.PriMainPriceAlterDRowRepo;
import com.elitesland.yst.supportdomain.pri.repo.PriMainPriceAlterDRowRepoProc;
import com.elitesland.yst.supportdomain.pri.repo.PriMainPriceAlterRepo;
import com.elitesland.yst.supportdomain.pri.repo.PriMainPriceAlterRepoProc;
import com.elitesland.yst.supportdomain.pri.service.PriMainPriceAlterDRowService;
import com.elitesland.yst.supportdomain.pri.service.PriMainPriceAlterService;
import com.elitesland.yst.supportdomain.pri.service.PriMainPriceService;
import com.elitesland.yst.supportdomain.pri.service.PriPriceChangeService;
import com.elitesland.yst.supportdomain.pri.vo.PriCatePricePagingVO;
import com.elitesland.yst.supportdomain.pri.vo.PriItemPricePagingVO;
import com.elitesland.yst.supportdomain.pri.vo.PriMainPriceAlterDetailVO;
import com.elitesland.yst.supportdomain.pri.vo.PriMainPriceAlterPagingVO;
import com.elitesland.yst.supportdomain.util.ComUdcEnum;
import com.elitesland.yst.supportdomain.workflow.ProcDefKey;
import com.elitesland.yst.system.vo.SysUserDTO;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StringUtils;

@Service
public class PriMainPriceAlterServiceImpl
implements PriMainPriceAlterService {
    private static final Logger log = LoggerFactory.getLogger(PriMainPriceAlterServiceImpl.class);
    private final PriMainPriceAlterRepo priMainPriceAlterRepo;
    private final PriMainPriceAlterRepoProc priMainPriceAlterRepoProc;
    private final PriMainPriceAlterDRowRepoProc priMainPriceAlterDRowRepoProc;
    private final PriMainPriceAlterDRowService priMainPriceAlterDRowService;
    private final OrgEmpRepo orgEmpRepo;
    private final OrgBuRepo orgBuRepo;
    private final ItmItemCateService itmItemCateService;
    private final PriMainPriceAlterDRowRepo priMainPriceAlterDRowRepo;
    private final ItmItemRepoProc itmItemRepoProc;
    private final PriMainPriceService priMainPriceService;
    private final PriPriceChangeService priPriceChangeService;
    private final OrgEmpBuService orgEmpBuService;
    @DubboReference
    private WorkflowService workflowService;
    private final JPAQueryFactory jpaQueryFactory;
    @DubboReference
    private ComCurrRpcService comCurrRpcService;
    private final PlatformTransactionManager platformTransactionManager;
    private final RedissonClient redissonClient;
    private final TransactionTemplate transactionTemplate;

    @Override
    @SysCodeProc
    public PagingVO<PriMainPriceAlterPagingVO> searchByParams(PriMainPriceAlterPagingParam param) {
        if (param.getApplyDateFrom() != null && param.getApplyDateTo() != null && param.getApplyDateFrom().equals(param.getApplyDateTo())) {
            LocalDateTime today_end = LocalDateTime.of(param.getApplyDateTo().toLocalDate(), LocalTime.MAX);
            param.setApplyDateTo(today_end);
        }
        return this.priMainPriceAlterRepoProc.searchByParams(param);
    }

    @Override
    @SysCodeProc
    public PriMainPriceAlterDetailVO getDetailsById(Long id) {
        Optional optional = this.priMainPriceAlterRepo.findById(id);
        if (optional.isEmpty()) {
            throw new BusinessException("\u5355\u636e\u4e0d\u5b58\u5728");
        }
        PriMainPriceAlterDO priMainPriceAlterDO = (PriMainPriceAlterDO)optional.get();
        PriMainPriceAlterDetailVO priMainPriceAlterDetailVO = new PriMainPriceAlterDetailVO();
        priMainPriceAlterDetailVO.setId(id);
        priMainPriceAlterDetailVO.setDocNo(priMainPriceAlterDO.getDocNo());
        priMainPriceAlterDetailVO.setDocType(priMainPriceAlterDO.getDocType());
        priMainPriceAlterDetailVO.setApplyDesc(priMainPriceAlterDO.getApplyDesc());
        priMainPriceAlterDetailVO.setDocStatus(priMainPriceAlterDO.getDocStatus());
        priMainPriceAlterDetailVO.setProcInstId(priMainPriceAlterDO.getProcInstId());
        priMainPriceAlterDetailVO.setProcInstStatus(priMainPriceAlterDO.getProcInstStatus());
        priMainPriceAlterDetailVO.setSubmitTime(priMainPriceAlterDO.getSubmitTime());
        priMainPriceAlterDetailVO.setApprovedTime(priMainPriceAlterDO.getApprovedTime());
        if (ComUdcEnum.COM_MAIN_PRICE_APPLY_TYPE_SPA.getUdcVal().equals(priMainPriceAlterDO.getDocType())) {
            ComCurrRpcDtoParam currParam;
            List currDtos;
            List<PriItemPricePagingVO> itemPriceVO = this.priMainPriceAlterDRowRepoProc.selectItemPriceAlert(id);
            List<PriItemPricePagingVO> itemAndCatePriceVO = this.searchCatePrice(itemPriceVO);
            List currCodes = itemAndCatePriceVO.stream().map(PriItemPricePagingVO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(currCodes) && CollectionUtils.isNotEmpty((Collection)(currDtos = this.comCurrRpcService.findRpcDtoByParam(currParam = ComCurrRpcDtoParam.builder().currCodes(currCodes).build())))) {
                Map<String, String> currMap = currDtos.stream().collect(Collectors.toMap(ComCurrRpcDTO::getCurrCode, ComCurrRpcDTO::getCurrName));
                itemAndCatePriceVO.forEach(dto -> {
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dto.getCurrCode())) {
                        dto.setCurrName(currMap.getOrDefault(dto.getCurrCode(), null));
                    }
                });
            }
            priMainPriceAlterDetailVO.setPriItemPricePagingVOs(itemAndCatePriceVO);
        }
        if (ComUdcEnum.COM_MAIN_PRICE_APPLY_TYPE_CGPA.getUdcVal().equals(priMainPriceAlterDO.getDocType())) {
            List<PriCatePricePagingVO> catePriceVO = this.priMainPriceAlterDRowRepoProc.selectCatePriceAlert(id);
            for (PriCatePricePagingVO record : catePriceVO) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)record.getItemCateCode())) continue;
                record.setItemCatePath(this.itmItemCateService.findItemCatePath(record.getItemCateCode()));
            }
            priMainPriceAlterDetailVO.setPriCatePricePagingVOs(catePriceVO);
        }
        return priMainPriceAlterDetailVO;
    }

    public Long saveOrUpdate(PriMainPriceAlterSaveParam param) {
        PriMainPriceAlterDO priMainPriceAlterDO = PriMainPriceAlterConvert.INSTANCE.saveParamToDo(param);
        priMainPriceAlterDO.setApplyDate(LocalDateTime.now());
        PriMainPriceAlterDO result = (PriMainPriceAlterDO)this.priMainPriceAlterRepo.save(priMainPriceAlterDO);
        return result.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void savePriceAlterRow(PriMainPriceAlterSaveRowParam param) {
        this.transactionTemplate.setPropagationBehavior(3);
        PriMainPriceAlterDO execute = (PriMainPriceAlterDO)this.transactionTemplate.execute(transactionStatus -> {
            try {
                return this.savPriceRow(param);
            }
            catch (Exception e) {
                log.error(" \u4ef7\u683c\u7533\u8bf7error:", (Throwable)e);
                transactionStatus.setRollbackOnly();
                throw new BusinessException(ApiCode.FAIL, e.getMessage());
            }
        });
        if (param.getDocStatus().equals(ComUdcEnum.COM_APPLY_STATUS_DOING.getUdcVal())) {
            assert (execute != null);
            this.workFlow(param, execute);
        }
    }

    private PriMainPriceAlterDO savPriceRow(PriMainPriceAlterSaveRowParam param) {
        PriMainPriceAlterDO saveDO;
        String docNo = param.getDocNo();
        RLock rLock = this.redissonClient.getLock(docNo);
        try {
            if (!rLock.tryLock(0L, 20L, TimeUnit.SECONDS)) {
                log.error("\u83b7\u53d6\u9501\u5931\u8d25");
                throw new BusinessException("\u5355\u636e\u91cd\u590d\u63d0\u4ea4\uff1a:" + docNo);
            }
            saveDO = this.saveOrUpdateRow(param);
            try {
                String priceStatus;
                String string = priceStatus = ComUdcEnum.COM_APPLY_STATUS_COMPLETE.getUdcVal().equals(param.getDocStatus()) ? ComUdcEnum.COM_ACTIVE.getUdcVal() : ComUdcEnum.COM_INACTIVE.getUdcVal();
                if (param.getId() != null && param.getId() != 0L) {
                    this.priMainPriceAlterDRowService.priceUpdate(param, saveDO.getId(), priceStatus);
                } else {
                    this.priceUploadCheck(param.getPriItemPriceSaveRowParams());
                    this.priMainPriceAlterDRowService.priceSave(param, saveDO.getId(), priceStatus);
                }
            }
            catch (Exception e) {
                log.error("\u4ef7\u683c\u5355\u636e\u5185\u6570\u636e\u53d8\u66f4\u5931\u8d25\uff1a" + e);
                throw new BusinessException("\u4ef7\u683c\u5355\u636e\u5185\u6570\u636e\u53d8\u66f4\u5931\u8d25\uff1a" + e);
            }
            if (!rLock.isHeldByCurrentThread()) {
                log.error("\u6301\u6709\u9501\u5df2\u8fc7\u671f");
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6301\u6709\u9501\u5df2\u8fc7\u671f\uff01");
            }
        }
        catch (BusinessException | InterruptedException e) {
            log.error("\u5355\u636e\u63d0\u4ea4/\u4fdd\u5b58\u5931\u8d25\uff1a" + (Exception)e);
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
        finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }
        return saveDO;
    }

    private void workFlow(PriMainPriceAlterSaveRowParam param, PriMainPriceAlterDO saveDO) {
        SysUserDTO user = null;
        GeneralUserDetails generalUserDetails = SecurityUtil.getUser();
        if (generalUserDetails == null || generalUserDetails.getUser() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u5230\u83b7\u53d6\u5f53\u524d\u7528\u6237");
        }
        user = generalUserDetails.getUser();
        if (param.getId() == null || saveDO.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(saveDO.getProcInstStatus())) {
            String procInstName = "\u5546\u54c1\u4ef7\u683c\u5ba1\u6838-" + saveDO.getDocNo();
            ProcessInfo processInfo = this.workflowService.startProcess(ProcDefKey.ITEM_PRICE_CHANGE.name(), procInstName, "" + saveDO.getId(), null);
            QPriMainPriceAlterDO qPriMainPriceAlterDO = QPriMainPriceAlterDO.priMainPriceAlterDO;
            JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qPriMainPriceAlterDO).set((Path)qPriMainPriceAlterDO.procInstId, (Object)processInfo.getProcInstId()).set(qPriMainPriceAlterDO.submitTime, (Object)LocalDateTime.now()).where(new Predicate[]{qPriMainPriceAlterDO.id.eq((Object)saveDO.getId())});
            if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
                jpaUpdateClause.set(qPriMainPriceAlterDO.procInstStatus, (Object)ProcInstStatus.APPROVING);
                jpaUpdateClause.set((Path)qPriMainPriceAlterDO.docStatus, (Object)"DOING");
            }
            jpaUpdateClause.execute();
        }
    }

    public PriMainPriceAlterDO saveOrUpdateRow(PriMainPriceAlterSaveRowParam param) {
        SysUserDTO userInfo;
        List ouIds;
        List<OrgEmpBuVO> orgEmpBuVos = this.getEmpBuDetail();
        List buIds = orgEmpBuVos.stream().map(s -> s.getEmpBuId()).collect(Collectors.toList());
        PriMainPriceAlterDO priMainPriceAlterDO = PriMainPriceAlterConvert.INSTANCE.saveParamToDoRow(param);
        priMainPriceAlterDO.setApplyDate(LocalDateTime.now());
        if (CollectionUtils.isNotEmpty(buIds) && CollectionUtils.isNotEmpty(ouIds = this.orgBuRepo.findAllById(buIds).stream().map(s -> s.getOuId()).collect(Collectors.toList()))) {
            priMainPriceAlterDO.setOuId((Long)ouIds.get(0));
            priMainPriceAlterDO.setSecOuId((Long)ouIds.get(0));
        }
        if ((userInfo = this.getUserInfo()).getId() != null) {
            priMainPriceAlterDO.setCreateUserId(userInfo.getId());
            priMainPriceAlterDO.setCreator(userInfo.getUsername());
        }
        PriMainPriceAlterDO result = (PriMainPriceAlterDO)this.priMainPriceAlterRepo.save(priMainPriceAlterDO);
        return result;
    }

    @Override
    public void priceSaveCheckRow(List<Long> priMainPriceIds) {
        List masIds;
        List priMainPriceAlterDOs;
        List docStatusList;
        List<PriMainPriceAlterDRowDO> priMainPriceAlterDRowDOs = this.priMainPriceAlterDRowRepoProc.selectPriMainPriceAlterD(priMainPriceIds);
        if (CollectionUtils.isNotEmpty(priMainPriceAlterDRowDOs) && ((docStatusList = (priMainPriceAlterDOs = this.priMainPriceAlterRepo.findAllById(masIds = priMainPriceAlterDRowDOs.stream().map(s -> s.getMasId()).distinct().collect(Collectors.toList()))).stream().map(s -> s.getDocStatus()).distinct().collect(Collectors.toList())).contains(ComUdcEnum.COM_APPLY_STATUS_DRAFT.getUdcVal()) || docStatusList.contains(ComUdcEnum.COM_APPLY_STATUS_DOING.getUdcVal()) || docStatusList.contains(ComUdcEnum.COM_APPLY_STATUS_REJECTED.getUdcVal()))) {
            throw new BusinessException("\u5df2\u5b58\u5728\u4ef7\u683c\u53d8\u66f4\u5355\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u53d8\u66f4");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void priMainPriceAlterDelete(List<Long> masIds) {
        ArrayList<String> priceStatus = new ArrayList<String>();
        priceStatus.add(ComUdcEnum.COM_APPLY_STATUS_DRAFT.getUdcVal());
        priceStatus.add(ComUdcEnum.COM_APPLY_STATUS_REJECTED.getUdcVal());
        List priMainPriceAlterDOs = this.priMainPriceAlterRepo.findAllById(masIds);
        priMainPriceAlterDOs.forEach(s -> {
            if (!priceStatus.contains(s.getDocStatus())) {
                throw new BusinessException("\u5355\u636e\u72b6\u6001\u65e0\u6cd5\u4f5c\u5e9f");
            }
            if (!StringUtils.isEmpty((Object)s.getProcInstId()) && WorkflowConstant.CAN_DELETE_PROC.contains(s.getProcInstStatus())) {
                SysUserDTO user = null;
                GeneralUserDetails generalUserDetails = SecurityUtil.getUser();
                if (generalUserDetails == null || generalUserDetails.getUser() == null) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u5230\u83b7\u53d6\u5f53\u524d\u7528\u6237");
                }
                user = generalUserDetails.getUser();
                this.workflowService.deleteProcess(s.getProcInstId(), user.getId().longValue(), "\u4e1a\u52a1\u5355\u636e\u4f5c\u5e9f");
            }
        });
        this.priMainPriceAlterRepoProc.priceAlterDelete(masIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void priceAlterStatusUpdate(List<Long> masIds, String docStatus, String applyComment) {
        List priMainPriceAlterDOs = this.priMainPriceAlterRepo.findAllById(masIds);
        priMainPriceAlterDOs.forEach(s -> {
            if (ComUdcEnum.COM_APPLY_STATUS_COMPLETE.getUdcVal().equals(docStatus) || ComUdcEnum.COM_APPLY_STATUS_REJECTED.getUdcVal().equals(docStatus)) {
                if (!ComUdcEnum.COM_APPLY_STATUS_DOING.getUdcVal().equals(s.getDocStatus())) {
                    throw new BusinessException("\u4ec5\u5ba1\u6279\u4e2d\u7684\u5355\u636e\u53ef\u64cd\u4f5c");
                }
                if (ComUdcEnum.COM_APPLY_STATUS_COMPLETE.getUdcVal().equals(docStatus)) {
                    List<PriMainPriceAlterDRowDO> priMainPriceAlterDRowDOs = this.priMainPriceAlterDRowRepo.findAllByMasId(s.getId());
                    String priceType = ComUdcEnum.COM_MAIN_PRICE_APPLY_TYPE_CGPA.getUdcVal().equals(s.getDocType()) ? PriMainPriceUdcEnum.PRI_PRICE_TYPE_ITEM_CAT_PRICE.getUdcVal() : PriMainPriceUdcEnum.PRI_PRICE_TYPE_ITEM_PRICE.getUdcVal();
                    this.priPriceChangeService.updateMainPriceAlterMethod(priMainPriceAlterDRowDOs, priceType);
                }
            }
        });
        this.priMainPriceAlterRepoProc.priceAlterStatusUpdate(masIds, docStatus, applyComment);
    }

    private OrgEmpDO getOrgEmpDO() {
        GeneralUserDetails generalUserDetails = SecurityUtil.getUser();
        if (generalUserDetails != null && generalUserDetails.getUser() != null) {
            long userId = generalUserDetails.getUser().getId() == null ? 396329733548154880L : generalUserDetails.getUser().getId();
            Optional<OrgEmpDO> orgEmpOptional = this.orgEmpRepo.findByUserId(userId);
            if (orgEmpOptional.isPresent()) {
                return orgEmpOptional.get();
            }
            return null;
        }
        return null;
    }

    private SysUserDTO getUserInfo() {
        SysUserDTO sysUserDTO = new SysUserDTO();
        GeneralUserDetails generalUserDetails = SecurityUtil.getUser();
        if (generalUserDetails != null && generalUserDetails.getUser() != null) {
            sysUserDTO = generalUserDetails.getUser();
        }
        return sysUserDTO;
    }

    private List<PriItemPricePagingVO> searchCatePrice(List<PriItemPricePagingVO> itemPriceVO) {
        List<String> itemCodes = itemPriceVO.stream().map(PriItemPricePagingVO::getItemCode).collect(Collectors.toList());
        List<Tuple> itemCateCodeTuple = this.itmItemRepoProc.searchItemCateCodeByItemCode(itemCodes);
        List<PriItemPricePagingVO> itemAndCatePriceVO = itemPriceVO.stream().map(t -> {
            itemCateCodeTuple.forEach(s -> {
                if (t.getItemCode().equals(s.get(1, String.class))) {
                    t.setItemCateCode((String)s.get(0, String.class));
                }
            });
            return t;
        }).collect(Collectors.toList());
        Map<String, PriCatePricePagingVO> catePriceMap = this.priMainPriceService.priCatePriceQuery(itemAndCatePriceVO.stream().map(s -> s.getItemCateCode()).collect(Collectors.toList())).stream().collect(Collectors.toMap(PriCatePricePagingVO::getItemCateCode, t -> t));
        itemAndCatePriceVO.forEach(s -> {
            if (catePriceMap.containsKey(s.getItemCateCode())) {
                PriCatePricePagingVO catePrice = (PriCatePricePagingVO)catePriceMap.get(s.getItemCateCode());
                s.setCatePrice4(catePrice.getPrice4());
                s.setCatePrice5(catePrice.getPrice5());
            }
        });
        return itemAndCatePriceVO;
    }

    public void priceUploadCheck(List<PriItemPriceSaveRowParam> priItemPriceSaveRowParams) {
        StringBuilder str = new StringBuilder();
        priItemPriceSaveRowParams.forEach(param -> {
            List<PriMainPriceAlterDRowDO> priMainPriceAlterDRowDOs = this.priMainPriceAlterDRowRepoProc.selectPriceAlterDByItemCodeAndTime(param.getItemCode(), param.getValidFrom(), param.getValidTo());
            this.priceCheckMethod(priMainPriceAlterDRowDOs, param.getItemCode(), str);
        });
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)str)) {
            throw new BusinessException(str.toString());
        }
    }

    private StringBuilder priceCheckMethod(List<PriMainPriceAlterDRowDO> priMainPriceAlterDRowDOs, String itemCode, StringBuilder str) {
        List masIds;
        List priMainPriceAlterDOs;
        List docStatusList;
        if (CollectionUtils.isNotEmpty(priMainPriceAlterDRowDOs) && ((docStatusList = (priMainPriceAlterDOs = this.priMainPriceAlterRepo.findAllById(masIds = priMainPriceAlterDRowDOs.stream().map(s -> s.getMasId()).distinct().collect(Collectors.toList()))).stream().map(s -> s.getDocStatus()).distinct().collect(Collectors.toList())).contains(ComUdcEnum.COM_APPLY_STATUS_DRAFT.getUdcVal()) || docStatusList.contains(ComUdcEnum.COM_APPLY_STATUS_DOING.getUdcVal()) || docStatusList.contains(ComUdcEnum.COM_APPLY_STATUS_REJECTED.getUdcVal()))) {
            str.append("\u5546\u54c1\u7f16\u53f7:" + itemCode + ",\u5df2\u5b58\u5728\u4ef7\u683c\u53d8\u66f4\u5355\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u53d8\u66f4;");
        }
        return str;
    }

    private List<OrgEmpBuVO> getEmpBuDetail() {
        GeneralUserDetails generalUserDetails = SecurityUtil.getUser();
        if (generalUserDetails != null && generalUserDetails.getUser() != null) {
            Long userId = generalUserDetails.getUser().getId();
            Optional<OrgEmpDO> orgEmpOptional = this.orgEmpRepo.findByUserId(userId);
            if (orgEmpOptional.isPresent()) {
                List<OrgEmpBuVO> orgEmpBuVos = this.orgEmpBuService.findEmpBuVoByEmpIds(Collections.singletonList(orgEmpOptional.get().getId()));
                return orgEmpBuVos;
            }
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u5458\u5de5\u5217\u8868\u4fe1\u606f\u4e3a\u7a7a");
        }
        throw new BusinessException("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f");
    }

    public PriMainPriceAlterServiceImpl(PriMainPriceAlterRepo priMainPriceAlterRepo, PriMainPriceAlterRepoProc priMainPriceAlterRepoProc, PriMainPriceAlterDRowRepoProc priMainPriceAlterDRowRepoProc, PriMainPriceAlterDRowService priMainPriceAlterDRowService, OrgEmpRepo orgEmpRepo, OrgBuRepo orgBuRepo, ItmItemCateService itmItemCateService, PriMainPriceAlterDRowRepo priMainPriceAlterDRowRepo, ItmItemRepoProc itmItemRepoProc, PriMainPriceService priMainPriceService, PriPriceChangeService priPriceChangeService, OrgEmpBuService orgEmpBuService, JPAQueryFactory jpaQueryFactory, PlatformTransactionManager platformTransactionManager, RedissonClient redissonClient, TransactionTemplate transactionTemplate) {
        this.priMainPriceAlterRepo = priMainPriceAlterRepo;
        this.priMainPriceAlterRepoProc = priMainPriceAlterRepoProc;
        this.priMainPriceAlterDRowRepoProc = priMainPriceAlterDRowRepoProc;
        this.priMainPriceAlterDRowService = priMainPriceAlterDRowService;
        this.orgEmpRepo = orgEmpRepo;
        this.orgBuRepo = orgBuRepo;
        this.itmItemCateService = itmItemCateService;
        this.priMainPriceAlterDRowRepo = priMainPriceAlterDRowRepo;
        this.itmItemRepoProc = itmItemRepoProc;
        this.priMainPriceService = priMainPriceService;
        this.priPriceChangeService = priPriceChangeService;
        this.orgEmpBuService = orgEmpBuService;
        this.jpaQueryFactory = jpaQueryFactory;
        this.platformTransactionManager = platformTransactionManager;
        this.redissonClient = redissonClient;
        this.transactionTemplate = transactionTemplate;
    }
}

