/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.pri.service.impl;

import com.elitesland.yst.comm.consumer.dto.ComCurrRpcDTO;
import com.elitesland.yst.comm.consumer.dto.ComTaxRateRpcDTO;
import com.elitesland.yst.comm.consumer.param.ComCurrRpcDtoParam;
import com.elitesland.yst.comm.consumer.param.ComTaxRateRpcDtoParam;
import com.elitesland.yst.comm.consumer.service.ComCurrRpcService;
import com.elitesland.yst.comm.consumer.service.ComTaxRateRpcService;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.pri.enums.PriMainPriceUdcEnum;
import com.elitesland.yst.supportdomain.pri.param.PriMainPriceRowPagingParam;
import com.elitesland.yst.supportdomain.pri.repo.PriMainPriceRowRepoProc;
import com.elitesland.yst.supportdomain.pri.service.PriMainPriceRowService;
import com.elitesland.yst.supportdomain.pri.vo.PriCatePricePagingVO;
import com.elitesland.yst.supportdomain.pri.vo.PriItemPricePagingVO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

@Service
public class PriMainPriceRowServiceImpl
implements PriMainPriceRowService {
    private final PriMainPriceRowRepoProc priMainPriceRowRepoProc;
    private final ItmItemCateService itmItemCateService;
    @DubboReference
    private ComTaxRateRpcService comTaxRateRpcService;
    @DubboReference
    private ComCurrRpcService comCurrRpcService;

    @Override
    @SysCodeProc
    public PagingVO<PriItemPricePagingVO> queryPriItemPriceRowByParams(PriMainPriceRowPagingParam param) {
        List taxRateNoList;
        ComCurrRpcDtoParam currParam;
        List currDtos;
        param.setPriceType(PriMainPriceUdcEnum.PRI_PRICE_TYPE_ITEM_PRICE.getUdcVal());
        PagingVO<PriItemPricePagingVO> result = this.priMainPriceRowRepoProc.searchItemPriceByParams(param);
        List priItemPricePagingVOList = result.getRecords();
        List currResult = result.getRecords();
        List currCodes = currResult.stream().map(PriItemPricePagingVO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(currCodes) && CollectionUtils.isNotEmpty((Collection)(currDtos = this.comCurrRpcService.findRpcDtoByParam(currParam = ComCurrRpcDtoParam.builder().currCodes(currCodes).build())))) {
            Map<String, String> currMap = currDtos.stream().collect(Collectors.toMap(ComCurrRpcDTO::getCurrCode, ComCurrRpcDTO::getCurrName));
            currResult.forEach(dto -> {
                if (StringUtils.isNotBlank((CharSequence)dto.getCurrCode())) {
                    dto.setCurrName(currMap.getOrDefault(dto.getCurrCode(), null));
                }
            });
        }
        if (CollectionUtils.isNotEmpty(taxRateNoList = priItemPricePagingVOList.stream().filter(s -> s.getTaxRateNo2() != null).map(t -> t.getTaxRateNo2()).distinct().collect(Collectors.toList()))) {
            Map<Object, Object> taxMap = Collections.emptyMap();
            ComTaxRateRpcDtoParam taxParam = new ComTaxRateRpcDtoParam();
            taxParam.setTaxRateNos(taxRateNoList);
            List taxDtos = this.comTaxRateRpcService.findTaxRateRpcDtoByParam(taxParam);
            if (CollectionUtils.isNotEmpty((Collection)taxDtos)) {
                taxMap = taxDtos.stream().collect(Collectors.toMap(ComTaxRateRpcDTO::getTaxRateNo, t -> t));
            }
            Map finalTaxMap = taxMap;
            priItemPricePagingVOList.forEach(priItemPricePagingVO -> {
                ComTaxRateRpcDTO tax;
                if (StringUtils.isNotBlank((CharSequence)priItemPricePagingVO.getTaxRateNo2()) && (tax = (ComTaxRateRpcDTO)finalTaxMap.get(priItemPricePagingVO.getTaxRateNo2())) != null) {
                    priItemPricePagingVO.setTaxRate2(BigDecimal.valueOf(tax.getTaxRateValue()));
                }
            });
        }
        return result;
    }

    @Override
    @SysCodeProc
    public PagingVO<PriCatePricePagingVO> queryPriCatePriceRowByParams(PriMainPriceRowPagingParam param) {
        param.setPriceType(PriMainPriceUdcEnum.PRI_PRICE_TYPE_ITEM_CAT_PRICE.getUdcVal());
        PagingVO<PriCatePricePagingVO> result = this.priMainPriceRowRepoProc.searchCatePriceByParams(param);
        for (PriCatePricePagingVO record : result.getRecords()) {
            if (!StringUtils.isNotBlank((CharSequence)record.getItemCateCode())) continue;
            record.setItemCatePath(this.itmItemCateService.findItemCatePath(record.getItemCateCode()));
        }
        return result;
    }

    public PriMainPriceRowServiceImpl(PriMainPriceRowRepoProc priMainPriceRowRepoProc, ItmItemCateService itmItemCateService) {
        this.priMainPriceRowRepoProc = priMainPriceRowRepoProc;
        this.itmItemCateService = itmItemCateService;
    }
}

