/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.pri.service.impl;

import com.elitesland.yst.supportdomain.org.entity.OrgBuDO;
import com.elitesland.yst.supportdomain.org.repo.OrgBuRepo;
import com.elitesland.yst.supportdomain.pri.convert.PriMainPriceConvert;
import com.elitesland.yst.supportdomain.pri.enums.PriMainPriceUdcEnum;
import com.elitesland.yst.supportdomain.pri.param.PriCatePriceSaveRowParam;
import com.elitesland.yst.supportdomain.pri.param.PriItemPriceSaveRowParam;
import com.elitesland.yst.supportdomain.pri.repo.PriMainPriceRowRepo;
import com.elitesland.yst.supportdomain.pri.repo.PriMainPriceRowRepoProc;
import com.elitesland.yst.supportdomain.pri.service.PriMainPriceService;
import com.elitesland.yst.supportdomain.pri.vo.PriCatePricePagingVO;
import com.elitesland.yst.supportdomain.pri.vo.PriItemPricePagingVO;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PriMainPriceServiceImpl
implements PriMainPriceService {
    private final PriMainPriceRowRepoProc priMainPriceRowRepoProc;
    private final PriMainPriceRowRepo priMainPriceRowRepo;
    private final OrgBuRepo orgBuRepo;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void priMainPriceSave(List<PriItemPriceSaveRowParam> priItemPriceSaveRowParams, List<String> itemCodes, String priceStatus) {
        if (CollectionUtils.isNotEmpty(itemCodes)) {
            this.priMainPriceRowRepo.deleteAllByItemCodeIn(itemCodes);
        }
        if (CollectionUtils.isEmpty(priItemPriceSaveRowParams)) {
            return;
        }
        LocalDateTime createTime = LocalDateTime.now();
        List priMainPriceRowDOs = PriMainPriceConvert.INSTANCE.itemToPrice(priItemPriceSaveRowParams).stream().peek(s -> {
            String buCode = s.getBuCode();
            Optional<OrgBuDO> byBuCode = this.orgBuRepo.findByBuCode(buCode);
            if (byBuCode.isPresent()) {
                Long ouId = byBuCode.get().getOuId();
                s.setSecOuId(ouId);
            }
            s.setPriceStatus(priceStatus);
            s.setCreateTime(createTime);
            s.setPriceType(PriMainPriceUdcEnum.PRI_PRICE_TYPE_ITEM_PRICE.getUdcVal());
        }).collect(Collectors.toList());
        this.priMainPriceRowRepo.saveAll(priMainPriceRowDOs);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void priMainPriceDelete(List<String> itemCodes) {
        this.priMainPriceRowRepo.deleteAllByItemCodeIn(itemCodes);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void priCatePriceSave(List<PriCatePriceSaveRowParam> priCatePriceSaveRowParams) {
        List priMainPriceRowDOs = PriMainPriceConvert.INSTANCE.cateToPriceList(priCatePriceSaveRowParams).stream().peek(s -> s.setPriceType(PriMainPriceUdcEnum.PRI_PRICE_TYPE_ITEM_CAT_PRICE.getUdcVal())).collect(Collectors.toList());
        this.priMainPriceRowRepo.saveAll(priMainPriceRowDOs);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void priCatePriceDelete(List<String> itemCateCodes) {
        this.priMainPriceRowRepo.deleteAllByItemCateCodeIn(itemCateCodes);
    }

    @Override
    public List<PriItemPricePagingVO> priMainPriceQuery(List<String> itemCodes, boolean statusBool) {
        if (CollectionUtils.isEmpty(itemCodes)) {
            return null;
        }
        List<PriItemPricePagingVO> result = this.priMainPriceRowRepoProc.searchMainPrice(itemCodes, statusBool);
        return result;
    }

    @Override
    public void updatePriceStatus(List<String> itemCodes, String priceStatus, LocalDateTime validFrom, LocalDateTime validTo) {
        this.priMainPriceRowRepoProc.updatePriceStatus(itemCodes, priceStatus, validFrom, validTo);
    }

    @Override
    public List<PriCatePricePagingVO> priCatePriceQuery(List<String> itemCateCodes) {
        return this.priMainPriceRowRepoProc.searchCatePrice(itemCateCodes);
    }

    public PriMainPriceServiceImpl(PriMainPriceRowRepoProc priMainPriceRowRepoProc, PriMainPriceRowRepo priMainPriceRowRepo, OrgBuRepo orgBuRepo) {
        this.priMainPriceRowRepoProc = priMainPriceRowRepoProc;
        this.priMainPriceRowRepo = priMainPriceRowRepo;
        this.orgBuRepo = orgBuRepo;
    }
}

