/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.pri.service.impl;

import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.supportdomain.item.dto.ItmItemDTO;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepoProc;
import com.elitesland.yst.supportdomain.org.entity.OrgBuDO;
import com.elitesland.yst.supportdomain.org.repo.OrgBuRepo;
import com.elitesland.yst.supportdomain.pri.convert.PriMainPriceAlterDConvert;
import com.elitesland.yst.supportdomain.pri.entity.PriMainPriceAlterDRowDO;
import com.elitesland.yst.supportdomain.pri.entity.PriMainPriceRowDO;
import com.elitesland.yst.supportdomain.pri.enums.PriMainPriceUdcEnum;
import com.elitesland.yst.supportdomain.pri.repo.PriMainPriceRowRepo;
import com.elitesland.yst.supportdomain.pri.repo.PriMainPriceRowRepoProc;
import com.elitesland.yst.supportdomain.pri.service.PriPriceChangeService;
import com.elitesland.yst.supportdomain.util.ComUdcEnum;
import com.elitesland.yst.system.vo.SysUserDTO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PriPriceChangeServiceImpl
implements PriPriceChangeService {
    private final PriMainPriceRowRepo priMainPriceRowRepo;
    private final PriMainPriceRowRepoProc priMainPriceRowRepoProc;
    private final OrgBuRepo orgBuRepo;
    private final ItmItemRepoProc itmItemRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMainPriceAlterMethod(List<PriMainPriceAlterDRowDO> priMainPriceAlterDRowDOs, String priceType) {
        ArrayList<Long> deleteIdList = new ArrayList<Long>();
        ArrayList priMainPriceRowDOList = new ArrayList();
        priMainPriceAlterDRowDOs.forEach(param -> {
            LocalDateTime changeValidFrom = LocalDateTime.of(param.getValidFrom().toLocalDate(), LocalTime.MIN);
            LocalDateTime changeValidTo = param.getValidTo();
            long changeValidFromLong = changeValidFrom.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            long changeValidToLong = changeValidTo.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            List<PriMainPriceRowDO> oldPriMainPriceRowDOs = this.priMainPriceRowRepoProc.findPriMainPriceByParam(param.getItemCode(), param.getItemCateCode());
            if (CollectionUtils.isEmpty(oldPriMainPriceRowDOs)) {
                PriMainPriceRowDO newPriMainPriceAlterDRowDOTwo = PriMainPriceAlterDConvert.INSTANCE.alterRowToPriceSingle((PriMainPriceAlterDRowDO)param);
                newPriMainPriceAlterDRowDOTwo.setId(null);
                priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOTwo);
            }
            oldPriMainPriceRowDOs.forEach(oldPriMainPriceRowDO -> {
                long oldValidFromLong = oldPriMainPriceRowDO.getValidFrom().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
                long oldValidToLong = oldPriMainPriceRowDO.getValidTo().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
                PriMainPriceRowDO newPriMainPriceAlterDRowDOTwo = PriMainPriceAlterDConvert.INSTANCE.alterRowToPriceSingle((PriMainPriceAlterDRowDO)param);
                newPriMainPriceAlterDRowDOTwo.setId(null);
                newPriMainPriceAlterDRowDOTwo.setBuCode(oldPriMainPriceRowDO.getBuCode());
                newPriMainPriceAlterDRowDOTwo.setItemId(oldPriMainPriceRowDO.getItemId());
                PriMainPriceRowDO newPriMainPriceAlterDRowDOOne = (PriMainPriceRowDO)SerializationUtils.clone((Serializable)oldPriMainPriceRowDO);
                newPriMainPriceAlterDRowDOOne.setId(null);
                if (changeValidToLong < oldValidFromLong || changeValidFromLong > oldValidToLong) {
                    priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOTwo);
                }
                if (changeValidFromLong > oldValidFromLong && changeValidFromLong <= oldValidToLong && changeValidToLong > oldValidToLong) {
                    newPriMainPriceAlterDRowDOOne.setValidTo(changeValidFrom.plusDays(-1L));
                    priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOOne);
                    priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOTwo);
                    deleteIdList.add(oldPriMainPriceRowDO.getId());
                }
                if (changeValidFromLong < oldValidFromLong && changeValidToLong >= oldValidFromLong && changeValidToLong < oldValidToLong) {
                    newPriMainPriceAlterDRowDOOne.setValidFrom(changeValidTo.plusDays(1L));
                    priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOOne);
                    priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOTwo);
                    deleteIdList.add(oldPriMainPriceRowDO.getId());
                }
                if (changeValidFromLong <= oldValidFromLong && changeValidToLong >= oldValidToLong) {
                    priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOTwo);
                    deleteIdList.add(oldPriMainPriceRowDO.getId());
                }
                if (oldValidFromLong <= changeValidFromLong && changeValidToLong <= oldValidToLong) {
                    if (oldValidFromLong == changeValidFromLong && changeValidToLong < oldValidToLong) {
                        priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOOne.setValidFrom(changeValidTo.plusDays(1L)));
                        priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOTwo);
                    }
                    if (oldValidFromLong < changeValidFromLong && changeValidToLong == oldValidToLong) {
                        priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOOne.setValidTo(changeValidFrom.plusDays(-1L)));
                        priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOTwo);
                    }
                    if (oldValidFromLong < changeValidFromLong && changeValidToLong < oldValidToLong) {
                        PriMainPriceRowDO newPriMainPriceAlterDRowDOThree = (PriMainPriceRowDO)SerializationUtils.clone((Serializable)newPriMainPriceAlterDRowDOOne);
                        newPriMainPriceAlterDRowDOOne.setValidTo(changeValidFrom.plusDays(-1L));
                        newPriMainPriceAlterDRowDOThree.setValidFrom(changeValidTo.plusDays(1L));
                        priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOOne);
                        priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOThree);
                        priMainPriceRowDOList.add(newPriMainPriceAlterDRowDOTwo);
                    }
                    deleteIdList.add(oldPriMainPriceRowDO.getId());
                }
            });
        });
        this.priMainPriceRowRepoProc.deleteByIds(deleteIdList);
        ArrayList priMainPriceRowSaveDOs = priMainPriceRowDOList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PriMainPriceRowDO>(Comparator.comparing(s -> s.getValidFrom() + ";" + s.getValidTo() + ";" + s.getItemCode() + ";" + s.getItemCateCode()))), ArrayList::new));
        priMainPriceRowSaveDOs.stream().peek(s -> {
            SysUserDTO sysUserDTO;
            Optional<OrgBuDO> byBuCode = this.orgBuRepo.findByBuCode(s.getBuCode());
            if (byBuCode.isPresent()) {
                Long ouId = byBuCode.get().getOuId();
                s.setSecOuId(ouId);
            }
            if ((sysUserDTO = this.getUserInfo()) != null) {
                s.setCreateUserId(sysUserDTO.getCreateUserId());
                s.setCreator(sysUserDTO.getCreator());
                s.setPriceStatus(ComUdcEnum.COM_ACTIVE.getUdcVal());
            }
            s.setModifyTime(LocalDateTime.now());
            s.setCreateTime(LocalDateTime.now());
            if (StringUtils.isNotBlank((CharSequence)s.getItemCode())) {
                List<ItmItemDTO> itemDtoByItemCode = this.itmItemRepoProc.findItemDtoByItemCode(List.of(s.getItemCode()));
                ItmItemDTO itmItemDTO = itemDtoByItemCode.get(0);
                s.setCreator(itmItemDTO.getCreator());
                s.setCreateUserId(itmItemDTO.getCreateUserId());
            }
            s.setPriceType(PriMainPriceUdcEnum.PRI_PRICE_TYPE_ITEM_PRICE.getUdcVal());
        }).collect(Collectors.toList());
        this.priMainPriceRowRepo.saveAll(priMainPriceRowSaveDOs);
    }

    private SysUserDTO getUserInfo() {
        SysUserDTO sysUserDTO = new SysUserDTO();
        GeneralUserDetails generalUserDetails = SecurityUtil.getUser();
        if (generalUserDetails != null && generalUserDetails.getUser() != null) {
            sysUserDTO = generalUserDetails.getUser();
        }
        return sysUserDTO;
    }

    public PriPriceChangeServiceImpl(PriMainPriceRowRepo priMainPriceRowRepo, PriMainPriceRowRepoProc priMainPriceRowRepoProc, OrgBuRepo orgBuRepo, ItmItemRepoProc itmItemRepoProc) {
        this.priMainPriceRowRepo = priMainPriceRowRepo;
        this.priMainPriceRowRepoProc = priMainPriceRowRepoProc;
        this.orgBuRepo = orgBuRepo;
        this.itmItemRepoProc = itmItemRepoProc;
    }
}

