/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.rpc.file;

import com.el.coordinator.boot.fsm.common.UploadFileParam;
import com.el.coordinator.boot.fsm.config.handler.SimpleFileHandler;
import com.el.coordinator.boot.fsm.model.dto.FileObjDTO;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.core.common.api.ApiResult;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.rpc.file.convert.ComFileConvert;
import com.elitesland.yst.supportdomain.rpc.file.entity.ComFileDO;
import com.elitesland.yst.supportdomain.rpc.file.repo.ComFileRepo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class LocalFileHandler<T>
extends SimpleFileHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(LocalFileHandler.class);
    private final ComFileRepo comFileRepo;

    public LocalFileHandler(ComFileRepo comFileRepo) {
        this.comFileRepo = comFileRepo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<FileObjRespVO<T>> afterHandle(UploadFileParam<T> uploadFileParam, FileObjDTO<T> fileObj, String errorMsg) {
        ApiResult result = super.afterHandle(uploadFileParam, fileObj, errorMsg);
        if (!result.isSuccess()) {
            return result;
        }
        FileObjRespVO fileObjRespVO = (FileObjRespVO)result.getData();
        if (fileObjRespVO == null) {
            log.error("\u6587\u4ef6\u670d\u52a1\u5668\u8c03\u7528\u5931\u8d25\uff1a\u6587\u4ef6\u4fe1\u606f\u4e3a\u7a7a");
            throw new BusinessException(ApiCode.CLOUD_SERVICE_EXCEPTION, "\u6587\u4ef6\u670d\u52a1\u5668\u8c03\u7528\u5931\u8d25\uff1a\u6587\u4ef6\u4fe1\u606f\u4e3a\u7a7a");
        }
        ComFileDO fileDo = ComFileConvert.INSTANCE.respVoToDo(fileObjRespVO);
        try {
            this.comFileRepo.save(fileDo);
        }
        catch (RuntimeException e) {
            log.error("\u672c\u5730\u5b58\u50a8\u6587\u4ef6\u4e0a\u4f20\u8bb0\u5f55\u5f02\u5e38\uff1a" + e.getMessage());
            throw e;
        }
        return result;
    }
}

