/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.sync.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.elitesland.yst.common.util.RedisUtils;
import com.elitesland.yst.core.provider.IdGenerator;
import com.elitesland.yst.supportdomain.common.SysNumberGeneratorWrapper;
import com.elitesland.yst.supportdomain.item.entity.ItmItemDO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemSpuDO;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemSpuRepo;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemSaveParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemSpuSaveParam;
import com.elitesland.yst.supportdomain.provider.item.service.ItmItemRpcService;
import com.elitesland.yst.supportdomain.sync.service.B2BItemSyncService;
import com.elitesland.yst.supportdomain.sync.vo.BaseItemMasSyncRespVO;
import com.elitesland.yst.supportdomain.sync.vo.param.BaseItemMasSyncParam;
import com.elitesland.yst.system.service.SysSettingService;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class B2BItemSyncServiceImpl
implements B2BItemSyncService {
    private static final Logger log = LoggerFactory.getLogger(B2BItemSyncServiceImpl.class);
    private final ItmItemRepo itmItemRepo;
    private final ItmItemSpuRepo itmItemSpuRepo;
    private final SysNumberGeneratorWrapper sysNumberGeneratorWrapper;
    private final ItmItemRpcService itmItemRpcService;
    private final RedisUtils redisClient;
    @DubboReference(version="${provider.service.version}", check=false)
    private SysSettingService sysSettingService;
    private static final Integer BASE_ADDR_BATCH_SAVE_COUNT = 1000;
    private static final String B2B_BASE_ITEM_MAS_SYNC_URL = "/api/sync/queryItems.do";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void syncBaseItem(BaseItemMasSyncParam param) {
        long totalSize = 0L;
        boolean success = true;
        try {
            Integer totalPage;
            JSONObject jsonObject;
            String cid = (String)this.redisClient.get("B2B_LOGIN_CID");
            if (StringUtils.isEmpty((CharSequence)cid)) {
                String loginUrl = this.sysSettingService.oneByNo("DM_B2B_LOGIN_URL").getSettingVal();
                log.info("B2B\u5546\u54c1\u540c\u6b65 === \u767b\u5f55URL:{}", (Object)loginUrl);
                HttpResponse loginResponse = HttpRequest.get((String)loginUrl).execute();
                if (loginResponse.getStatus() == 200) {
                    JSONObject loginResp = JSONObject.parseObject((String)loginResponse.body());
                    cid = loginResp.get((Object)"cid") != null ? loginResp.get((Object)"cid").toString() : "";
                    this.redisClient.set("DM_B2B_LOGIN_URL", (Object)cid);
                }
            }
            String b2bUrlAddress = this.sysSettingService.oneByNo("b2bUrlAddress").getSettingVal();
            Integer page = 1;
            Date date = new Date(0L);
            date.setTime(System.currentTimeMillis());
            log.info("\u5f00\u59cb\u540c\u6b65\u65f6\u95f4\uff1a{}", (Object)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            do {
                String url = b2bUrlAddress + B2B_BASE_ITEM_MAS_SYNC_URL;
                log.info("B2B\u5546\u54c1\u540c\u6b65URL\uff1a{}\uff0c\u5f53\u524d\u9875\uff1a{}\uff0c\u6bcf\u9875\u6570\u91cf\uff1a{}", new Object[]{url, page, BASE_ADDR_BATCH_SAVE_COUNT});
                param.setPageIndex(page);
                param.setPageSize(BASE_ADDR_BATCH_SAVE_COUNT);
                String body = JSON.toJSONString((Object)param);
                log.info("B2B\u5546\u54c1\u540c\u6b65\u67e5\u8be2\uff1a\u5f53\u524d\u9875\uff1a{}\uff0c\u6bcf\u9875\u6570\u91cf\uff1a{}\uff0c\u53c2\u6570\uff1a{}", new Object[]{page, BASE_ADDR_BATCH_SAVE_COUNT, body});
                HttpResponse categoryResponse = ((HttpRequest)HttpRequest.post((String)url).header("el-cid", cid)).body(body).execute();
                jsonObject = JSONObject.parseObject((String)categoryResponse.body());
                Integer total = Integer.valueOf(jsonObject.get((Object)"total").toString());
                totalPage = (int)Math.ceil((double)total.intValue() / (double)BASE_ADDR_BATCH_SAVE_COUNT.intValue());
                String rows = jsonObject.getString("rows");
                ArrayList respVOS = (ArrayList)JSONObject.parseObject((String)rows, (TypeReference)new TypeReference<ArrayList<BaseItemMasSyncRespVO>>(){}, (Feature[])new Feature[0]);
                ArrayList<ItmItemSpuDO> spuSaveParamList = new ArrayList<ItmItemSpuDO>();
                ArrayList<ItmItemDO> saveParamList = new ArrayList<ItmItemDO>();
                if (CollectionUtils.isNotEmpty((Collection)respVOS)) {
                    List<String> itemCodeList = respVOS.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getImitm())).map(BaseItemMasSyncRespVO::getImitm).distinct().collect(Collectors.toList());
                    List<ItmItemDO> itmItemDOS = this.itmItemRepo.findByItemCodeIn(itemCodeList);
                    Map<Object, Object> itmItemMap = new HashMap();
                    Map<Object, Object> itmItemSpuMap = new HashMap();
                    if (CollectionUtils.isNotEmpty(itmItemDOS)) {
                        itmItemMap = itmItemDOS.stream().collect(Collectors.groupingBy(ItmItemDO::getItemCode));
                        List<String> spuCodeList = itmItemDOS.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getSpuCode())).map(ItmItemDO::getSpuCode).distinct().collect(Collectors.toList());
                        List<ItmItemSpuDO> spuList = this.itmItemSpuRepo.findBySpuCodeIn(spuCodeList);
                        if (CollectionUtils.isNotEmpty(spuList)) {
                            itmItemSpuMap = spuList.stream().collect(Collectors.groupingBy(ItmItemSpuDO::getSpuCode));
                        }
                    }
                    for (BaseItemMasSyncRespVO respVO : respVOS) {
                        ItmItemSpuDO spuDO = new ItmItemSpuDO();
                        ItmItemDO itemDO = new ItmItemDO();
                        if (itmItemMap != null && itmItemMap.size() > 0 && CollectionUtils.isNotEmpty((Collection)((Collection)itmItemMap.get(respVO.getImitm())))) {
                            itemDO = (ItmItemDO)((List)itmItemMap.get(respVO.getImitm())).get(0);
                            if (CollectionUtils.isNotEmpty((Collection)((Collection)itmItemSpuMap.get(itemDO.getSpuCode())))) {
                                spuDO = (ItmItemSpuDO)((List)itmItemSpuMap.get(itemDO.getSpuCode())).get(0);
                            } else {
                                spuCode = this.sysNumberGeneratorWrapper.generate("ITEM_SPU_NO");
                                aLong = IdGenerator.getSnowflake().nextId();
                                spuDO.setId(aLong);
                                spuDO.setSpuCode(spuCode);
                                spuDO.setSpuName(respVO.getImdsc2());
                                spuDO.setCatId(respVO.getCatId() != null ? Long.valueOf(respVO.getCatId().intValue()) : 0L);
                                spuDO.setSource("B2B");
                                spuDO.setBrand("A");
                                spuDO.setSpuStatus("APPROVED");
                                itemDO.setSpuId(aLong);
                                itemDO.setSpuCode(spuCode);
                                itemDO.setSpuName(respVO.getImdsc2());
                            }
                            this.getSkuInfo(respVO, itemDO);
                            saveParamList.add(itemDO);
                        } else {
                            spuCode = this.sysNumberGeneratorWrapper.generate("ITEM_SPU_NO");
                            itemDO.setSpuCode(spuCode);
                            itemDO.setSpuName(respVO.getImdsc2());
                            itemDO.setSource("B2B");
                            itemDO.setItemStatus2("APPROVED");
                            aLong = IdGenerator.getSnowflake().nextId();
                            spuDO.setId(aLong);
                            itemDO.setSpuId(aLong);
                            spuDO.setSpuCode(spuCode);
                            spuDO.setSpuName(respVO.getImdsc2());
                            spuDO.setCatId(respVO.getCatId() != null ? Long.valueOf(respVO.getCatId().intValue()) : 0L);
                            spuDO.setSource("B2B");
                            spuDO.setBrand("A");
                            spuDO.setSpuStatus("APPROVED");
                            this.getSkuInfo(respVO, itemDO);
                        }
                        saveParamList.add(itemDO);
                        spuSaveParamList.add(spuDO);
                    }
                }
                this.itmItemSpuRepo.saveAll(spuSaveParamList);
                this.itmItemRepo.saveAll(saveParamList);
                totalSize += (long)respVOS.size();
                Integer n = page;
                page = page + 1;
            } while (jsonObject.containsKey((Object)"total") && page <= totalPage);
            log.info("\u7ed3\u675f\u540c\u6b65\u65f6\u95f4\uff1a{}", (Object)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        }
        catch (Exception e) {
            try {
                success = false;
                log.info("B2B\u5546\u54c1\u4fe1\u606f\u540c\u6b65\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                log.info("B2B\u5546\u54c1\u4fe1\u606f\u540c\u6b65\u7ed3\u675f\uff0c\u65f6\u95f4\uff1a{}, \u540c\u6b65\u7ed3\u679c\uff1a{}, \u540c\u6b65\u6570\u91cf\uff1a{}", new Object[]{LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")), success, totalSize});
                throw throwable;
            }
            log.info("B2B\u5546\u54c1\u4fe1\u606f\u540c\u6b65\u7ed3\u675f\uff0c\u65f6\u95f4\uff1a{}, \u540c\u6b65\u7ed3\u679c\uff1a{}, \u540c\u6b65\u6570\u91cf\uff1a{}", new Object[]{LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")), success, totalSize});
        }
        log.info("B2B\u5546\u54c1\u4fe1\u606f\u540c\u6b65\u7ed3\u675f\uff0c\u65f6\u95f4\uff1a{}, \u540c\u6b65\u7ed3\u679c\uff1a{}, \u540c\u6b65\u6570\u91cf\uff1a{}", new Object[]{LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")), success, totalSize});
    }

    private void getSkuInfo(BaseItemMasSyncRespVO respVO, ItmItemDO doList) {
        String replace;
        doList.setItemCode(respVO.getImitm());
        doList.setItemCode2(respVO.getImaitm());
        doList.setItemCode3(respVO.getImlitm());
        doList.setSpec(respVO.getImdsc1());
        doList.setItemName(respVO.getImdsc2());
        Object itemAttr = "";
        if (StringUtils.isNotEmpty((CharSequence)respVO.getPacksb())) {
            replace = respVO.getPacksb().replace(" <BR />", "");
            doList.setItemAttr2(replace);
            itemAttr = (String)itemAttr + replace + " ";
        }
        if (StringUtils.isNotEmpty((CharSequence)respVO.getPackbox())) {
            replace = respVO.getPackbox().replace(" <BR />", "");
            doList.setItemAttr3(replace);
            itemAttr = (String)itemAttr + replace + " ";
        }
        if (StringUtils.isNotEmpty((CharSequence)respVO.getPackbx())) {
            replace = respVO.getPackbx().replace(" <BR />", "");
            doList.setItemAttr4(replace);
            itemAttr = (String)itemAttr + replace + " ";
        }
        doList.setItemAttr((String)itemAttr);
        doList.setStandard(respVO.getIbsrp7());
        doList.setStandardDesc(respVO.getIbsrp7Dl01());
        doList.setMaterial(respVO.getIbsrp3());
        doList.setMaterialDesc(respVO.getIbsrp3Dl01());
        doList.setMaterialSort(respVO.getSrp3sort());
        doList.setDiameter(respVO.getImseg6());
        doList.setDiameterDesc(respVO.getImseg6Dl01());
        doList.setDiameterSort(respVO.getSeg6sort());
        doList.setLengths(respVO.getImseg7());
        doList.setLengthsDesc(respVO.getImseg7Dl01());
        doList.setLengthsSort(respVO.getSeg7sort());
        doList.setTooth(respVO.getIbsrp5());
        doList.setToothDesc(respVO.getIbsrp5Dl01());
        doList.setToothSort(respVO.getSrp5sort());
        doList.setSurface(respVO.getIbsrp9());
        doList.setSurfaceDesc(respVO.getIbsrp9Dl01());
        doList.setSurfaceSort(respVO.getSrp9sort());
        doList.setStrength(respVO.getIbsrp8());
        doList.setStrengthDesc(respVO.getIbsrp8Dl01());
        doList.setStrengthSort(respVO.getSrp8sort());
        doList.setNetWeight(respVO.getWeight() != null ? BigDecimal.valueOf(respVO.getWeight()) : BigDecimal.ZERO);
    }

    private void combineSaveParam(BaseItemMasSyncRespVO respVO, ItmItemSpuSaveParam spuParam, ItmItemSaveParam skuParam) {
        spuParam.setSpuName(respVO.getImdsc2());
        String spuCode = this.sysNumberGeneratorWrapper.generate("ITEM_SPU_NO");
        spuParam.setSpuCode(spuCode);
        spuParam.setCatId(Long.valueOf(respVO.getCatId() != null ? Long.valueOf(respVO.getCatId().intValue()) : 0L));
        skuParam.setSpuCode(spuParam.getSpuCode());
        skuParam.setSpuName(spuParam.getSpuName());
        skuParam.setItemCode(respVO.getImitm());
        skuParam.setItemCode2(respVO.getImaitm());
        skuParam.setItemCode3(respVO.getImlitm());
        skuParam.setSpec(respVO.getImdsc1());
        skuParam.setItemName(respVO.getImdsc2());
        skuParam.setItemAttr2(respVO.getPacksb());
        skuParam.setItemAttr3(respVO.getPackbox());
        skuParam.setItemAttr4(respVO.getPackbx());
        skuParam.setStandard(respVO.getIbsrp7());
        skuParam.setStandardDesc(respVO.getIbsrp7Dl01());
        skuParam.setMaterial(respVO.getIbsrp3());
        skuParam.setMaterialDesc(respVO.getIbsrp3Dl01());
        skuParam.setMaterialSort(respVO.getSrp3sort());
        skuParam.setDiameter(respVO.getImseg6());
        skuParam.setDiameterDesc(respVO.getImseg6Dl01());
        skuParam.setDiameterSort(respVO.getSeg6sort());
        skuParam.setLengths(respVO.getImseg7());
        skuParam.setLengthsDesc(respVO.getImseg7Dl01());
        skuParam.setLengthsSort(respVO.getSeg7sort());
        skuParam.setTooth(respVO.getIbsrp5());
        skuParam.setToothDesc(respVO.getIbsrp5Dl01());
        skuParam.setToothSort(respVO.getSrp5sort());
        skuParam.setSurface(respVO.getIbsrp9());
        skuParam.setSurfaceDesc(respVO.getIbsrp9Dl01());
        skuParam.setSurfaceSort(respVO.getSrp9sort());
        skuParam.setStrength(respVO.getIbsrp8());
        skuParam.setStrengthDesc(respVO.getIbsrp8Dl01());
        skuParam.setStrengthSort(respVO.getSrp8sort());
        skuParam.setNetWeight(respVO.getWeight());
    }

    public B2BItemSyncServiceImpl(ItmItemRepo itmItemRepo, ItmItemSpuRepo itmItemSpuRepo, SysNumberGeneratorWrapper sysNumberGeneratorWrapper, ItmItemRpcService itmItemRpcService, RedisUtils redisClient) {
        this.itmItemRepo = itmItemRepo;
        this.itmItemSpuRepo = itmItemSpuRepo;
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
        this.itmItemRpcService = itmItemRpcService;
        this.redisClient = redisClient;
    }
}

