/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.util;

import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;

public class BeanCopyUtil {
    public static <T> void beanCopy(T source, T target) {
        BeanUtils.copyProperties(source, target, (String[])BeanCopyUtil.getNullPropertyNames(source));
    }

    public static <T> void beanCopyWithIngore(T source, T target, String ... ignoreProperties) {
        String[] pns = BeanCopyUtil.getNullAndIgnorePropertyNames(source, ignoreProperties);
        BeanUtils.copyProperties(source, target, (String[])pns);
    }

    public static String[] getNullAndIgnorePropertyNames(Object source, String ... ignoreProperties) {
        Set<String> emptyNames = BeanCopyUtil.getNullPropertyNameSet(source);
        for (String s : ignoreProperties) {
            emptyNames.add(s);
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    public static String[] getNullPropertyNames(Object source) {
        Set<String> emptyNames = BeanCopyUtil.getNullPropertyNameSet(source);
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    public static Set<String> getNullPropertyNameSet(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null) continue;
            emptyNames.add(pd.getName());
        }
        return emptyNames;
    }
}

