/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CreateEntity {
    private static final String PROJECT_DIRECTORY = "D:\\MyWork\\WorkSpace\\finEntity";
    private static final String DEVELOPMENT = "D:\\MyWork\\WorkSpace\\finEntity";
    private String tableName;
    private String comment;
    private static Pattern linePattern = Pattern.compile("_(\\w)");

    public static void main(String[] args) {
        List<CreateEntity> createEntities = List.of(new CreateEntity().setTableName("PRI_MAIN_PRICE_ALTER_D").setComment("\u4e3b\u6863\u4ef7\u683c\u53d8\u66f4\u5355\u636e\u660e\u7ec6\u8868"), new CreateEntity().setTableName("PRI_MAIN_PRICE_ALTER").setComment("\u4e3b\u6863\u4ef7\u683c\u53d8\u66f4\u5355\u636e\u8868"));
        System.out.println(createEntities.size());
        for (CreateEntity createEntity : createEntities) {
            String tableName = createEntity.getTableName();
            String comment = createEntity.getComment();
            CreateEntity.createEntity(tableName, comment);
            CreateEntity.createService(tableName, comment);
            CreateEntity.createServiceImpl(tableName, comment);
            CreateEntity.createController(tableName, comment);
            CreateEntity.createRepo(tableName, comment);
            CreateEntity.createProc(tableName, comment);
        }
    }

    public static void createController(String tableName, String comment) {
        String dir = "D:\\MyWork\\WorkSpace\\finEntity\\controller";
        String field = tableName.substring(0, tableName.indexOf("_")).toLowerCase();
        String entityNameTitleLower = CreateEntity.lineToHump(tableName);
        String entityName = CreateEntity.titleCase(CreateEntity.lineToHump(tableName));
        String entityTemplateStr = CreateEntity.createControllerTemplateStr(field, entityNameTitleLower, entityName, comment);
        System.out.println(entityTemplateStr);
        CreateEntity.writeContent(entityTemplateStr, dir, entityName + "Controller.java");
    }

    public static String createControllerTemplateStr(String field, String entityNameTitleLower, String entityName, String comment) {
        return "package com.elitesland." + field + ".controller;\n\nimport com.elitesland.yst.common.base.ApiResult;\nimport com.elitesland.yst." + field + ".service." + entityName + "Service;\nimport io.swagger.annotations.Api;\nimport io.swagger.annotations.ApiOperation;\nimport lombok.RequiredArgsConstructor;\nimport org.springframework.web.bind.annotation.PostMapping;\nimport org.springframework.web.bind.annotation.RequestMapping;\nimport org.springframework.web.bind.annotation.RestController;\n\n/**\n * <p>\n * \u529f\u80fd\u8bf4\u660e\n * </p>\n *\n * @author Tristan\n * @date 2020/7/2\n */\n@RestController\n@RequestMapping(\"/" + field + "/" + entityNameTitleLower + "\")\n@RequiredArgsConstructor\n@Api(value = \"" + comment + "\", tags = {\"" + comment + "\"})\npublic class " + entityName + "Controller {\n\n    private final " + entityName + "Service " + entityNameTitleLower + "Service;\n\n    @PostMapping(\"/q\")\n    @ApiOperation(\"\")\n    public ApiResult<Object> search() {\n        return ApiResult.ok(null);\n    }\n}\n";
    }

    public static void createService(String tableName, String comment) {
        String dir = "D:\\MyWork\\WorkSpace\\finEntity\\service";
        String field = tableName.substring(0, tableName.indexOf("_")).toLowerCase();
        String entityName = CreateEntity.titleCase(CreateEntity.lineToHump(tableName));
        String serviceTemplateStr = CreateEntity.createServiceTemplateStr(field, entityName);
        CreateEntity.writeContent(serviceTemplateStr, dir, entityName + "Service.java");
    }

    public static String createServiceTemplateStr(String field, String entityName) {
        return "package com.elitesland." + field + ".service;\n\n/**\n * <p>\n * \u529f\u80fd\u8bf4\u660e\n * </p>\n *\n * @author Tristan\n * @date 2020/7/2\n */\npublic interface " + entityName + "Service {\n\n}\n";
    }

    public static void createServiceImpl(String tableName, String comment) {
        String dir = "D:\\MyWork\\WorkSpace\\finEntity\\service\\impl";
        String field = tableName.substring(0, tableName.indexOf("_")).toLowerCase();
        String entityName = CreateEntity.titleCase(CreateEntity.lineToHump(tableName));
        String entityTemplateStr = CreateEntity.createServiceImplTemplateStr(field, entityName);
        CreateEntity.writeContent(entityTemplateStr, dir, entityName + "ServiceImpl.java");
    }

    public static String createServiceImplTemplateStr(String field, String entityName) {
        return "package com.elitesland." + field + ".service.impl;\n\nimport com.elitesland." + field + ".service." + entityName + "Service;\nimport lombok.RequiredArgsConstructor;\nimport org.springframework.stereotype.Service;\n\n/**\n * <p>\n * \u529f\u80fd\u8bf4\u660e\n * </p>\n *\n * @author Tristan\n * @date 2020/7/2\n */\n@Service\n@RequiredArgsConstructor\npublic class " + entityName + "ServiceImpl implements " + entityName + "Service {\n\n}\n";
    }

    public static void createRepo(String tableName, String comment) {
        String dir = "D:\\MyWork\\WorkSpace\\finEntity\\repo";
        String field = tableName.substring(0, tableName.indexOf("_")).toLowerCase();
        String entityName = CreateEntity.titleCase(CreateEntity.lineToHump(tableName)) + "DO";
        String classNmae = CreateEntity.titleCase(CreateEntity.lineToHump(tableName)) + "Repo";
        String repoTemplateStr = CreateEntity.createRepoTemplateStr(field, classNmae, entityName);
        CreateEntity.writeContent(repoTemplateStr, dir, classNmae + ".java");
    }

    public static String createRepoTemplateStr(String field, String classNmae, String entityName) {
        return "package com.elitesland." + field + ".repo;\n\nimport com.elitesland." + field + ".entity." + entityName + ";\nimport org.springframework.data.jpa.repository.JpaRepository;\nimport org.springframework.data.querydsl.QuerydslPredicateExecutor;\nimport org.springframework.stereotype.Repository;\n\n/**\n * <p>\n * \u529f\u80fd\u8bf4\u660e\n * </p>\n *\n * @author Tristan\n * @date 2020/7/2\n */\n@Repository\npublic interface " + classNmae + " extends JpaRepository<" + entityName + ", Long>, QuerydslPredicateExecutor<" + entityName + "> {\n}\n";
    }

    public static void createProc(String tableName, String comment) {
        String dir = "D:\\MyWork\\WorkSpace\\finEntity\\repo";
        String field = tableName.substring(0, tableName.indexOf("_")).toLowerCase();
        String entityName = CreateEntity.titleCase(CreateEntity.lineToHump(tableName));
        String classNmae = CreateEntity.titleCase(CreateEntity.lineToHump(tableName)) + "RepoProc";
        String repoTemplateStr = CreateEntity.createProcTemplateStr(field, entityName);
        CreateEntity.writeContent(repoTemplateStr, dir, classNmae + ".java");
    }

    public static String createProcTemplateStr(String field, String entityName) {
        return "package com.elitesland." + field + ".repo;\n\nimport com.querydsl.jpa.impl.JPAQueryFactory;\nimport lombok.RequiredArgsConstructor;\nimport org.springframework.stereotype.Component;\n\n/**\n * <p>\n * \u529f\u80fd\u8bf4\u660e\n * </p>\n *\n * @author Tristan\n * @date 2021/4/19\n */\n@Component\n@RequiredArgsConstructor\npublic class " + entityName + "RepoProc {\n \n    private final JPAQueryFactory jpaQueryFactory;\n \n}\n";
    }

    public static void createEntity(String tableName, String comment) {
        String dir = "D:\\MyWork\\WorkSpace\\finEntity\\entity";
        String field = tableName.substring(0, tableName.indexOf("_")).toLowerCase();
        String entityName = CreateEntity.titleCase(CreateEntity.lineToHump(tableName)) + "DO";
        String entityTemplateStr = CreateEntity.createEntityTemplateStr(field, tableName.toLowerCase(), entityName, comment);
        CreateEntity.writeContent(entityTemplateStr, dir, entityName + ".java");
    }

    public static String createEntityTemplateStr(String field, String tableName, String entityName, String comment) {
        return "package com.elitesland." + field + ".entity;\n\nimport io.swagger.annotations.ApiModel;\nimport io.swagger.annotations.ApiModelProperty;\nimport lombok.Data;\nimport lombok.experimental.Accessors;\nimport com.elitesland.common.base.BaseModel;\n\nimport javax.persistence.Column;\nimport javax.persistence.Entity;\nimport javax.persistence.Table;\nimport java.io.Serializable;\nimport java.util.Objects;\n/**\n * <p>\n * \u529f\u80fd\u8bf4\u660e\n * </p>\n *\n * @author Tristan\n * @date 2020/7/2\n */\n@Entity\n@Table(name = \"" + tableName + "\")\n@org.hibernate.annotations.Table(appliesTo = \"" + tableName + "\", comment = \"" + comment + "\")\n@Data\n@Accessors(chain = true)\n@ApiModel(value = \"" + comment + "\", description = \"" + comment + "\")\npublic class " + entityName + " extends BaseModel implements Serializable {\n\n    private static final long serialVersionUID = 1L;\n\n}\n";
    }

    public static void writeContent(String entityTemplateStr, String dir, String fileName) {
        try {
            Path rootLocation = Paths.get(dir, new String[0]);
            if (Files.notExists(rootLocation, new LinkOption[0])) {
                Files.createDirectories(rootLocation, new FileAttribute[0]);
            }
            Path path = rootLocation.resolve(fileName);
            byte[] strToBytes = entityTemplateStr.getBytes();
            Files.write(path, strToBytes, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String lineToHump(String str) {
        str = str.toLowerCase();
        Matcher matcher = linePattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String titleCase(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getComment() {
        return this.comment;
    }

    public CreateEntity setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public CreateEntity setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateEntity)) {
            return false;
        }
        CreateEntity other = (CreateEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    public String toString() {
        return "CreateEntity(tableName=" + this.getTableName() + ", comment=" + this.getComment() + ")";
    }
}

