/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.util;

import com.elitesland.yst.common.config.dynamic.datasource.SpringUtils;
import com.elitesland.yst.common.exception.BusinessException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.internal.SessionFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DbUtils {
    private static final Logger log = LoggerFactory.getLogger(DbUtils.class);
    private static EntityManager entityManager;
    public static final int BATCH_SIZE = 1000;

    public static EntityManager getEntityManager() {
        if (entityManager == null) {
            entityManager = (EntityManager)SpringUtils.getBean(EntityManager.class);
        }
        return entityManager;
    }

    public static void setEntityManager(EntityManager entityManager) {
    }

    public static Connection getConnection() {
        Connection conn = null;
        Session session = null;
        try {
            session = (Session)DbUtils.getEntityManager().getDelegate();
            SessionFactoryImpl sf = (SessionFactoryImpl)session.getSessionFactory();
            conn = sf.getJdbcServices().getBootstrapJdbcConnectionAccess().obtainConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return conn;
    }

    public static void close(Connection c, Statement ps, ResultSet rs) {
        log.info("-------DbUtils.close!++++++++");
        try {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (ps != null) {
                ps.close();
                ps = null;
            }
            if (c != null) {
                if (!c.isClosed()) {
                    if (!c.getAutoCommit()) {
                        c.commit();
                    }
                    c.close();
                }
                c = null;
            }
        }
        catch (SQLException e) {
            log.error(e.getLocalizedMessage());
            throw new BusinessException("\u6570\u636e\u5e93\u5173\u95ed\u5931\u8d25");
        }
    }

    public static void batchExecute(String sql, List<Object[]> params, Integer batchSize) {
        if (batchSize == null) {
            batchSize = 1000;
        }
        if (params.size() == 0) {
            return;
        }
        Connection conn = null;
        Session session = null;
        Statement stmt = null;
        try {
            session = (Session)DbUtils.getEntityManager().getDelegate();
            SessionFactoryImpl sf = (SessionFactoryImpl)session.getSessionFactory();
            conn = sf.getJdbcServices().getBootstrapJdbcConnectionAccess().obtainConnection();
            stmt = conn.prepareStatement(sql);
            conn.setAutoCommit(false);
            int index = 0;
            for (Object[] objects : params) {
                for (int i = 0; i < objects.length; ++i) {
                    stmt.setObject(i + 1, objects[i]);
                }
                stmt.addBatch();
                if (++index % batchSize != 0) continue;
                stmt.executeBatch();
                stmt.clearBatch();
            }
            if (index % batchSize != 0) {
                stmt.executeBatch();
                stmt.clearBatch();
            }
            conn.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            try {
                stmt.close();
                conn.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

