/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.util;

import cn.hutool.json.JSONUtil;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmApplyDCateExportVO;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateSimpleTree;
import com.elitesland.yst.supportdomain.item.excel.vo.ItemCateDescNameVO;
import com.elitesland.yst.supportdomain.item.excel.vo.ItemCateDescPropVO;
import com.elitesland.yst.supportdomain.item.excel.vo.ItemCateSalePropVO;
import com.elitesland.yst.supportdomain.item.repo.ItmCatePropRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.item.vo.ItmExportDescPropVO;
import com.elitesland.yst.supportdomain.item.vo.ItmExportSalePropVO;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItmExportUtil {
    private static final Logger log = LoggerFactory.getLogger(ItmExportUtil.class);
    private static final String TRUE = "\u662f";
    private static final String FALSE = "\u5426";
    private final ItmCatePropRepoProc itmCatePropRepoProc;
    private final ItmItemCateService itmItemCateService;

    public Map<String, ItmApplyDCateExportVO> allItemCateNameFill(List<String> itemCateCodeList) {
        HashMap<String, ItmApplyDCateExportVO> result = new HashMap<String, ItmApplyDCateExportVO>();
        Map<String, List<ItemCateDescNameVO>> itemDescMap = this.itmCatePropRepoProc.getItemDescPropNameList(itemCateCodeList).stream().collect(Collectors.groupingBy(ItemCateDescNameVO::getItemCateCode));
        itemCateCodeList.forEach(itemCateCode -> {
            ItmApplyDCateExportVO itmApplyDCateExport = new ItmApplyDCateExportVO();
            itmApplyDCateExport.setItemCateCode((String)itemCateCode);
            List<ItmItemCateSimpleTree> itemCatePath = this.itmItemCateService.findItemCatePath((String)itemCateCode);
            if (CollectionUtils.isNotEmpty(itemCatePath)) {
                itmApplyDCateExport.setBigCateName(itemCatePath.get(0).getItemCateName());
                List<ItmItemCateSimpleTree> midTreeNodes = itemCatePath.get(0).getTreeNodes();
                if (CollectionUtils.isNotEmpty(midTreeNodes)) {
                    itmApplyDCateExport.setMidCateName(midTreeNodes.get(0).getItemCateName());
                    List<ItmItemCateSimpleTree> smallTreeNodes = midTreeNodes.get(0).getTreeNodes();
                    if (CollectionUtils.isNotEmpty(smallTreeNodes)) {
                        itmApplyDCateExport.setSmallCateName(smallTreeNodes.get(0).getItemCateName());
                    }
                }
            }
            result.put((String)itemCateCode, itmApplyDCateExport);
        });
        return result;
    }

    public List<ItemCateSalePropVO> jsonToItemAttrJsonEntity(String itemAttr) {
        if (StringUtils.isBlank((CharSequence)itemAttr)) {
            return Collections.emptyList();
        }
        ArrayList<ItemCateSalePropVO> props = new ArrayList<ItemCateSalePropVO>();
        Pattern pat = Pattern.compile("(\\{).*?(})");
        Matcher mat = pat.matcher(itemAttr);
        while (mat.find()) {
            ItemCateSalePropVO prop = new ItemCateSalePropVO();
            ItemCateSalePropVO responseInfo = (ItemCateSalePropVO)JSONUtil.toBean((String)mat.group(), ItemCateSalePropVO.class);
            prop.setCode(responseInfo.getCode());
            prop.setName(responseInfo.getName());
            prop.setValue(responseInfo.getValue());
            props.add(prop);
        }
        return props;
    }

    public String trueOrFalseTransfrom(Boolean flag) {
        if (null == flag) {
            return null;
        }
        if (flag.booleanValue()) {
            return TRUE;
        }
        return FALSE;
    }

    public void reflectionCateDescName(List<ItemCateDescNameVO> itemCateDescNameVOS, ItmApplyDCateExportVO itmApplyDCateExportVO) {
        Class<ItmApplyDCateExportVO> itmApplyDCateExportVOClass = ItmApplyDCateExportVO.class;
        List sortedList = itemCateDescNameVOS.stream().sorted(Comparator.comparing(ItemCateDescNameVO::getCatePropCode)).collect(Collectors.toList());
        int size = sortedList.size();
        if (size > 15) {
            size = 15;
        }
        for (int i = 1; i <= size; ++i) {
            ItemCateDescNameVO itemCateDescNameVO = (ItemCateDescNameVO)sortedList.get(i - 1);
            Method setName = null;
            try {
                setName = itmApplyDCateExportVOClass.getMethod("setDescNameValue" + i, String.class);
                setName.invoke((Object)itmApplyDCateExportVO, itemCateDescNameVO.getCatePropName());
                continue;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                log.error("\u53cd\u5c04\u8bbe\u7f6e\u54c1\u7c7b\u63cf\u8ff0\u5c5e\u6027\u540d\u79f0\u9519\u8bef:", (Throwable)e);
                throw new BusinessException("\u53cd\u5c04\u8bbe\u7f6e\u54c1\u7c7b\u63cf\u8ff0\u5c5e\u6027\u540d\u79f0\u9519\u8bef:", (Throwable)e);
            }
        }
    }

    public void reflectionItemDescValue(List<ItemCateDescPropVO> itemCateDescPropVOS, ItmExportDescPropVO descPropVO) {
        Class<ItmExportDescPropVO> itmItemApplyDExportVOClass = ItmExportDescPropVO.class;
        if (CollectionUtils.isEmpty(itemCateDescPropVOS)) {
            return;
        }
        List sortedList = itemCateDescPropVOS.stream().filter(vo -> vo.getCatePropCode() != null && StringUtils.isNotBlank((CharSequence)vo.getPropValue())).sorted(Comparator.comparing(ItemCateDescPropVO::getCatePropCode)).collect(Collectors.toList());
        int size = sortedList.size();
        if (size > 15) {
            size = 15;
        }
        for (int i = 1; i <= size; ++i) {
            ItemCateDescPropVO itemCateDescPropVO = (ItemCateDescPropVO)sortedList.get(i - 1);
            Method method = null;
            try {
                method = itmItemApplyDExportVOClass.getMethod("setDescNameValue" + i, String.class);
                method.invoke((Object)descPropVO, itemCateDescPropVO.getCatePropName() + ":" + itemCateDescPropVO.getPropValue());
                continue;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void reflectionItemSaleValue(List<ItemCateSalePropVO> itemCateSalePropVOS, ItmExportSalePropVO saleVo) {
        if (CollectionUtils.isEmpty(itemCateSalePropVOS)) {
            return;
        }
        Class<ItmExportSalePropVO> itmItemApplyDExportVOClass = ItmExportSalePropVO.class;
        int size = itemCateSalePropVOS.size();
        if (size > 3) {
            size = 3;
        }
        for (int i = 1; i <= size; ++i) {
            Method method = null;
            try {
                method = itmItemApplyDExportVOClass.getMethod("setItemAttr" + i, String.class);
                method.invoke((Object)saleVo, itemCateSalePropVOS.get(i - 1).getName() + ":" + itemCateSalePropVOS.get(i - 1).getValue());
                continue;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public ItmExportUtil(ItmCatePropRepoProc itmCatePropRepoProc, ItmItemCateService itmItemCateService) {
        this.itmCatePropRepoProc = itmCatePropRepoProc;
        this.itmItemCateService = itmItemCateService;
    }
}

