/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.regex.Pattern;

public class LocalDateTimeUtils {
    private static final String Z = "Z";
    private static final char T = 'T';
    private static final int SEPARATOR_INDEX = 10;
    private static final char SPACE = ' ';
    private static final String REGEX_DATETIME = "^(\\d{10,13}|\\d{4}-\\d{2}-\\d{2}.\\d{2}:\\d{2}.*)$";
    private static final String REGEX_DATE = "^(\\d{4}-\\d{2}-\\d{2})$";

    public static LocalDateTime convert(String resolver) {
        if (Pattern.matches(REGEX_DATE, resolver)) {
            LocalDate date = LocalDate.parse(resolver, DateTimeFormatter.ISO_LOCAL_DATE);
            return LocalDateTime.of(date, LocalTime.of(0, 0, 0, 0));
        }
        if (Pattern.matches(REGEX_DATETIME, resolver)) {
            if (resolver.endsWith(Z)) {
                return LocalDateTime.ofInstant(Instant.parse(resolver), ZoneId.systemDefault());
            }
            if (resolver.charAt(10) == 'T') {
                return LocalDateTime.parse(resolver, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
            if (resolver.charAt(10) == ' ') {
                return LocalDateTime.parse(resolver, new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter());
            }
        }
        switch (resolver.length()) {
            case 10: {
                Instant instant = Instant.ofEpochSecond(Long.parseLong(resolver));
                return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            }
            case 13: {
                Instant instant = Instant.ofEpochMilli(Long.parseLong(resolver));
                return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            }
        }
        throw new IllegalArgumentException("Datetime convert exception");
    }
}

