/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.util;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.exception.BusinessException;
import java.math.BigDecimal;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportAssert {
    private static final Logger log = LoggerFactory.getLogger(SupportAssert.class);

    public static void mathGreater(BigDecimal num1, BigDecimal num2, String message) {
        if (num1.compareTo(num2) < 0) {
            log.info("TradeAssert.mathGreater:false:{}", (Object)message);
            throw new BusinessException(message);
        }
    }

    public static void mathGreater(BigDecimal num1, BigDecimal num2, String message, Boolean appenFlag) {
        if (appenFlag.booleanValue()) {
            if (num1.compareTo(num2) < 0) {
                log.info("TradeAssert.mathGreater:false:{}", (Object)message);
                SupportAssert.throwEx(num1 + " " + num2);
            }
        } else {
            SupportAssert.mathGreater(num1, num2, message);
        }
    }

    public static void strEquals(String str1, String str2, String message) {
        if (StringUtils.isBlank((CharSequence)str1) || StringUtils.isBlank((CharSequence)str2) || !str1.equals(str2)) {
            log.info("TradeAssert.strEquals:false:{}", (Object)message);
            throw new BusinessException(message);
        }
    }

    public static void strNotEquals(String str1, String str2, String message) {
        if (StringUtils.isBlank((CharSequence)str1) || StringUtils.isBlank((CharSequence)str2) || str1.equals(str2)) {
            log.info("TradeAssert.strEquals:false:{}", (Object)message);
            throw new BusinessException(message);
        }
    }

    public static void isNotNull(Object obj, String message) {
        if (null == obj) {
            log.info("TradeAssert.isNotNull:false:{}", (Object)message);
            throw new BusinessException(message);
        }
    }

    public static void isNotBlank(String obj, String message) {
        if (StringUtils.isBlank((CharSequence)obj)) {
            log.info("TradeAssert.isNotBlank:false:{}", (Object)message);
            throw new BusinessException(message);
        }
    }

    public static void isNotEmpty(Collection collection, String message) {
        if (CollectionUtil.isEmpty((Collection)collection)) {
            log.info("TradeAssert.isNotEmpty:false:{}", (Object)message);
            throw new BusinessException(message);
        }
    }

    public static void isTrue(Boolean exp, String message) {
        if (null == exp || !exp.booleanValue()) {
            log.info("TradeAssert.isTrue:false:{}", (Object)message);
            throw new BusinessException(message);
        }
    }

    public static void isFalse(Boolean exp, String message) {
        if (null == exp || exp.booleanValue()) {
            log.info("TradeAssert.isTrue:false:{}", (Object)message);
            throw new BusinessException(message);
        }
    }

    public static void rpcSuccess(ApiResult<?> response, String message) {
        if (response == null || response.getCode() != 0) {
            log.info("TradeAssert.rpcSuccess:false:{}:{}", (Object)message);
            throw new BusinessException(message);
        }
    }

    public static void throwEx(String message) {
        throw new BusinessException(message);
    }

    public static void throwEx(ApiCode code, Object message) {
        throw new BusinessException(code, String.format(code.getMsg(), null == message ? "" : message));
    }

    public static void isEmptyResponse(ApiResult<?> response, String message) {
        if (null == response) {
            log.info("TradeAssert.isEmptyResponse:false:{}", (Object)message);
            throw new BusinessException(message);
        }
    }

    public static void isRpcFailure(ApiResult<?> response, String message) {
        SupportAssert.isEmptyResponse(response, message);
        SupportAssert.rpcSuccess(response, message);
    }
}

