/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.workflow;

import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.srmdomain.util.enumproduct.ItemDefKey;
import com.elitesland.yst.srmdomain.work.item.service.ItmIteWorkService;
import com.elitesland.yst.supportdomain.item.apply.entity.ItmItemApplyAlterDO;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyAlterRepo;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyAlterRepoProc;
import com.elitesland.yst.supportdomain.org.repo.OrgOuRepo;
import com.elitesland.yst.supportdomain.pri.entity.PriMainPriceAlterDO;
import com.elitesland.yst.supportdomain.pri.repo.PriMainPriceAlterRepo;
import com.elitesland.yst.supportdomain.workflow.ProcDefKey;
import com.elitesland.yst.supportdomain.workflow.service.ItemAddProcessService;
import com.elitesland.yst.supportdomain.workflow.service.ItemChangeProcessService;
import com.elitesland.yst.supportdomain.workflow.service.ItemPriceChangeProcessService;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@DubboService(group="ITEM")
public class ItemWorkflowCallBack
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(ItemWorkflowCallBack.class);
    private final PriMainPriceAlterRepo priMainPriceAlterRepo;
    private final ItmItemApplyAlterRepo itmItemApplyAlterRepo;
    private final ItmItemApplyAlterRepoProc itmItemApplyAlterRepoProc;
    private final OrgOuRepo orgOuRepo;
    private final ItemPriceChangeProcessService itemPriceChangeProcessService;
    private final ItemChangeProcessService itemChangeProcessService;
    private final ItemAddProcessService itemAddProcessService;
    private final ItmIteWorkService itmIteWorkService;

    public ArrayList<String> taskAssignee(String tenantId, String procDefKey, String taskKey, String businessKey, String customParams) {
        if (procDefKey.equals(ItemDefKey.ITM_ITEM_CREATE.getCode())) {
            return this.itmIteWorkService.taskAssignee(Long.parseLong(businessKey), customParams);
        }
        return new ArrayList<String>();
    }

    public void taskCreated(String tenantId, String procDefKey, String taskKey, String businessKey, Set<String> taskAssignees) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03: \u6d41\u7a0b\u5b9a\u4e49KEY:{},\u4efb\u52a1key:{},\u4e1a\u52a1key:{},\u5904\u7406\u4eba:{}", new Object[]{procDefKey, taskKey, businessKey, taskAssignees});
    }

    public void taskCompleted(String tenantId, String procDefKey, String taskKey, String businessKey, String taskHandler) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03: \u6d41\u7a0b\u5b9a\u4e49KEY:{},\u4efb\u52a1key:{},\u4e1a\u52a1key:{}\uff0c\u4efb\u52a1\u5904\u7406\u4eba{}", new Object[]{procDefKey, taskKey, businessKey, taskHandler});
    }

    public void processStatusChange(String tenantId, String procDefKey, ProcInstStatus procInstStatus, String businessKey, CommentInfo commentInfo) {
        log.info("\u6d41\u7a0b\u56de\u8c03 procDefKey:" + procDefKey + " ,procInstStatus:" + procInstStatus + ",businessKey:" + businessKey + ",commentInfo:" + commentInfo);
        if (procDefKey.equals(ProcDefKey.ITEM_PRICE_CHANGE.name())) {
            this.itemPriceChangeProcessService.processStatusChange(Long.parseLong(businessKey), procInstStatus);
        }
        if (procDefKey.endsWith(ProcDefKey.ITEM_ADD.name())) {
            this.itemAddProcessService.processStatusChange(businessKey, procInstStatus);
        }
        if (procDefKey.endsWith(ProcDefKey.ITEM_INFO_CHANGE.name())) {
            this.itemChangeProcessService.processStatusChange(businessKey, procInstStatus);
        }
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03 tenantId:{},procDefKey:{},procInstStatus:{},businessKey:{},commentInfo:{}", new Object[]{tenantId, procDefKey, procInstStatus, businessKey, commentInfo});
        if (procDefKey.equals(ItemDefKey.ITM_ITEM_CREATE.getCode())) {
            this.itmIteWorkService.processStatusChange(Long.parseLong(businessKey), procInstStatus);
        }
    }

    private Long getOuId(String businessKey) {
        Optional priMainPriceAlterDO = this.priMainPriceAlterRepo.findById(Long.valueOf(businessKey));
        Long ouId = null;
        if (!priMainPriceAlterDO.isEmpty()) {
            PriMainPriceAlterDO mainPriceAlterDO = (PriMainPriceAlterDO)priMainPriceAlterDO.get();
            ouId = mainPriceAlterDO.getOuId();
        }
        return ouId;
    }

    private Long getOuIdByItemAddAndItemChange(String businessKey) {
        Optional<ItmItemApplyAlterDO> byDocNo = this.itmItemApplyAlterRepo.findByDocNo(businessKey);
        log.info("\u83b7\u53d6\u5546\u54c1\u53d8\u66f4\u4e0e\u5546\u54c1\u65b0\u5efa\u7533\u8bf7\u5355\u516c\u53f8\u7684id\u65b9\u6cd5\u5165\u53c2\uff1a{}", (Object)businessKey);
        Long ouId = null;
        if (!byDocNo.isEmpty()) {
            ItmItemApplyAlterDO itemApplyAlterDO = byDocNo.get();
            ouId = itemApplyAlterDO.getOuId();
        }
        if (byDocNo.isPresent()) {
            log.info("\u83b7\u53d6\u5546\u54c1\u53d8\u66f4\u4e0e\u5546\u54c1\u65b0\u5efa\u7533\u8bf7\u5355\u516c\u53f8\u7684id\u65b9\u6cd5\u8fd4\u56de\u7ed3\u679c\uff1a" + byDocNo.get());
        }
        return ouId;
    }

    public ItemWorkflowCallBack(PriMainPriceAlterRepo priMainPriceAlterRepo, ItmItemApplyAlterRepo itmItemApplyAlterRepo, ItmItemApplyAlterRepoProc itmItemApplyAlterRepoProc, OrgOuRepo orgOuRepo, ItemPriceChangeProcessService itemPriceChangeProcessService, ItemChangeProcessService itemChangeProcessService, ItemAddProcessService itemAddProcessService, ItmIteWorkService itmIteWorkService) {
        this.priMainPriceAlterRepo = priMainPriceAlterRepo;
        this.itmItemApplyAlterRepo = itmItemApplyAlterRepo;
        this.itmItemApplyAlterRepoProc = itmItemApplyAlterRepoProc;
        this.orgOuRepo = orgOuRepo;
        this.itemPriceChangeProcessService = itemPriceChangeProcessService;
        this.itemChangeProcessService = itemChangeProcessService;
        this.itemAddProcessService = itemAddProcessService;
        this.itmIteWorkService = itmIteWorkService;
    }
}

