/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.workflow.service.impl;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.item.apply.entity.ItmItemApplyAlterDO;
import com.elitesland.yst.supportdomain.item.apply.entity.QItmItemApplyAlterDO;
import com.elitesland.yst.supportdomain.item.apply.entity.QItmItemApplyDO;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyAlterRepo;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyRepoProc;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyService;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.util.ComUdcEnum;
import com.elitesland.yst.supportdomain.workflow.service.ItemAddProcessService;
import com.elitesland.yst.system.param.SysUserIdFlowRoleRpcParam;
import com.elitesland.yst.system.service.SysUserFlowRoleRpcService;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ItemAddProcessServiceImpl
implements ItemAddProcessService {
    private static final Logger log = LoggerFactory.getLogger(ItemAddProcessServiceImpl.class);
    @DubboReference
    private SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    private final ItmItemApplyService itmItemApplyService;
    private final ItmItemApplyAlterRepo itmItemApplyAlterRepo;
    private final ItmItemApplyRepoProc itmItemApplyRepoProc;
    private final JPAQueryFactory jpaQueryFactory;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(String docNo, ProcInstStatus procInstStatus) {
        Optional<ItmItemApplyAlterDO> byDocNo = this.itmItemApplyAlterRepo.findByDocNo(docNo);
        if (byDocNo.isEmpty()) {
            throw new BusinessException("\u5355\u636e\u53f7:" + docNo + "\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        log.info("\u5f00\u59cb\u5546\u54c1\u65b0\u5efa\u5de5\u4f5c\u6d41\u56de\u8c03\uff0c\u6d41\u7a0b\u72b6\u6001\u4e3a:" + procInstStatus.getDesc());
        QItmItemApplyAlterDO qItmItemApplyAlterDO = QItmItemApplyAlterDO.itmItemApplyAlterDO;
        QItmItemApplyDO itmItemApply = QItmItemApplyDO.itmItemApplyDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qItmItemApplyAlterDO).set(qItmItemApplyAlterDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{qItmItemApplyAlterDO.id.eq((Object)byDocNo.get().getId())});
        JPAUpdateClause itemUpdate = this.jpaQueryFactory.update((EntityPath)itmItemApply).set((Path)itmItemApply.docNo, (Object)docNo).where(new Predicate[]{itmItemApply.docNo.eq((Object)docNo)});
        switch (procInstStatus) {
            case NOTSUBMIT: {
                itemUpdate.set((Path)itmItemApply.itemStatus, (Object)ItmUdcEnum.ITM_ITEM_APPLY_STATUS_DRAFT.getUdcVal());
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)qItmItemApplyAlterDO.docStatus, (Object)ComUdcEnum.COM_APPLY_STATUS_DRAFT.getUdcVal());
                jpaUpdateClause.setNull((Path)qItmItemApplyAlterDO.procInstId);
                jpaUpdateClause.setNull(qItmItemApplyAlterDO.procInstStatus);
                itemUpdate.set((Path)itmItemApply.itemStatus, (Object)ItmUdcEnum.ITM_ITEM_APPLY_STATUS_DRAFT.getUdcVal());
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)qItmItemApplyAlterDO.docStatus, (Object)ComUdcEnum.COM_APPLY_STATUS_REJECTED.getUdcVal());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)qItmItemApplyAlterDO.docStatus, (Object)ComUdcEnum.COM_APPLY_STATUS_VOID.getUdcVal());
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)qItmItemApplyAlterDO.docStatus, (Object)ComUdcEnum.COM_APPLY_STATUS_DOING.getUdcVal());
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)qItmItemApplyAlterDO.docStatus, (Object)ComUdcEnum.COM_APPLY_STATUS_COMPLETE.getUdcVal()).set(qItmItemApplyAlterDO.approvedTime, (Object)LocalDateTime.now());
                break;
            }
        }
        jpaUpdateClause.execute();
        itemUpdate.execute();
        log.info("\u5f00\u59cb\u5904\u7406\u5de5\u4f5c\u6d41\u56de\u8c03\u4e1a\u52a1--------");
        if (procInstStatus.equals((Object)ProcInstStatus.APPROVED)) {
            log.info("\u5546\u54c1\u65b0\u5efa\u5de5\u4f5c\u6d41\uff1a\u5c06\u6570\u636e\u66f4\u65b0\u5230\u6b63\u5f0f\u8868\u4e2d");
            this.itmItemApplyService.insertItemApplyComplete(docNo);
        }
        if (procInstStatus.equals((Object)ProcInstStatus.REJECTED)) {
            log.info("\u5982\u679c\u88ab\u9a73\u56de\u7b2c\u4e00\u4e2a\u8282\u70b9\u65f6\uff0c\u6b64\u65f6\u6d41\u7a0b\u72b6\u6001\u4e3a\u5df2\u62d2\u7edd\uff0c\u5355\u636e\u72b6\u6001\u4e5f\u4e3a\u5df2\u62d2\u7edd\uff0c\u5546\u54c1\u72b6\u6001\u5e94\u4e3a\u5ba1\u6838\u672a\u901a\u8fc7");
            this.itmItemApplyService.rejectApplication(docNo);
        }
        if (procInstStatus.equals((Object)ProcInstStatus.INVALID)) {
            log.info("\u5982\u679c\u5355\u636e\u4f5c\u5e9f\uff0c\u6b64\u65f6\u6d41\u7a0b\u72b6\u6001\u4e3a\u4f5c\u5e9f\uff0c\u5355\u636e\u72b6\u6001\u4e5f\u4e3a\u4f5c\u5e9f\uff0c\u5546\u54c1\u72b6\u6001\u4e3a\u8349\u7a3f\u72b6\u6001");
            this.itmItemApplyService.voidApplication(docNo);
        }
        if (procInstStatus.equals((Object)ProcInstStatus.NOTSUBMIT)) {
            log.info("\u5982\u679c\u521b\u5efa\u4eba\uff0c\u5728\u7b2c\u4e00\u4e2a\u8282\u70b9\u64a4\u56de\u65f6\uff0c\u6b64\u65f6\u6d41\u7a0b\u72b6\u6001\u4e3a\u672a\u63d0\u4ea4\uff0c\u5355\u636e\u72b6\u6001\u4e3a\u8349\u7a3f\uff0c\u5546\u54c1\u72b6\u6001\u4e5f\u4e3a\u8349\u7a3f");
            this.itmItemApplyRepoProc.changeItemApplyStatusByDocNo(docNo, ItmUdcEnum.ITM_ITEM_APPLY_STATUS_DRAFT.getUdcVal());
        }
    }

    @Override
    public ArrayList<String> taskAssignee(Long id, String customParams) {
        List<Long> userIds = this.findUserIdsByFlowRoles(id, customParams);
        log.info("\u8c03\u7528\u7cfb\u7edf\u57df\u8fd4\u56de\u7684userIds: {}", userIds);
        ArrayList<String> userStrIds = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(userIds)) {
            userIds.stream().forEach(i -> {
                String newString = String.valueOf(i);
                userStrIds.add(newString);
            });
            return userStrIds;
        }
        return new ArrayList<String>();
    }

    public List<Long> findUserIdsByFlowRoles(Long ouId, String customParams) {
        try {
            log.info("\u8c03\u7528\u7cfb\u7edf\u57df\u6d41\u7a0b\u63a5\u53e3\u5165\u53c2 ouId: {}, customParams\uff1a{}", (Object)ouId, (Object)customParams);
            SysUserIdFlowRoleRpcParam param = new SysUserIdFlowRoleRpcParam();
            param.setOuIds(Collections.singletonList(ouId));
            param.setFlowRoleCodes(Collections.singletonList(customParams));
            List userIds = this.sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
            if (!CollectionUtils.isEmpty((Collection)userIds)) {
                return userIds;
            }
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
        return new ArrayList<Long>();
    }

    public ItemAddProcessServiceImpl(ItmItemApplyService itmItemApplyService, ItmItemApplyAlterRepo itmItemApplyAlterRepo, ItmItemApplyRepoProc itmItemApplyRepoProc, JPAQueryFactory jpaQueryFactory) {
        this.itmItemApplyService = itmItemApplyService;
        this.itmItemApplyAlterRepo = itmItemApplyAlterRepo;
        this.itmItemApplyRepoProc = itmItemApplyRepoProc;
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

