/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.workflow.service.impl;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.pri.entity.PriMainPriceAlterDRowDO;
import com.elitesland.yst.supportdomain.pri.entity.QPriMainPriceAlterDO;
import com.elitesland.yst.supportdomain.pri.enums.PriMainPriceUdcEnum;
import com.elitesland.yst.supportdomain.pri.repo.PriMainPriceAlterDRowRepo;
import com.elitesland.yst.supportdomain.pri.repo.PriMainPriceAlterRepo;
import com.elitesland.yst.supportdomain.pri.service.PriPriceChangeService;
import com.elitesland.yst.supportdomain.util.ComUdcEnum;
import com.elitesland.yst.supportdomain.workflow.service.ItemPriceChangeProcessService;
import com.elitesland.yst.system.param.SysUserIdFlowRoleRpcParam;
import com.elitesland.yst.system.service.SysUserFlowRoleRpcService;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ItemPriceChangeProcessServiceImpl
implements ItemPriceChangeProcessService {
    private static final Logger log = LoggerFactory.getLogger(ItemPriceChangeProcessServiceImpl.class);
    @DubboReference
    private SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    private final PriMainPriceAlterRepo priMainPriceAlterRepo;
    private final JPAQueryFactory jpaQueryFactory;
    private final PriPriceChangeService priPriceChangeService;
    private final PriMainPriceAlterDRowRepo priMainPriceAlterDRowRepo;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus) {
        Optional mainPriceAlterRepoById = this.priMainPriceAlterRepo.findById(id);
        if (!mainPriceAlterRepoById.isPresent()) {
            throw new BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QPriMainPriceAlterDO qPriMainPriceAlterDO = QPriMainPriceAlterDO.priMainPriceAlterDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qPriMainPriceAlterDO).set(qPriMainPriceAlterDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{qPriMainPriceAlterDO.id.eq((Object)id)});
        switch (procInstStatus) {
            case NOTSUBMIT: 
            case INTERRUPT: {
                jpaUpdateClause.set((Path)qPriMainPriceAlterDO.docStatus, (Object)ComUdcEnum.COM_APPLY_STATUS_DRAFT.getUdcVal());
                jpaUpdateClause.setNull((Path)qPriMainPriceAlterDO.procInstId);
                jpaUpdateClause.setNull(qPriMainPriceAlterDO.procInstStatus);
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)qPriMainPriceAlterDO.docStatus, (Object)ComUdcEnum.COM_APPLY_STATUS_REJECTED.getUdcVal());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)qPriMainPriceAlterDO.docStatus, (Object)ComUdcEnum.COM_APPLY_STATUS_VOID.getUdcVal());
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)qPriMainPriceAlterDO.docStatus, (Object)ComUdcEnum.COM_APPLY_STATUS_DOING.getUdcVal());
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)qPriMainPriceAlterDO.docStatus, (Object)ComUdcEnum.COM_APPLY_STATUS_COMPLETE.getUdcVal()).set(qPriMainPriceAlterDO.approvedTime, (Object)LocalDateTime.now());
            }
        }
        jpaUpdateClause.execute();
        if (procInstStatus.equals((Object)ProcInstStatus.APPROVED)) {
            List<PriMainPriceAlterDRowDO> priMainPriceAlterDRowDOs = this.priMainPriceAlterDRowRepo.findAllByMasId(id);
            this.priPriceChangeService.updateMainPriceAlterMethod(priMainPriceAlterDRowDOs, PriMainPriceUdcEnum.PRI_PRICE_TYPE_ITEM_PRICE.getUdcVal());
        }
    }

    @Override
    public ArrayList<String> taskAssignee(Long id, String customParams) {
        List<Long> userIds = this.findUserIdsByFlowRoles(id, customParams);
        log.info("\u8c03\u7528\u7cfb\u7edf\u57df\u8fd4\u56de\u7684userIds: {}", userIds);
        ArrayList<String> userStrIds = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(userIds)) {
            userIds.stream().forEach(i -> {
                String newString = String.valueOf(i);
                userStrIds.add(newString);
            });
            return userStrIds;
        }
        return null;
    }

    public List<Long> findUserIdsByFlowRoles(Long ouId, String customParams) {
        try {
            log.info("\u8c03\u7528\u7cfb\u7edf\u57df\u6d41\u7a0b\u63a5\u53e3\u5165\u53c2 ouId: {}, customParams\uff1a{}", (Object)ouId, (Object)customParams);
            SysUserIdFlowRoleRpcParam param = new SysUserIdFlowRoleRpcParam();
            param.setOuIds(Collections.singletonList(ouId));
            param.setFlowRoleCodes(Collections.singletonList(customParams));
            List userIds = this.sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
            if (!CollectionUtils.isEmpty((Collection)userIds)) {
                return userIds;
            }
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
        return null;
    }

    public ItemPriceChangeProcessServiceImpl(PriMainPriceAlterRepo priMainPriceAlterRepo, JPAQueryFactory jpaQueryFactory, PriPriceChangeService priPriceChangeService, PriMainPriceAlterDRowRepo priMainPriceAlterDRowRepo) {
        this.priMainPriceAlterRepo = priMainPriceAlterRepo;
        this.jpaQueryFactory = jpaQueryFactory;
        this.priPriceChangeService = priPriceChangeService;
        this.priMainPriceAlterDRowRepo = priMainPriceAlterDRowRepo;
    }
}

