/*
 Navicat Premium Data Transfer

 Source Server         : Elitesland
 Source Server Type    : MySQL
 Source Server Version : 50732
 Source Host           : eldb.elitescloud.com:3306
 Source Schema         : yst_cbpl_support

 Target Server Type    : MySQL
 Target Server Version : 50732
 File Encoding         : 65001

 Date: 08/04/2022 09:55:00
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for com_city_code
-- ----------------------------
CREATE TABLE IF NOT EXISTS `com_city_code`
(
    `id`                 bigint(20)  NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `area_name`          varchar(40) NOT NULL COMMENT '区域名称',
    `area_code`          varchar(40) NOT NULL COMMENT '区域代码',
    `area_type`          varchar(40)  DEFAULT NULL COMMENT '区域类型',
    `short_name`         varchar(40)  DEFAULT NULL COMMENT '区域简称',
    `english_name`       varchar(40)  DEFAULT NULL COMMENT '英文名称',
    `area_level`         varchar(40)  DEFAULT NULL COMMENT '区域等级',
    `pid`                bigint(20)  NOT NULL COMMENT '上级ID',
    `area_status`        varchar(40)  DEFAULT NULL COMMENT '地址状态',
    `area_spell`         varchar(40)  DEFAULT NULL COMMENT '汉语拼音',
    `area_shspell`       varchar(40)  DEFAULT NULL COMMENT '拼音首字母',
    `tel_head`           varchar(40)  DEFAULT NULL COMMENT '区号',
    `zip_code`           varchar(40)  DEFAULT NULL COMMENT '邮编',
    `area_desc`          varchar(255) DEFAULT NULL COMMENT '区域描述',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)     NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `uk_area_area_code` (`area_code`) USING BTREE,
    INDEX `idx_area_pid` (`pid`) USING BTREE,
    INDEX `idx_area_area_name` (`area_name`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '区域定义';

-- ----------------------------
-- Table structure for com_city_code_copy1
-- ----------------------------
CREATE TABLE IF NOT EXISTS `com_city_code_copy1`
(
    `id`                 bigint(20)  NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
    `area_name`          varchar(40) NOT NULL,
    `area_code`          varchar(40) NOT NULL,
    `area_type`          varchar(40)  DEFAULT NULL,
    `short_name`         varchar(40)  DEFAULT NULL,
    `english_name`       varchar(40)  DEFAULT NULL,
    `area_level`         varchar(40)  DEFAULT NULL,
    `pid`                bigint(20)  NOT NULL COMMENT '上级ID',
    `sort_no`            int(11)      DEFAULT NULL,
    `area_status`        varchar(40)  DEFAULT NULL,
    `area_spell`         varchar(40)  DEFAULT NULL,
    `area_shspell`       varchar(40)  DEFAULT NULL,
    `tel_head`           varchar(40)  DEFAULT NULL,
    `zip_code`           varchar(40)  DEFAULT NULL,
    `area_desc`          varchar(255) DEFAULT NULL,
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `uk_area_area_code` (`area_code`) USING BTREE,
    INDEX `idx_area_pid` (`pid`) USING BTREE,
    INDEX `idx_area_area_name` (`area_name`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE
) COMMENT = '区域定义';

-- ----------------------------
-- Table structure for com_currency
-- ----------------------------
CREATE TABLE IF NOT EXISTS `com_currency`
(
    `id`                 bigint(20)  NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `ou_id`              bigint(20)   DEFAULT NULL COMMENT '公司ID',
    `curr_code`          varchar(40) NOT NULL COMMENT '币种编号',
    `curr_name`          varchar(40) NOT NULL COMMENT '币种名称',
    `disp_decimal`       int(11)      DEFAULT NULL COMMENT '显示小数位数',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)     NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `uk_curr_code` (`curr_code`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '币种';

-- ----------------------------
-- Table structure for com_file
-- ----------------------------
CREATE TABLE IF NOT EXISTS `com_file`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `file_code`          varchar(255) DEFAULT NULL COMMENT '文件编码，文件服务器上的文件唯一标识',
    `original_name`      varchar(255) DEFAULT NULL COMMENT '文件原名称',
    `file_size`          bigint(20)   DEFAULT NULL COMMENT '文件大小，字节B',
    `suffix`             varchar(255) DEFAULT NULL COMMENT '文件名后缀',
    `mime_type`          varchar(40)  DEFAULT NULL COMMENT '文件内容类型，mime-type',
    `file_type`          varchar(40)  DEFAULT NULL COMMENT '常见的文件类型（IMAGE-图片，AUDIO-音频，VIDEO-视频），为空则表示不常见',
    `upload_time`        datetime(6)  DEFAULT NULL COMMENT '上传时间',
    `width`              int(11)      DEFAULT NULL COMMENT '宽度，图片时有值',
    `height`             int(11)      DEFAULT NULL COMMENT '高度，图片时有值',
    `url_preview`        varchar(255) DEFAULT NULL COMMENT '文件预览url',
    `url_download`       varchar(255) DEFAULT NULL COMMENT '文件下载url',
    `url_delete`         varchar(255) DEFAULT NULL COMMENT '文件删除url',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '文件上传记录';

-- ----------------------------
-- Table structure for common_org_bu_treed
-- ----------------------------
CREATE TABLE IF NOT EXISTS `common_org_bu_treed`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `pid`                bigint(20) NOT NULL COMMENT '上级ID',
    `sort_no`            int(11)      DEFAULT NULL COMMENT '排序号',
    `grade`              int(11)      DEFAULT NULL COMMENT '层级',
    `code_path`          varchar(255) DEFAULT NULL COMMENT '树型结构编号全路径，使用/隔离',
    `bu_tree_id`         bigint(20)   DEFAULT NULL COMMENT '组织树ID',
    `bu_id`              bigint(20)   DEFAULT NULL COMMENT '组织ID',
    `bu_code`            varchar(40)  DEFAULT NULL,
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_bu_tree_pid` (`pid`) USING BTREE,
    INDEX `idx_bu_tree_code_path` (`code_path`) USING BTREE
) COMMENT = '组织树明细';

-- ----------------------------
-- Table structure for common_org_emp
-- ----------------------------
CREATE TABLE IF NOT EXISTS `common_org_emp`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `pid`                bigint(20) NOT NULL COMMENT '上级ID',
    `sort_no`            int(11)         DEFAULT NULL COMMENT '排序号',
    `grade`              int(11)         DEFAULT NULL COMMENT '层级',
    `code_path`          varchar(255)    DEFAULT NULL COMMENT '树型结构编号全路径，使用/隔离',
    `ou_id`              bigint(20)      DEFAULT NULL COMMENT '公司ID',
    `ou_code`            varchar(40)     DEFAULT NULL COMMENT '公司编号',
    `ou_name`            varchar(40)     DEFAULT NULL COMMENT '公司名称',
    `bu_id`              bigint(20)      DEFAULT NULL COMMENT 'BU ID',
    `bu_code`            varchar(40)     DEFAULT NULL COMMENT 'BU编号',
    `bu_name`            varchar(40)     DEFAULT NULL COMMENT 'BU名称',
    `emp_bu_id`          bigint(20)      DEFAULT NULL COMMENT '员工所属 BU ID',
    `emp_bu_tree_id`     bigint(20)      DEFAULT NULL COMMENT '员工所属BU树ID',
    `emp_bu_treedid`     bigint(20)      DEFAULT NULL COMMENT '员工所属BU树详情ID',
    `user_id`            bigint(20)      DEFAULT NULL COMMENT '用户id',
    `user_name`          varchar(40)     DEFAULT NULL COMMENT '用户名',
    `emp_code`           varchar(40)     DEFAULT NULL COMMENT '雇员编号',
    `emp_name`           varchar(40)     DEFAULT NULL COMMENT '雇员姓名',
    `emp_type`           varchar(255)    DEFAULT NULL COMMENT '员工类型 [UDC]ORG:EMP_TYPE',
    `emp_type2`          varchar(40)     DEFAULT NULL COMMENT '员工类型2',
    `emp_type3`          varchar(40)     DEFAULT NULL COMMENT '员工类型3',
    `emp_status`         varchar(40)     DEFAULT NULL COMMENT '员工状态 [UDC]ORG:EMP_STATUS',
    `foreign_name`       varchar(40)     DEFAULT NULL COMMENT '雇员外文名',
    `addr_no`            bigint(20)      DEFAULT NULL COMMENT '地址号',
    `emp_gender`         varchar(40)     DEFAULT NULL COMMENT '员工性别',
    `birth_date`         datetime(6)     DEFAULT NULL COMMENT '出生日期',
    `email`              varchar(40)     DEFAULT NULL COMMENT '工作邮箱',
    `mobile`             varchar(40)     DEFAULT NULL COMMENT '工作手机号',
    `id_type`            varchar(40)     DEFAULT NULL COMMENT '证件类型',
    `id_no`              varchar(255)    DEFAULT NULL COMMENT '证件号码',
    `emp_level`          varchar(40)     DEFAULT NULL COMMENT '职级',
    `title`              varchar(40)     DEFAULT NULL COMMENT '行政职位, [UDC]ORG:TITLE',
    `join_date`          datetime(6)     DEFAULT NULL COMMENT '入职日期',
    `jdy_flag`           int(11)    NULL DEFAULT 1 COMMENT '是否同步激荡云,默认 1 ',
    `leave_date`         datetime(6)     DEFAULT NULL COMMENT '离职日期',
    `tenant_id`          bigint(20)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)         DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)      DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_emp_pid` (`pid`) USING BTREE,
    INDEX `idx_emp_code_path` (`code_path`) USING BTREE
) COMMENT = '员工';

-- ----------------------------
-- Table structure for cpcnt_attach
-- ----------------------------
CREATE TABLE IF NOT EXISTS `cpcnt_attach`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `pay_type`           varchar(40)   DEFAULT NULL COMMENT '支付类别',
    `app_id`             varchar(40)   DEFAULT NULL COMMENT 'jsapi',
    `auth_path`          varchar(1024) DEFAULT NULL COMMENT '当开通微信公众号支付时此字段必填',
    `relate_user_id`     varchar(40)   DEFAULT NULL COMMENT '来源用户id',
    `tenant_id`          bigint(20)    DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)  DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)    DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)  DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)   DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)    DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)  DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)   DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)       DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)    DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)    DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)    DEFAULT NULL COMMENT 'sec_ou_id',
    `pay_way`            varchar(40)   DEFAULT NULL COMMENT '支付方式',
    `binding_tx_sn2734`  varchar(40)   DEFAULT NULL COMMENT '银行账户绑定流水号2734',
    `relate_tx_no`       varchar(40)   DEFAULT NULL COMMENT '主表流水号',
    `src_doc_id`         bigint(20)    DEFAULT NULL COMMENT '来源单据ID',
    `src_doc_no`         varchar(40)   DEFAULT NULL COMMENT '来源单据编号',
    `category`           varchar(40)   DEFAULT NULL COMMENT '行业类别',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '中金支付方式实体类实体类';

-- ----------------------------
-- Table structure for cpcnt_bank
-- ----------------------------
CREATE TABLE IF NOT EXISTS `cpcnt_bank`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `bank_id`            varchar(40)  DEFAULT NULL COMMENT '银行编码',
    `bank_name`          varchar(100) DEFAULT NULL COMMENT '银行名称',
    `es1`                varchar(40)  DEFAULT NULL COMMENT '备用es1',
    `es2`                varchar(40)  DEFAULT NULL COMMENT '备用es2',
    `es3`                varchar(40)  DEFAULT NULL COMMENT '备用es3',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '中金银行编码实体类';

-- ----------------------------
-- Table structure for cpcnt_category
-- ----------------------------
CREATE TABLE IF NOT EXISTS `cpcnt_category`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `category_id`        varchar(40)  DEFAULT NULL COMMENT '分类类别编码',
    `category_name`      varchar(100) DEFAULT NULL COMMENT '分类类别名称',
    `es1`                varchar(40)  DEFAULT NULL COMMENT '备用es1',
    `es2`                varchar(40)  DEFAULT NULL COMMENT '备用es2',
    `es3`                varchar(40)  DEFAULT NULL COMMENT '备用es3',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '中金分类类别实体类';

-- ----------------------------
-- Table structure for cpcnt_district
-- ----------------------------
CREATE TABLE IF NOT EXISTS `cpcnt_district`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `district_id`        varchar(40)  DEFAULT NULL COMMENT '市县区编码',
    `parent_id`          varchar(40)  DEFAULT NULL COMMENT '父级id',
    `district_name`      varchar(40)  DEFAULT NULL COMMENT '市县区名称',
    `es1`                varchar(40)  DEFAULT NULL COMMENT '备用es1',
    `es2`                varchar(40)  DEFAULT NULL COMMENT '备用es2',
    `es3`                varchar(40)  DEFAULT NULL COMMENT '备用es3',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '中金市县区编码实体类';

-- ----------------------------
-- Table structure for cpcnt_image
-- ----------------------------
CREATE TABLE IF NOT EXISTS `cpcnt_image`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `image_info`         varchar(40)  DEFAULT NULL COMMENT '影印件明细',
    `image_type`         varchar(40)  DEFAULT NULL COMMENT '影印件类别',
    `image_content`      varchar(40)  DEFAULT NULL COMMENT '内容',
    `relate_user_id`     varchar(40)  DEFAULT NULL COMMENT '来源用户id',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '中金影印象实体类';

-- ----------------------------
-- Table structure for cpcnt_incoming_parts
-- ----------------------------
CREATE TABLE IF NOT EXISTS `cpcnt_incoming_parts`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `dead_line`          varchar(40)  DEFAULT NULL COMMENT '交易编码',
    `pay_type`           varchar(40)  DEFAULT NULL COMMENT '支付类别',
    `pay_way`            varchar(40)  DEFAULT NULL COMMENT '支付方式',
    `app_id`             varchar(40)  DEFAULT NULL COMMENT 'jsapi',
    `user_id`            varchar(40)  DEFAULT NULL COMMENT '用户id',
    `auth_path`          varchar(40)  DEFAULT NULL COMMENT '当开通微信公众号支付时此字段必填',
    `src_doc_id`         bigint(20)   DEFAULT NULL COMMENT '来源单据ID',
    `src_doc_no`         varchar(40)  DEFAULT NULL COMMENT '来源单据编号',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `tx_code`            varchar(40)  DEFAULT NULL COMMENT '交易编码',
    `tx_no`              varchar(40)  DEFAULT NULL COMMENT '银行账户绑定流水号2734',
    `category`           varchar(40)  DEFAULT NULL COMMENT '行业类别',
    `service_phone`      varchar(40)  DEFAULT NULL COMMENT '客服电话',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '中金进件确认实体类';

-- ----------------------------
-- Table structure for cpcnt_industry
-- ----------------------------
CREATE TABLE IF NOT EXISTS `cpcnt_industry`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `industry_id`        varchar(40)  DEFAULT NULL COMMENT '行业编码',
    `industry_name`      varchar(100) DEFAULT NULL COMMENT '行业名称',
    `es1`                varchar(40)  DEFAULT NULL COMMENT '备用es1',
    `es2`                varchar(40)  DEFAULT NULL COMMENT '备用es2',
    `es3`                varchar(40)  DEFAULT NULL COMMENT '备用es3',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '中金通用行业代码实体类';

-- ----------------------------
-- Table structure for cpcnt_industry_type
-- ----------------------------
CREATE TABLE IF NOT EXISTS `cpcnt_industry_type`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `industry_type_id`   varchar(40)  DEFAULT NULL COMMENT '行业编码',
    `industry_type_name` varchar(100) DEFAULT NULL COMMENT '行业名称',
    `es1`                varchar(40)  DEFAULT NULL COMMENT '备用es1',
    `es2`                varchar(40)  DEFAULT NULL COMMENT '备用es2',
    `es3`                varchar(40)  DEFAULT NULL COMMENT '备用es3',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '中金行业代码实体类';

-- ----------------------------
-- Table structure for cpcnt_merchant
-- ----------------------------
CREATE TABLE IF NOT EXISTS `cpcnt_merchant`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `merchant_id`        varchar(40)  DEFAULT NULL COMMENT '行业代码',
    `merchant_name`      varchar(40)  DEFAULT NULL COMMENT '行业描述',
    `merchant_type`      varchar(100) DEFAULT NULL COMMENT '支付类别',
    `es1`                varchar(40)  DEFAULT NULL COMMENT '备用es1',
    `es2`                varchar(40)  DEFAULT NULL COMMENT '备用es2',
    `es3`                varchar(40)  DEFAULT NULL COMMENT '备用es3',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '中金商户进件行业类别代码实体类';

-- ----------------------------
-- Table structure for cpcnt_province
-- ----------------------------
CREATE TABLE IF NOT EXISTS `cpcnt_province`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `province_id`        varchar(40)  DEFAULT NULL COMMENT '省份编码',
    `province_name`      varchar(40)  DEFAULT NULL COMMENT '省份名称',
    `es1`                varchar(40)  DEFAULT NULL COMMENT '备用es1',
    `es2`                varchar(40)  DEFAULT NULL COMMENT '备用es2',
    `es3`                varchar(40)  DEFAULT NULL COMMENT '备用es3',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '中金省份编码实体类';

-- ----------------------------
-- Table structure for cpcnt_request
-- ----------------------------
CREATE TABLE IF NOT EXISTS `cpcnt_request`
(
    `id`                           bigint(20) NOT NULL COMMENT '记录唯一ID',
    `dead_line`                    varchar(40)    DEFAULT NULL COMMENT '交易编码',
    `institution_id`               varchar(40)    DEFAULT NULL COMMENT '机构编号',
    `binding_tx_sn4611`            varchar(40)    DEFAULT NULL COMMENT '银行账户绑定流水号4611',
    `binding_tx_sn4601`            varchar(40)    DEFAULT NULL COMMENT '银行账户绑定流水号4601',
    `binding_tx_sn7703`            varchar(40)    DEFAULT NULL COMMENT '银行账户绑定流水号7703',
    `binding_tx_sn2734`            varchar(40)    DEFAULT NULL COMMENT '银行账户绑定流水号2734',
    `user_id`                      varchar(40)    DEFAULT NULL COMMENT '用户id',
    `payee_user_id`                varchar(40)    DEFAULT NULL COMMENT '收款用户id',
    `acceptance_confirmtype`       varchar(40)    DEFAULT NULL COMMENT '确权方式',
    `bank_card_type`               varchar(40)    DEFAULT NULL COMMENT '卡类型',
    `operation_flag`               varchar(40)    DEFAULT NULL COMMENT '操作标识',
    `upgrade_txsn`                 varchar(40)    DEFAULT NULL COMMENT '绑卡升级交易流水号',
    `binding_way`                  varchar(40)    DEFAULT NULL COMMENT '绑卡验证方式',
    `credential_type`              varchar(40)    DEFAULT NULL COMMENT '证件类型',
    `credential_number`            varchar(40)    DEFAULT NULL COMMENT '身份证号',
    `credential_address`           varchar(40)    DEFAULT NULL COMMENT '身份证地址',
    `bank_id`                      varchar(40)    DEFAULT NULL COMMENT '绑定银行id',
    `bank_account_type`            varchar(40)    DEFAULT NULL COMMENT '户类型:11=个人账户 12=企业账户',
    `bank_account_name`            varchar(40)    DEFAULT NULL COMMENT '银行账户名称',
    `bank_account_number`          varchar(40)    DEFAULT NULL COMMENT '银行账户号码',
    `bank_phone_number`            varchar(40)    DEFAULT NULL COMMENT '银行卡预留手机号码',
    `cnaps_code`                   varchar(40)    DEFAULT NULL COMMENT '人民银行联行号',
    `branch_name`                  varchar(40)    DEFAULT NULL COMMENT '分支行名称',
    `province`                     varchar(40)    DEFAULT NULL COMMENT '省份',
    `city`                         varchar(40)    DEFAULT NULL COMMENT '城市',
    `district`                     varchar(40)    DEFAULT NULL COMMENT '区/县',
    `valid_date`                   date           DEFAULT NULL COMMENT '统一社会信息证代码发证日',
    `cv_n2`                        varchar(40)    DEFAULT NULL COMMENT '信用卡背面的末3位数字',
    `transfer_charge_flag`         varchar(40)    DEFAULT NULL COMMENT '转账充值开通标识',
    `notice_url`                   varchar(40)    DEFAULT NULL COMMENT '后台通知地址',
    `verify_way`                   varchar(40)    DEFAULT NULL COMMENT '验证方式：10=短信验证	20=小额打款验证',
    `sms_code`                     varchar(40)    DEFAULT NULL COMMENT '短信验证码',
    `amount`                       decimal(20, 4) DEFAULT NULL COMMENT '打款金额',
    `business_type`                varchar(255)   DEFAULT NULL COMMENT '业务类型',
    `user_type`                    varchar(40)    DEFAULT NULL COMMENT '用户类型： 11=个人 12=企业 13=个体户',
    `image_info`                   varchar(40)    DEFAULT NULL COMMENT '影印件明细',
    `image_type`                   varchar(40)    DEFAULT NULL COMMENT '影印件类别',
    `image_collection_tx_sn`       varchar(40)    DEFAULT NULL COMMENT '影印件采集交易流水号',
    `apply_no`                     varchar(40)    DEFAULT NULL COMMENT '申请流水号',
    `protocol_number`              varchar(40)    DEFAULT NULL COMMENT '协议模板编号',
    `protocol_signer_type`         varchar(40)    DEFAULT NULL COMMENT '协议签署人类型',
    `agent_phone_number`           varchar(40)    DEFAULT NULL COMMENT '经办人手机号',
    `agent_name`                   varchar(40)    DEFAULT NULL COMMENT '经办人姓名',
    `agent_id_number`              varchar(40)    DEFAULT NULL COMMENT '经办人身份证号',
    `immediately_sign`             varchar(40)    DEFAULT NULL COMMENT '立即签约 10-是 20-否',
    `pay_way`                      varchar(40)    DEFAULT NULL COMMENT '支付方式',
    `category`                     varchar(40)    DEFAULT NULL COMMENT '行业类别',
    `service_phone`                varchar(40)    DEFAULT NULL COMMENT '客服电话',
    `platform_name`                varchar(40)    DEFAULT NULL COMMENT '平台名称',
    `pay_type`                     varchar(40)    DEFAULT NULL COMMENT '支付类别',
    `app_id`                       varchar(40)    DEFAULT NULL COMMENT '当使用 jsapi、小程序时此字段必填',
    `auth_path`                    varchar(225)   DEFAULT NULL COMMENT '微信公众号支付',
    `parent_userid`                varchar(40)    DEFAULT NULL COMMENT '归属父级用户 id',
    `account_level`                varchar(40)    DEFAULT NULL COMMENT '账户层级',
    `individual`                   varchar(40)    DEFAULT NULL COMMENT '个人开户选择域',
    `phone_number`                 varchar(40)    DEFAULT NULL COMMENT '开户手机号码',
    `user_name`                    varchar(40)    DEFAULT NULL COMMENT '用户姓名',
    `iss_date`                     date           DEFAULT NULL COMMENT '统一社会信息证代码发证日',
    `expiry_date`                  date           DEFAULT NULL COMMENT '统一社会信息证代码发证日',
    `ind_address`                  varchar(40)    DEFAULT NULL COMMENT '联系地址',
    `ind_email`                    varchar(40)    DEFAULT NULL COMMENT '个人邮箱',
    `occupation`                   varchar(40)    DEFAULT NULL COMMENT '职业',
    `corporation`                  varchar(40)    DEFAULT NULL COMMENT '企业开户选择域',
    `corporation_name`             varchar(40)    DEFAULT NULL COMMENT '企业名称',
    `corporation_short`            varchar(40)    DEFAULT NULL COMMENT '客户简称',
    `category_type`                varchar(40)    DEFAULT NULL COMMENT '分类类别',
    `cor_email`                    varchar(40)    DEFAULT NULL COMMENT '企业邮箱',
    `cor_address`                  varchar(40)    DEFAULT NULL COMMENT '企业地址',
    `industry_belong_type`         varchar(40)    DEFAULT NULL COMMENT '行业代码',
    `industry`                     varchar(40)    DEFAULT NULL COMMENT '通用行业代码',
    `scale`                        varchar(40)    DEFAULT NULL COMMENT '企业规模',
    `basic_acctno`                 varchar(40)    DEFAULT NULL COMMENT '企业银行账户',
    `approval_no`                  varchar(40)    DEFAULT NULL COMMENT '开户许可证核准号',
    `auth_capital`                 decimal(20, 4) DEFAULT NULL COMMENT '注册资本，单位分',
    `business_scope`               varchar(40)    DEFAULT NULL COMMENT '经营范围',
    `cor_type`                     varchar(40)    DEFAULT NULL COMMENT '企业类型',
    `unified_social_credit_code`   varchar(40)    DEFAULT NULL COMMENT '统一社会信息证代码',
    `all_licence_iss_date`         date           DEFAULT NULL COMMENT '统一社会信息证代码发证日',
    `all_licence_expiry_date`      date           DEFAULT NULL COMMENT '统一社会信息证代码有效期',
    `legal_person_name`            varchar(40)    DEFAULT NULL COMMENT '法人姓名',
    `legal_credential_type`        varchar(40)    DEFAULT NULL COMMENT '证件类型：0-身份证',
    `legal_credential_number`      varchar(40)    DEFAULT NULL COMMENT '法人证件号码',
    `legal_person_iss_date`        date           DEFAULT NULL COMMENT '统一社会信息证代码有效期',
    `legal_person_expiry_date`     date           DEFAULT NULL COMMENT '统一社会信息证代码有效期',
    `legal_person_contact_number`  varchar(40)    DEFAULT NULL COMMENT '法人联系电话',
    `legal_person_email`           varchar(40)    DEFAULT NULL COMMENT '法人邮箱',
    `shareholder`                  varchar(40)    DEFAULT NULL COMMENT '控股股东',
    `controller`                   varchar(40)    DEFAULT NULL COMMENT '实际控制人',
    `beneficiary`                  varchar(40)    DEFAULT NULL COMMENT '实际收益人',
    `shareholder_part`             varchar(40)    DEFAULT NULL COMMENT '控股人域',
    `shareholder_name`             varchar(40)    DEFAULT NULL COMMENT '控股股东姓名',
    `sh_credential_type`           varchar(40)    DEFAULT NULL COMMENT '控股股东证件类型',
    `sh_credential_number`         varchar(40)    DEFAULT NULL COMMENT '控股股东证件号码',
    `sh_person_iss_date`           date           DEFAULT NULL COMMENT '统一社会信息证代码发证日',
    `sh_person_expiry_date`        date           DEFAULT NULL COMMENT '统一社会信息证代码发证日',
    `retailer`                     varchar(40)    DEFAULT NULL COMMENT '个体户开户域',
    `manager_name`                 varchar(40)    DEFAULT NULL COMMENT '经营者姓名',
    `manager_credential_type`      varchar(40)    DEFAULT NULL COMMENT '经营者证件类型：0-身份证',
    `manager_credential_number`    varchar(40)    DEFAULT NULL COMMENT '经营者证件号码',
    `manager_iss_date`             date           DEFAULT NULL COMMENT '统一社会信息证代码发证日',
    `manager_expiry_date`          date           DEFAULT NULL COMMENT '统一社会信息证代码发证日',
    `manager_contact_number`       varchar(40)    DEFAULT NULL COMMENT '经营者手机号码',
    `manager_email`                varchar(40)    DEFAULT NULL COMMENT '经营者邮箱',
    `retailer_reg_number`          varchar(40)    DEFAULT NULL COMMENT '个体工商注册号码',
    `retailer_name`                varchar(40)    DEFAULT NULL COMMENT '个体工商字号',
    `retailer_license_iss_date`    date           DEFAULT NULL COMMENT '统一社会信息证代码发证日',
    `retailer_license_expiry_date` date           DEFAULT NULL COMMENT '统一社会信息证代码发证日',
    `retailer_formation`           varchar(40)    DEFAULT NULL COMMENT '组成形式',
    `retailer_address`             varchar(40)    DEFAULT NULL COMMENT '经营地址',
    `retailer_province`            varchar(40)    DEFAULT NULL COMMENT '省份',
    `retailer_city`                varchar(40)    DEFAULT NULL COMMENT '城市',
    `retailer_district`            varchar(40)    DEFAULT NULL COMMENT '区/县',
    `retailer_business_scope`      varchar(40)    DEFAULT NULL COMMENT '经营范围',
    `manager_credential_address`   varchar(40)    DEFAULT NULL COMMENT '经营者身份证地址',
    `manager_occupation`           varchar(40)    DEFAULT NULL COMMENT '经营者职业',
    `bank_account`                 varchar(40)    DEFAULT NULL COMMENT '绑定银行账户域',
    `bank_province`                varchar(40)    DEFAULT NULL COMMENT '省份',
    `bank_city`                    varchar(40)    DEFAULT NULL COMMENT '城市',
    `tenant_id`                    bigint(20)     DEFAULT NULL COMMENT '租户ID',
    `remark`                       varchar(255)   DEFAULT NULL COMMENT '备注',
    `create_user_id`               bigint(20)     DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                      varchar(255)   DEFAULT NULL COMMENT '记录创建者',
    `create_time`                  datetime(6)    DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`               bigint(20)     DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                      varchar(255)   DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`                  datetime(6)    DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`                  int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version`           int(11)        DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`                    bigint(20)     DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`                  bigint(20)     DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`                    bigint(20)     DEFAULT NULL COMMENT 'sec_ou_id',
    `src_doc_id`                   bigint(20)     DEFAULT NULL COMMENT '来源单据ID',
    `src_doc_no`                   varchar(40)    DEFAULT NULL COMMENT '来源单据编号',
    `current_page`                 varchar(40)    DEFAULT NULL COMMENT '当前页数',
    `image_status`                 varchar(40)    DEFAULT NULL COMMENT '影印件审核状态',
    `auth_info`                    varchar(40)    DEFAULT NULL COMMENT '影印件-10',
    `image_message`                varchar(200)   DEFAULT NULL COMMENT '影印件审核结果通知消息',
    `image_content`                varchar(40)    DEFAULT NULL COMMENT '影印件-10',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '中金支付请求实体类';

-- ----------------------------
-- Table structure for cpcnt_response
-- ----------------------------
CREATE TABLE IF NOT EXISTS `cpcnt_response`
(
    `id`                     bigint(20) NOT NULL COMMENT '记录唯一ID',
    `code`                   varchar(128) DEFAULT NULL COMMENT '响应码',
    `message`                varchar(128) DEFAULT NULL COMMENT '响应消息',
    `status`                 varchar(128) DEFAULT NULL COMMENT '状态',
    `transfer_charge_status` varchar(40)  DEFAULT NULL COMMENT '线下转账充值开通状态',
    `dead_line`              varchar(40)  DEFAULT NULL COMMENT '打款截止日期',
    `response_code`          varchar(40)  DEFAULT NULL COMMENT '响应码',
    `response_message`       varchar(40)  DEFAULT NULL COMMENT '响应消息',
    `bank_redirct_form`      varchar(40)  DEFAULT NULL COMMENT '一键绑卡行方跳转地址',
    `available_veri_count`   varchar(40)  DEFAULT NULL COMMENT '剩余可验证次数',
    `tx_sn`                  varchar(40)  DEFAULT NULL COMMENT '交易流水号，同请求',
    `institution_id`         varchar(40)  DEFAULT NULL COMMENT '机构编号',
    `user_id`                varchar(40)  DEFAULT NULL COMMENT '用户 id',
    `dbank`                  varchar(40)  DEFAULT NULL COMMENT '银行存管',
    `eaccount_name`          varchar(40)  DEFAULT NULL COMMENT '电子账户名称',
    `eaccount_number`        varchar(40)  DEFAULT NULL COMMENT '电子账户号码',
    `binding_status`         varchar(40)  DEFAULT NULL COMMENT '绑卡状态',
    `apply_no`               varchar(40)  DEFAULT NULL COMMENT '申请流水号',
    `response_time`          varchar(40)  DEFAULT NULL COMMENT '响应时间',
    `tenant_id`              bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`                 varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`         bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`            datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`         bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`            datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`            int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version`     int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`              bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`            bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`              bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '中金支付响应实体类';

-- ----------------------------
-- Table structure for itm_brand
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_brand`
(
    `id`                          bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`                   bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`                 bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`                   bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `brand_code`                  varchar(40)  DEFAULT NULL COMMENT '品牌编码',
    `brand_name`                  varchar(40)  DEFAULT NULL COMMENT '品牌名称',
    `brand_en_name`               varchar(40)  DEFAULT NULL COMMENT '品牌英文名',
    `brand_initial`               varchar(40)  DEFAULT NULL COMMENT '品牌首字母',
    `brand_agent`                 varchar(40)  DEFAULT NULL COMMENT '品牌代理商',
    `file_code`                   varchar(255) DEFAULT NULL COMMENT '品牌Logo文件编号',
    `original_name`               varchar(255) DEFAULT NULL COMMENT '品牌Logo文件名称',
    `brand_party`                 varchar(40)  DEFAULT NULL COMMENT '品牌方',
    `brand_authorized`            int(11)      DEFAULT NULL COMMENT '品牌授权（0：否，1：是）',
    `brand_authorized_start_time` datetime(6)  DEFAULT NULL COMMENT '品牌授权开始时间',
    `brand_authorized_end_time`   datetime(6)  DEFAULT NULL COMMENT '品牌授权结束时间',
    `status`                      varchar(40)  DEFAULT NULL COMMENT '品牌名称',
    `tenant_id`                   bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`                      varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`              bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                     varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`                 datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`              bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                     varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`                 datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`                 int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version`          int(11)      DEFAULT NULL COMMENT '锁版本',
    `url`                         varchar(256) DEFAULT NULL COMMENT '图片url',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `ux_brand_code` (`brand_code`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '品牌';

-- ----------------------------
-- Table structure for itm_cate_contr_para
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_cate_contr_para`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `item_cate_code`     varchar(32)  DEFAULT NULL COMMENT '品类编码',
    `param_code`         varchar(32)  DEFAULT NULL COMMENT '管控参数编号',
    `param_name`         varchar(32)  DEFAULT NULL COMMENT '管控参数名称',
    `param_value`        varchar(32)  DEFAULT NULL COMMENT '参数值',
    `sort_no`            int(11)      DEFAULT NULL COMMENT '排序',
    `status`             varchar(8)   DEFAULT NULL COMMENT '状态',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `price_group`        varchar(40)  DEFAULT NULL COMMENT '产品段值码',
    `price_group2`       varchar(40)  DEFAULT NULL COMMENT ' 财务商品分类码',
    `price_group3`       varchar(40)  DEFAULT NULL COMMENT '费用类码',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '品类管控参数';

-- ----------------------------
-- Table structure for itm_cate_prop
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_cate_prop`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `item_cate_code`     varchar(40)  DEFAULT NULL COMMENT '品类编码',
    `cate_prop_code`     varchar(40)  DEFAULT NULL COMMENT '属性名编码',
    `cate_prop_name`     varchar(40)  DEFAULT NULL COMMENT '属性名名称',
    `cate_prop_type`     varchar(40)  DEFAULT NULL COMMENT '属性类型',
    `is_box`             int(11)      DEFAULT NULL COMMENT '单选复选(0:单选,1:复选)',
    `is_hand`            int(11)      DEFAULT NULL COMMENT '录入方式(0:列表选择,1:手动输入)',
    `is_must`            int(11)      DEFAULT NULL COMMENT '是否必填(0:否,1:是)',
    `is_sku`             int(11)      DEFAULT NULL COMMENT '是否和SKU相关(0:否,1:是)',
    `sort_no`            int(11)      DEFAULT NULL COMMENT '排序号',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '品类属性key表';

-- ----------------------------
-- Table structure for itm_cate_prop_value
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_cate_prop_value`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `cate_prop_id`       bigint(20)   DEFAULT NULL COMMENT '属性名ID',
    `prop_value_code`    varchar(32)  DEFAULT NULL COMMENT '属性值编码',
    `prop_value_name`    varchar(32)  DEFAULT NULL COMMENT '属性值名称',
    `prop_value_rank`    int(11)      DEFAULT NULL COMMENT '属性值排序',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '品类属性value表';

-- ----------------------------
-- Table structure for itm_combo_d
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_combo_d`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)     DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)     DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)     DEFAULT NULL COMMENT 'sec_ou_id',
    `item_combo_code`    varchar(32)    DEFAULT NULL COMMENT '组合商品编码',
    `item_code`          varchar(32)    DEFAULT NULL COMMENT '商品编码',
    `status`             varchar(8)     DEFAULT NULL COMMENT '状态',
    `qty`                decimal(20, 8) DEFAULT NULL COMMENT '数量',
    `tenant_id`          bigint(20)     DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)   DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)     DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)   DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)    DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)     DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)   DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)    DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)        DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '组合商品明细';

-- ----------------------------
-- Table structure for itm_combo_tag
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_combo_tag`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `item_combo_code`    varchar(32)  DEFAULT NULL COMMENT '组合商品编码',
    `tag_cate_code`      varchar(32)  DEFAULT NULL COMMENT '标签分类编码',
    `tag_code`           varchar(32)  DEFAULT NULL COMMENT '标签编码',
    `status`             varchar(8)   DEFAULT NULL COMMENT '状态',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '组合商品标签';

-- ----------------------------
-- Table structure for itm_item
-- ----------------------------
CREATE TABLE `itm_item` (
                            `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
                            `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
                            `ou_code` varchar(40) DEFAULT NULL COMMENT '公司编号',
                            `ou_name` varchar(40) DEFAULT NULL COMMENT '公司名称',
                            `bu_id` bigint(20) DEFAULT NULL COMMENT 'BU ID',
                            `bu_code` varchar(40) DEFAULT NULL COMMENT 'BU编号',
                            `bu_name` varchar(40) DEFAULT NULL COMMENT 'BU名称',
                            `item_code` varchar(40) DEFAULT NULL COMMENT '商品编号',
                            `item_code2` varchar(40) DEFAULT NULL COMMENT '商品编号2',
                            `item_code3` varchar(40) DEFAULT NULL COMMENT '商品编号3',
                            `item_name` varchar(255) DEFAULT NULL COMMENT '商品名称',
                            `item_name2` varchar(255) DEFAULT NULL COMMENT '商品名称2',
                            `item_name3` varchar(255) DEFAULT NULL COMMENT '商品名称3',
                            `item_abbr` varchar(40) DEFAULT NULL COMMENT '商品简称',
                            `item_type` varchar(40) DEFAULT NULL COMMENT '商品类型 [UDC]ITM:ITEM_TYPE',
                            `item_type2` varchar(40) DEFAULT NULL COMMENT '商品类型2 [UDC]ITM:ITEM_TYPE2',
                            `item_type3` varchar(40) DEFAULT NULL COMMENT '商品类型3',
                            `item_type4` varchar(40) DEFAULT NULL COMMENT '商品类型4',
                            `item_type5` varchar(40) DEFAULT NULL COMMENT '商品类型5',
                            `item_status` varchar(40) DEFAULT NULL COMMENT '商品状态 [UDC]ITM:ITEM_STATUS',
                            `item_status2` varchar(40) DEFAULT NULL COMMENT '商品状态2',
                            `item_status3` varchar(40) DEFAULT NULL COMMENT '商品状态3',
                            `spec` varchar(255) DEFAULT NULL COMMENT '规格，比如：食品净含量',
                            `spu_id` bigint(20) DEFAULT NULL COMMENT 'spu_id',
                            `spu_code` varchar(40) DEFAULT NULL COMMENT 'SPU_CODE',
                            `spu_code2` varchar(40) DEFAULT NULL COMMENT 'SPU_CODE2',
                            `spu_code3` varchar(40) DEFAULT NULL COMMENT 'SPU_CODE3',
                            `spu_name` varchar(255) DEFAULT NULL COMMENT 'SPU_NAME',
                            `spu_name2` varchar(255) DEFAULT NULL COMMENT 'SPU_NAME2',
                            `spu_name3` varchar(255) DEFAULT NULL COMMENT 'SPU_NAME3',
                            `spu_abbr` varchar(40) DEFAULT NULL COMMENT 'SPU简称',
                            `item_attr` varchar(255) DEFAULT NULL COMMENT '商品规格',
                            `item_attr2` varchar(40) DEFAULT NULL COMMENT '商品规格2',
                            `item_attr3` varchar(40) DEFAULT NULL COMMENT '商品规格3',
                            `item_attr4` varchar(40) DEFAULT NULL COMMENT '商品规格4',
                            `item_attr5` varchar(40) DEFAULT NULL COMMENT '商品规格5',
                            `item_cate_code` varchar(40) DEFAULT NULL COMMENT '商品品类编号',
                            `item_cate_code2` varchar(40) DEFAULT NULL COMMENT '商品品类编号2',
                            `item_cate_code3` varchar(40) DEFAULT NULL COMMENT '商品品类编号3',
                            `item_source` varchar(40) DEFAULT NULL COMMENT '商品识别号',
                            `brand` varchar(40) DEFAULT NULL COMMENT '品牌',
                            `brand2` varchar(40) DEFAULT NULL COMMENT '品牌2',
                            `release_flag` int(11) DEFAULT NULL COMMENT '是否发布',
                            `salepurc_flag` int(11) DEFAULT NULL COMMENT '是否允许自采',
                            `sn_flag` int(11) DEFAULT NULL COMMENT '是否启用序列号',
                            `lot_flag` int(11) DEFAULT NULL COMMENT '是否启用批次号',
                            `guarantee_flag` int(11) DEFAULT NULL COMMENT '效期管理标识',
                            `memberdisc_flagx` int(11) DEFAULT NULL COMMENT '是否享会员折扣',
                            `distribution_flagx` int(11) DEFAULT NULL COMMENT '是否分销',
                            `fin_type` varchar(40) DEFAULT NULL COMMENT '财务分类 [UDC]ITM:FIN_TYPE',
                            `cost_type` varchar(40) DEFAULT NULL COMMENT '成本计价方法 [UDC]ITM:COST_TYPE',
                            `alloc_type` varchar(40) DEFAULT NULL COMMENT '配货类型 [UDC]ITM:ALLOC_TYPE',
                            `deliver_type` varchar(40) DEFAULT NULL COMMENT '配送类型 [UDC]ITM:DELIVER_TYPE',
                            `aftersales_service_flagx` int(11) DEFAULT NULL COMMENT '是否需要售后服务',
                            `install_flag` int(11) DEFAULT NULL COMMENT '是否需要安装',
                            `return_exchange_flag` int(11) DEFAULT NULL COMMENT '是否可退换货',
                            `return_exchange_policy` varchar(40) DEFAULT NULL COMMENT '退换货政策 [UDC]ITM:RETURN_EXCHANGE_POLICY',
                            `warranty_flag` int(11) DEFAULT NULL COMMENT '是否保修',
                            `warranty_period` int(11) DEFAULT NULL COMMENT '保修期时长',
                            `warranty_period_unit` varchar(40) DEFAULT NULL COMMENT '保修期单位 [UDC]COM:TIME_UNIT',
                            `trans_condition` varchar(40) DEFAULT NULL COMMENT '运输条件',
                            `store_condition` varchar(40) DEFAULT NULL COMMENT '存储条件',
                            `package_spec` varchar(40) DEFAULT NULL COMMENT '包装规格',
                            `guarantee_period` int(11) DEFAULT NULL COMMENT '保质期时长',
                            `guarantee_period_unit` varchar(40) DEFAULT NULL COMMENT '保质期单位 [UDC]COM:TIME_UNIT',
                            `guarantee_days` int(11) DEFAULT NULL COMMENT '保质期天数',
                            `tax_type` varchar(40) DEFAULT NULL COMMENT '税收分类码',
                            `tax_code` varchar(40) DEFAULT NULL COMMENT '税码(进项)',
                            `tax_rate` decimal(20,8) DEFAULT NULL COMMENT '税率(进项)',
                            `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号(进项)',
                            `tax_code2` varchar(40) DEFAULT NULL COMMENT '税码2(销项)',
                            `tax_rate2` decimal(20,8) DEFAULT NULL COMMENT '税率2(销项)',
                            `tax_rate_no2` varchar(40) DEFAULT NULL COMMENT '税率编号2(销项)',
                            `tax_rate_tariff` decimal(20,8) DEFAULT NULL COMMENT '关税税率',
                            `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
                            `supp_code` varchar(40) DEFAULT NULL COMMENT '供应商编号',
                            `supp_abbr` varchar(40) DEFAULT NULL COMMENT '供应商简称',
                            `supp_name` varchar(40) DEFAULT NULL COMMENT '供应商名称',
                            `supp_item_code` varchar(40) DEFAULT NULL COMMENT '供应商物料编码',
                            `bar_code` varchar(40) DEFAULT NULL COMMENT '条码',
                            `bar_code2` varchar(40) DEFAULT NULL COMMENT '条码',
                            `uom` varchar(40) DEFAULT NULL COMMENT '主计量单位 [UDC]COM:UOM',
                            `uom2` varchar(40) DEFAULT NULL COMMENT '主计量单位2 [UDC]COM:UOM',
                            `uom3` varchar(40) DEFAULT NULL COMMENT '主计量单位3 [UDC]COM:UOM',
                            `uom4` varchar(40) DEFAULT NULL COMMENT '主计量单位4 [UDC]COM:UOM',
                            `uom5` varchar(40) DEFAULT NULL COMMENT '主计量单位5 [UDC]COM:UOM',
                            `sale_uom` varchar(40) DEFAULT NULL COMMENT '默认销售单位 [UDC]COM:UOM',
                            `purc_uom` varchar(40) DEFAULT NULL COMMENT '默认采购单位 [UDC]COM:UOM',
                            `ship_uom` varchar(40) DEFAULT NULL COMMENT '发运计量单位 [UDC]COM:UOM',
                            `order_uom` varchar(40) DEFAULT NULL COMMENT '要货计量单位 [UDC]COM:UOM',
                            `pricing_uom` varchar(40) DEFAULT NULL COMMENT '定价计量单位 [UDC]COM:UOM',
                            `store_uom` varchar(40) DEFAULT NULL COMMENT '库存计量单位 [UDC]COM:UOM',
                            `gross_weight` decimal(20,8) DEFAULT NULL COMMENT '毛重',
                            `net_weight` decimal(20,8) DEFAULT NULL COMMENT '净重',
                            `weight_unit` varchar(40) DEFAULT NULL COMMENT '重量单位 [UDC]COM:WEIGHT_UNIT',
                            `weight_item_uom` varchar(40) DEFAULT NULL COMMENT '重量对应的品项单位 [UDC]COM:UOM',
                            `volume` decimal(20,8) DEFAULT NULL COMMENT '体积',
                            `volume_unit` varchar(40) DEFAULT NULL COMMENT '体积单位 [UDC]COM:VOLUME_UNIT',
                            `length` decimal(20,8) DEFAULT NULL COMMENT '长',
                            `width` decimal(20,8) DEFAULT NULL COMMENT '宽',
                            `height` decimal(20,8) DEFAULT NULL COMMENT '高',
                            `length_unit` varchar(40) DEFAULT NULL COMMENT '长度单位 [UDC]COM:LENGTH_UNIT',
                            `moq` decimal(20,8) DEFAULT NULL COMMENT '最小起定量',
                            `safe_qty` decimal(20,8) DEFAULT NULL COMMENT '安全库存',
                            `max_order_qty` decimal(20,8) DEFAULT NULL COMMENT '最大要货量',
                            `tags` varchar(255) DEFAULT NULL COMMENT '标签',
                            `outer_code` varchar(40) DEFAULT NULL COMMENT '外部编号',
                            `outer_code2` varchar(40) DEFAULT NULL COMMENT '外部编号2',
                            `cat` varchar(40) DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT2',
                            `cat2` varchar(40) DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT2',
                            `cat3` varchar(40) DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT3',
                            `cat4` varchar(40) DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT4',
                            `cat5` varchar(40) DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT5',
                            `cat6` varchar(40) DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT6',
                            `cat7` varchar(40) DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT7',
                            `cat8` varchar(40) DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT8',
                            `cat9` varchar(40) DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT9',
                            `cat10` varchar(40) DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT10',
                            `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
                            `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
                            `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
                            `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
                            `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
                            `es6` varchar(40) DEFAULT NULL COMMENT 'ES6',
                            `es7` varchar(40) DEFAULT NULL COMMENT 'ES7',
                            `es8` varchar(40) DEFAULT NULL COMMENT 'ES8',
                            `es9` varchar(40) DEFAULT NULL COMMENT 'ES9',
                            `es10` varchar(40) DEFAULT NULL COMMENT 'ES10',
                            `en1` decimal(20,8) DEFAULT NULL COMMENT 'EN1',
                            `en2` decimal(20,8) DEFAULT NULL COMMENT 'EN2',
                            `en3` decimal(20,8) DEFAULT NULL COMMENT 'EN3',
                            `en4` decimal(20,8) DEFAULT NULL COMMENT 'EN4',
                            `en5` decimal(20,8) DEFAULT NULL COMMENT 'EN5',
                            `ed1` datetime(6) DEFAULT NULL COMMENT 'ED1',
                            `ed2` datetime(6) DEFAULT NULL COMMENT 'ED2',
                            `ed3` datetime(6) DEFAULT NULL COMMENT 'ED3',
                            `standard` varchar(255) DEFAULT NULL COMMENT '标准',
                            `standard_desc` varchar(255) DEFAULT NULL COMMENT '标准描述',
                            `standard_sort` int(11) DEFAULT NULL COMMENT '标准排序',
                            `material` varchar(255) DEFAULT NULL COMMENT '材质',
                            `material_desc` varchar(255) DEFAULT NULL COMMENT '材质描述',
                            `material_sort` int(11) DEFAULT NULL COMMENT '材质排序',
                            `diameter` varchar(255) DEFAULT NULL COMMENT '直径',
                            `diameter_desc` varchar(255) DEFAULT NULL COMMENT '直径描述',
                            `diameter_sort` int(11) DEFAULT NULL COMMENT '直径排序',
                            `lengths` varchar(255) DEFAULT NULL COMMENT '长度',
                            `lengths_desc` varchar(255) DEFAULT NULL COMMENT '长度描述',
                            `lengths_sort` int(11) DEFAULT NULL COMMENT '长度排序',
                            `tooth` varchar(255) DEFAULT NULL COMMENT '牙别',
                            `tooth_desc` varchar(255) DEFAULT NULL COMMENT '牙别描述',
                            `tooth_sort` int(11) DEFAULT NULL COMMENT '牙别排序',
                            `surface` varchar(255) DEFAULT NULL COMMENT '表面处理',
                            `surface_desc` varchar(255) DEFAULT NULL COMMENT '表面处理描述',
                            `surface_sort` int(11) DEFAULT NULL COMMENT '表面处理排序',
                            `strength` varchar(255) DEFAULT NULL COMMENT '强度',
                            `strength_desc` varchar(255) DEFAULT NULL COMMENT '强度描述',
                            `strength_sort` int(11) DEFAULT NULL COMMENT '强度排序',
                            `source` varchar(255) DEFAULT NULL COMMENT '来源',
                            `spec2` varchar(255) DEFAULT NULL COMMENT '规格，比如：食品净含量',
                            `item_desc` varchar(2000) DEFAULT NULL COMMENT '品项描述 文描，可含有格式，包含导航段落信息',
                            `sub_title` varchar(200) DEFAULT NULL COMMENT '副标题 如京东有',
                            `pinyin` varchar(200) DEFAULT NULL COMMENT '拼音',
                            `package_qty` decimal(20,4) DEFAULT NULL COMMENT '整包装数量',
                            `batch_qty` decimal(20,4) DEFAULT NULL COMMENT '批量',
                            `stamp` varchar(40) DEFAULT NULL COMMENT '印记',
                            `purchaser_name` varchar(40) DEFAULT NULL COMMENT '采购员姓名',
                            `fin_gl_type` varchar(10) DEFAULT NULL COMMENT '财务总账类别 [UDC]ITM:FIN_GL_TYPE',
                            `shipment_type` varchar(40) DEFAULT NULL COMMENT '发运类型',
                            `plan_type` varchar(40) DEFAULT NULL COMMENT '计划类型',
                            `mem_code` varchar(40) DEFAULT NULL COMMENT '助记码',
                            `pinyin_sh` varchar(100) DEFAULT NULL COMMENT '拼音简称',
                            `other_type1` varchar(40) DEFAULT NULL COMMENT '其它类型1',
                            `other_type2` varchar(40) DEFAULT NULL COMMENT '其它类型2',
                            `intf_status` varchar(40) DEFAULT NULL COMMENT '接口状态',
                            `draw_no` varchar(40) DEFAULT NULL COMMENT '接口状态',
                            `intf_time` datetime DEFAULT NULL COMMENT '接口处理时间',
                            `min_qty` double DEFAULT NULL,
                            `price` double DEFAULT NULL,
                            `price_period` varchar(40) DEFAULT NULL,
                            `usage_desc` varchar(40) DEFAULT NULL,
                            `item_code4` varchar(40) DEFAULT NULL,
                            `wh_code` varchar(40) DEFAULT NULL,
                            `proc_inst_id` varchar(255) DEFAULT NULL COMMENT '流程实例ID',
                            `proc_inst_status` varchar(255) DEFAULT NULL COMMENT '流程实例状态',
                            `submit_time` datetime(6) DEFAULT NULL COMMENT '提交时间',
                            `approved_time` datetime(6) DEFAULT NULL COMMENT '审批通过时间',
                            `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
                            `remark` varchar(1000) DEFAULT NULL COMMENT '备注',
                            `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
                            `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
                            `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
                            `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
                            `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
                            `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
                            `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
                            `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
                            `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
                            `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
                            `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
                            `rebate_type` varchar(40) DEFAULT NULL COMMENT '供应商回扣类型',
                            PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='商品';

-- ----------------------------
-- Table structure for itm_item_apply
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_apply`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `ou_id`              bigint(20)   DEFAULT NULL COMMENT 'OU公司ID',
    `bu_id`              bigint(20)   DEFAULT NULL COMMENT 'BU组织ID',
    `doc_no`             varchar(32)  DEFAULT NULL COMMENT '单据编号',
    `doc_type`           varchar(32)  DEFAULT NULL COMMENT '单据类型',
    `doc_type2`          varchar(32)  DEFAULT NULL COMMENT '单据类型2',
    `doc_type3`          varchar(32)  DEFAULT NULL COMMENT '单据类型3',
    `doc_status`         varchar(32)  DEFAULT NULL COMMENT '单据状态',
    `apply_emp_id`       bigint(20)   DEFAULT NULL COMMENT '申请人员工ID',
    `apply_date`         datetime     DEFAULT NULL COMMENT '申请日期',
    `apply_desc`         varchar(128) DEFAULT NULL COMMENT '申请描述',
    `appr_status`        varchar(32)  DEFAULT NULL COMMENT '审批状态',
    `appr_time`          datetime     DEFAULT NULL COMMENT '审批时间',
    `apply_user_id`      bigint(20)   DEFAULT NULL COMMENT '审批人ID',
    `apply_comment`      varchar(128) DEFAULT NULL COMMENT '审批意见',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `proc_inst_id`       varchar(255) DEFAULT NULL COMMENT '流程实例ID',
    `proc_inst_status`   varchar(255) DEFAULT NULL COMMENT '流程实例状态',
    `submit_time`        datetime(6)  DEFAULT NULL COMMENT '提交时间',
    `approved_time`      datetime(6)  DEFAULT NULL COMMENT '审批通过时间',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '商品审核单据表';

-- ----------------------------
-- Table structure for itm_item_applyd
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_applyd`
(
    `id`                       bigint(20) NOT NULL COMMENT '记录唯一ID',
    `ou_id`                    bigint(20)     DEFAULT NULL COMMENT '公司ID',
    `doc_no`                   varchar(32)    DEFAULT NULL COMMENT '单据编号',
    `ou_code`                  varchar(40)    DEFAULT NULL COMMENT '公司编号',
    `ou_name`                  varchar(40)    DEFAULT NULL COMMENT '公司名称',
    `bu_id`                    bigint(20)     DEFAULT NULL COMMENT 'BU ID',
    `bu_code`                  varchar(40)    DEFAULT NULL COMMENT 'BU编号（采购组织编码）',
    `bu_name`                  varchar(40)    DEFAULT NULL COMMENT 'BU名称',
    `item_code`                varchar(40)    DEFAULT NULL COMMENT '商品编号',
    `item_code2`               varchar(40)    DEFAULT NULL COMMENT '商品编号2',
    `item_code3`               varchar(40)    DEFAULT NULL COMMENT '商品编号3',
    `item_name`                varchar(255)   DEFAULT NULL COMMENT '商品名称',
    `item_name2`               varchar(255)   DEFAULT NULL COMMENT '商品名称2',
    `item_name3`               varchar(255)   DEFAULT NULL COMMENT '商品名称3',
    `item_abbr`                varchar(40)    DEFAULT NULL COMMENT '商品简称',
    `item_type`                varchar(40)    DEFAULT NULL COMMENT '商品类型 [UDC]ITM:ITEM_TYPE',
    `item_type2`               varchar(40)    DEFAULT NULL COMMENT '商品类型2 [UDC]ITM:ITEM_TYPE2',
    `item_type3`               varchar(40)    DEFAULT NULL COMMENT '商品类型3',
    `item_type4`               varchar(40)    DEFAULT NULL COMMENT '商品类型4',
    `item_type5`               varchar(40)    DEFAULT NULL COMMENT '商品类型5',
    `item_status`              varchar(40)    DEFAULT NULL COMMENT '商品状态 [UDC]ITM:ITEM_STATUS',
    `item_status2`             varchar(40)    DEFAULT NULL COMMENT '商品状态2',
    `item_status3`             varchar(40)    DEFAULT NULL COMMENT '商品状态3',
    `spec`                     varchar(255)   DEFAULT NULL COMMENT '规格，比如：食品净含量',
    `spu_id`                   bigint(20) NOT NULL COMMENT 'SPU_ID',
    `spu_code`                 varchar(40)    DEFAULT NULL COMMENT 'SPU_CODE',
    `spu_code2`                varchar(40)    DEFAULT NULL COMMENT 'SPU_CODE2',
    `spu_code3`                varchar(40)    DEFAULT NULL COMMENT 'SPU_CODE3',
    `spu_name`                 varchar(255)   DEFAULT NULL COMMENT 'SPU_NAME',
    `spu_name2`                varchar(255)   DEFAULT NULL COMMENT 'SPU_NAME2',
    `spu_name3`                varchar(255)   DEFAULT NULL COMMENT 'SPU_NAME3',
    `spu_abbr`                 varchar(40)    DEFAULT NULL COMMENT 'SPU简称',
    `item_attr`                varchar(255)   DEFAULT NULL COMMENT '商品规格',
    `item_attr2`               varchar(40)    DEFAULT NULL COMMENT '商品规格2',
    `item_attr3`               varchar(40)    DEFAULT NULL COMMENT '商品规格3',
    `item_attr4`               varchar(40)    DEFAULT NULL COMMENT '商品规格4',
    `item_attr5`               varchar(40)    DEFAULT NULL COMMENT '商品规格5',
    `item_cate_code`           varchar(40)    DEFAULT NULL COMMENT '商品品类编号',
    `item_cate_code2`          varchar(40)    DEFAULT NULL COMMENT '商品品类编号2',
    `item_cate_code3`          varchar(40)    DEFAULT NULL COMMENT '商品品类编号3',
    `item_source`              varchar(40)    DEFAULT NULL COMMENT '商品识别号',
    `brand`                    varchar(40)    DEFAULT NULL COMMENT '品牌',
    `brand2`                   varchar(40)    DEFAULT NULL COMMENT '品牌2',
    `salepurc_flag`            int(11)        DEFAULT NULL COMMENT '是否允许自采',
    `sn_flag`                  int(11)        DEFAULT NULL COMMENT '是否启用序列号',
    `lot_flag`                 int(11)        DEFAULT NULL COMMENT '是否启用批次号',
    `guarantee_flag`           int(11)        DEFAULT NULL COMMENT '效期管理标识',
    `memberdisc_flagx`         int(11)        DEFAULT NULL COMMENT '是否享会员折扣',
    `distribution_flagx`       int(11)        DEFAULT NULL COMMENT '是否分销',
    `fin_type`                 varchar(40)    DEFAULT NULL COMMENT '财务分类 [UDC]ITM:FIN_TYPE',
    `cost_type`                varchar(40)    DEFAULT NULL COMMENT '成本计价方法 [UDC]ITM:COST_TYPE',
    `alloc_type`               varchar(40)    DEFAULT NULL COMMENT '配货类型 [UDC]ITM:ALLOC_TYPE',
    `deliver_type`             varchar(40)    DEFAULT NULL COMMENT '配送类型 [UDC]ITM:DELIVER_TYPE',
    `install_flag`             int(11)        DEFAULT NULL COMMENT '是否需要安装',
    `return_exchange_flag`     int(11)        DEFAULT NULL COMMENT '是否可退换货',
    `return_exchange_policy`   varchar(40)    DEFAULT NULL COMMENT '退换货政策 [UDC]ITM:RETURN_EXCHANGE_POLICY',
    `warranty_flag`            int(11)        DEFAULT NULL COMMENT '是否保修',
    `warranty_period`          int(11)        DEFAULT NULL COMMENT '保修期时长',
    `warranty_period_unit`     varchar(40)    DEFAULT NULL COMMENT '保修期单位 [UDC]COM:TIME_UNIT',
    `trans_condition`          varchar(40)    DEFAULT NULL COMMENT '运输条件',
    `store_condition`          varchar(40)    DEFAULT NULL COMMENT '存储条件',
    `package_spec`             varchar(40)    DEFAULT NULL COMMENT '包装规格',
    `guarantee_period`         int(11)        DEFAULT NULL COMMENT '保质期时长',
    `guarantee_period_unit`    varchar(40)    DEFAULT NULL COMMENT '保质期单位 [UDC]COM:TIME_UNIT',
    `guarantee_days`           int(11)        DEFAULT NULL COMMENT '保质期天数',
    `tax_type`                 varchar(40)    DEFAULT NULL COMMENT '税收分类码',
    `tax_code`                 varchar(40)    DEFAULT NULL COMMENT '税码(进项)',
    `tax_rate`                 decimal(20, 8) DEFAULT NULL COMMENT '税率(进项)',
    `tax_rate_no`              varchar(40)    DEFAULT NULL COMMENT '税率编号(进项)',
    `tax_code2`                varchar(40)    DEFAULT NULL COMMENT '税码2(销项)',
    `tax_rate2`                decimal(20, 8) DEFAULT NULL COMMENT '税率2(销项)',
    `tax_rate_no2`             varchar(40)    DEFAULT NULL COMMENT '税率编号2(销项)',
    `tax_rate_tariff`          decimal(20, 8) DEFAULT NULL COMMENT '关税税率',
    `supp_id`                  bigint(20)     DEFAULT NULL COMMENT '供应商ID',
    `supp_code`                varchar(40)    DEFAULT NULL COMMENT '供应商编号',
    `supp_abbr`                varchar(40)    DEFAULT NULL COMMENT '供应商简称',
    `supp_name`                varchar(40)    DEFAULT NULL COMMENT '供应商名称',
    `supp_item_code`           varchar(40)    DEFAULT NULL COMMENT '供应商物料编码',
    `bar_code`                 varchar(40)    DEFAULT NULL COMMENT '条码',
    `bar_code2`                varchar(40)    DEFAULT NULL COMMENT '条码',
    `uom`                      varchar(40)    DEFAULT NULL COMMENT '主计量单位 [UDC]COM:UOM',
    `uom2`                     varchar(40)    DEFAULT NULL COMMENT '主计量单位2 [UDC]COM:UOM',
    `uom3`                     varchar(40)    DEFAULT NULL COMMENT '主计量单位3 [UDC]COM:UOM',
    `uom4`                     varchar(40)    DEFAULT NULL COMMENT '主计量单位4 [UDC]COM:UOM',
    `uom5`                     varchar(40)    DEFAULT NULL COMMENT '主计量单位5 [UDC]COM:UOM',
    `sale_uom`                 varchar(40)    DEFAULT NULL COMMENT '默认销售单位 [UDC]COM:UOM',
    `purc_uom`                 varchar(40)    DEFAULT NULL COMMENT '默认采购单位 [UDC]COM:UOM',
    `ship_uom`                 varchar(40)    DEFAULT NULL COMMENT '发运计量单位 [UDC]COM:UOM',
    `order_uom`                varchar(40)    DEFAULT NULL COMMENT '要货计量单位 [UDC]COM:UOM',
    `pricing_uom`              varchar(40)    DEFAULT NULL COMMENT '定价计量单位 [UDC]COM:UOM',
    `store_uom`                varchar(40)    DEFAULT NULL COMMENT '库存计量单位 [UDC]COM:UOM',
    `gross_weight`             decimal(20, 8) DEFAULT NULL COMMENT '毛重',
    `net_weight`               decimal(20, 8) DEFAULT NULL COMMENT '净重',
    `weight_unit`              varchar(40)    DEFAULT NULL COMMENT '重量单位 [UDC]COM:WEIGHT_UNIT',
    `weight_item_uom`          varchar(40)    DEFAULT NULL COMMENT '重量对应的品项单位 [UDC]COM:UOM',
    `volume`                   decimal(20, 8) DEFAULT NULL COMMENT '体积',
    `volume_unit`              varchar(40)    DEFAULT NULL COMMENT '体积单位 [UDC]COM:VOLUME_UNIT',
    `length`                   decimal(20, 8) DEFAULT NULL COMMENT '长',
    `width`                    decimal(20, 8) DEFAULT NULL COMMENT '宽',
    `height`                   decimal(20, 8) DEFAULT NULL COMMENT '高',
    `length_unit`              varchar(40)    DEFAULT NULL COMMENT '长度单位 [UDC]COM:LENGTH_UNIT',
    `moq`                      decimal(20, 8) DEFAULT NULL COMMENT '最小起定量',
    `safe_qty`                 decimal(20, 8) DEFAULT NULL COMMENT '安全库存',
    `max_order_qty`            decimal(20, 8) DEFAULT NULL COMMENT '最大要货量',
    `tags`                     varchar(255)   DEFAULT NULL COMMENT '标签',
    `outer_code`               varchar(40)    DEFAULT NULL COMMENT '外部编号',
    `outer_code2`              varchar(40)    DEFAULT NULL COMMENT '外部编号2',
    `cat`                      varchar(40)    DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT',
    `cat2`                     varchar(40)    DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT2',
    `cat3`                     varchar(40)    DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT3',
    `cat4`                     varchar(40)    DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT4',
    `cat5`                     varchar(40)    DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT5',
    `cat6`                     varchar(40)    DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT6',
    `cat7`                     varchar(40)    DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT7',
    `cat8`                     varchar(40)    DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT8',
    `cat9`                     varchar(40)    DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT9',
    `cat10`                    varchar(40)    DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT10',
    `es1`                      varchar(40)    DEFAULT NULL COMMENT 'ES1',
    `es2`                      varchar(40)    DEFAULT NULL COMMENT 'ES2',
    `es3`                      varchar(40)    DEFAULT NULL COMMENT 'ES3',
    `es4`                      varchar(40)    DEFAULT NULL COMMENT 'ES4',
    `es5`                      varchar(40)    DEFAULT NULL COMMENT 'ES5',
    `es6`                      varchar(40)    DEFAULT NULL COMMENT 'ES6',
    `es7`                      varchar(40)    DEFAULT NULL COMMENT 'ES7',
    `es8`                      varchar(40)    DEFAULT NULL COMMENT 'ES8',
    `es9`                      varchar(40)    DEFAULT NULL COMMENT 'ES9',
    `es10`                     varchar(40)    DEFAULT NULL COMMENT 'ES10',
    `en1`                      decimal(20, 8) DEFAULT NULL COMMENT 'EN1',
    `en2`                      decimal(20, 8) DEFAULT NULL COMMENT 'EN2',
    `en3`                      decimal(20, 8) DEFAULT NULL COMMENT 'EN3',
    `en4`                      decimal(20, 8) DEFAULT NULL COMMENT 'EN4',
    `en5`                      decimal(20, 8) DEFAULT NULL COMMENT 'EN5',
    `ed1`                      datetime(6)    DEFAULT NULL COMMENT 'ED1',
    `ed2`                      datetime(6)    DEFAULT NULL COMMENT 'ED2',
    `ed3`                      datetime(6)    DEFAULT NULL COMMENT 'ED3',
    `tenant_id`                bigint(20)     DEFAULT NULL COMMENT '租户ID',
    `remark`                   varchar(1000)  DEFAULT NULL COMMENT '备注',
    `create_user_id`           bigint(20)     DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                  varchar(255)   DEFAULT NULL COMMENT '记录创建者',
    `create_time`              datetime(6)    DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`           bigint(20)     DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                  varchar(255)   DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`              datetime(6)    DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`              int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version`       int(11)        DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`                bigint(20)     DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`              bigint(20)     DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`                bigint(20)     DEFAULT NULL COMMENT 'sec_ou_id',
    `price1`                   decimal(20, 8) DEFAULT NULL,
    `price2`                   decimal(20, 8) DEFAULT NULL,
    `price3`                   decimal(20, 8) DEFAULT NULL,
    `price4`                   decimal(20, 8) DEFAULT NULL,
    `price5`                   decimal(20, 8) DEFAULT NULL,
    `price8`                   decimal(20, 8) DEFAULT NULL,
    `price9`                   decimal(20, 8) DEFAULT NULL,
    `price10`                  decimal(20, 8) DEFAULT NULL,
    `price11`                  decimal(20, 8) DEFAULT NULL,
    `price12`                  decimal(20, 8) DEFAULT NULL,
    `doc_type`                 varchar(32)    DEFAULT NULL COMMENT '申请类型(单据类型)',
    `aftersales_service_flagx` int(11)        DEFAULT NULL COMMENT '是否需要售后服务',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_spu_id` (`spu_id`) USING BTREE
) COMMENT = '商品履历';

-- ----------------------------
-- Table structure for itm_item_attachment
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_attachment`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `item_id`            bigint(20)   DEFAULT NULL COMMENT '商品ID',
    `file_id`            bigint(20)   DEFAULT NULL COMMENT '文件ID',
    `file_name`          varchar(256) DEFAULT NULL COMMENT '商品文件名称',
    `file_code`          varchar(256) DEFAULT NULL COMMENT '商品文件编号',
    `file_type`          varchar(40)  DEFAULT NULL COMMENT '商品文件类型(图片，附件等)',
    `img_size`           varchar(40)  DEFAULT NULL COMMENT '图片尺寸',
    `file_size`          varchar(40)  DEFAULT NULL COMMENT '文件大小',
    `major`              tinyint(1)   DEFAULT NULL COMMENT '是否主图',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `url`                varchar(256) DEFAULT NULL COMMENT '图片url',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '商品附件';

-- ----------------------------
-- Table structure for itm_item_attachment_applyd
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_attachment_applyd`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `item_id`            bigint(20)   DEFAULT NULL COMMENT '商品ID',
    `file_id`            bigint(20)   DEFAULT NULL COMMENT '文件ID',
    `file_name`          varchar(256) DEFAULT NULL COMMENT '商品文件名称',
    `file_code`          varchar(256) DEFAULT NULL COMMENT '商品文件编号',
    `file_type`          varchar(40)  DEFAULT NULL COMMENT '商品文件类型(图片，附件等)',
    `img_size`           varchar(40)  DEFAULT NULL COMMENT '图片尺寸',
    `file_size`          varchar(40)  DEFAULT NULL COMMENT '文件大小',
    `major`              tinyint(1)   DEFAULT NULL COMMENT '是否主图',
    `url`                varchar(256) DEFAULT NULL COMMENT '图片url',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `doc_no`             varchar(32)  DEFAULT NULL COMMENT '单据编号',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '商品附件-履历';

-- ----------------------------
-- Table structure for itm_item_bom
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_bom`
(
    `id`                       bigint(20) NOT NULL,
    `sec_bu_id`                bigint(20)   DEFAULT NULL,
    `sec_user_id`              bigint(20)   DEFAULT NULL,
    `sec_ou_id`                bigint(20)   DEFAULT NULL,
    `pid`                      bigint(20) NOT NULL,
    `sort_no`                  int(11)      DEFAULT NULL,
    `grade`                    int(11)      DEFAULT NULL,
    `id_path`                  varchar(255) DEFAULT NULL,
    `code_path`                varchar(255) DEFAULT NULL,
    `item_id`                  bigint(20)   DEFAULT NULL COMMENT '商品ID',
    `qty`                      int(11)      DEFAULT NULL COMMENT '数量(主计量单位的数量)',
    `general_accessories_spec` varchar(255) DEFAULT NULL COMMENT '通用配件型号',
    `bom_type`                 varchar(40)  DEFAULT NULL COMMENT '物料类型',
    `bom_type2`                varchar(40)  DEFAULT NULL COMMENT '物料类型2',
    `bom_type3`                varchar(40)  DEFAULT NULL COMMENT '物料类型3',
    `tenant_id`                bigint(20)   DEFAULT NULL,
    `remark`                   varchar(255) DEFAULT NULL,
    `create_user_id`           bigint(20)   DEFAULT NULL,
    `creator`                  varchar(255) DEFAULT NULL,
    `create_time`              datetime(6)  DEFAULT NULL,
    `modify_user_id`           bigint(20)   DEFAULT NULL,
    `updater`                  varchar(255) DEFAULT NULL,
    `modify_time`              datetime(6)  DEFAULT NULL,
    `delete_flag`              int(11)    NOT NULL,
    `audit_data_version`       int(11)      DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '商品(物料)结构清单';

-- ----------------------------
-- Table structure for itm_item_business
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_business`
(
    `id`                     bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`              bigint(20)     DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`            bigint(20)     DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`              bigint(20)     DEFAULT NULL COMMENT 'sec_ou_id',
    `bu_treedid`             bigint(20)     DEFAULT NULL COMMENT '组织树节点ID',
    `item_source`            varchar(40)    DEFAULT NULL COMMENT '商品识别号',
    `bu_code`                varchar(40)    DEFAULT NULL COMMENT '组织编号',
    `spu_id`                 bigint(20)     DEFAULT NULL COMMENT 'spuId',
    `spu_code`               varchar(40)    DEFAULT NULL COMMENT '组织编号',
    `alloc_type`             varchar(40)    DEFAULT NULL COMMENT '配货类型 [UDC]ITM:ALLOC_TYPE',
    `tax_rate_no`            varchar(40)    DEFAULT NULL COMMENT '税率编号(进项)',
    `tax_rate_no2`           varchar(40)    DEFAULT NULL COMMENT '税率编号2(销项)',
    `tax_rate_tariff`        decimal(20, 8) DEFAULT NULL COMMENT '关税税率',
    `install_flag`           int(11)        DEFAULT NULL COMMENT '是否需要安装',
    `return_exchange_flag`   int(11)        DEFAULT NULL COMMENT '是否可退换货',
    `return_exchange_policy` varchar(40)    DEFAULT NULL COMMENT '退换货政策 [UDC]ITM:RETURN_EXCHANGE_POLICY',
    `warranty_flag`          int(11)        DEFAULT NULL COMMENT '是否保修',
    `warranty_period`        int(11)        DEFAULT NULL COMMENT '保修期时长',
    `warranty_period_unit`   varchar(40)    DEFAULT NULL COMMENT '保修期单位 [UDC]COM:TIME_UNIT',
    `tenant_id`              bigint(20)     DEFAULT NULL COMMENT '租户ID',
    `remark`                 varchar(255)   DEFAULT NULL COMMENT '备注',
    `create_user_id`         bigint(20)     DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                varchar(255)   DEFAULT NULL COMMENT '记录创建者',
    `create_time`            datetime(6)    DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`         bigint(20)     DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                varchar(255)   DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`            datetime(6)    DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`            int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version`     int(11)        DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE,
    INDEX `codex_spu_code` (`spu_code`) USING BTREE
) COMMENT = '商品经营目录';

-- ----------------------------
-- Table structure for itm_item_cate
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_cate`
(
    `id`                 bigint(20) NOT NULL,
    `sec_bu_id`          bigint(20)      DEFAULT NULL,
    `sec_user_id`        bigint(20)      DEFAULT NULL,
    `sec_ou_id`          bigint(20)      DEFAULT NULL,
    `pid`                bigint(20) NOT NULL,
    `sort_no`            int(11)         DEFAULT NULL,
    `grade`              int(11)         DEFAULT NULL,
    `id_path`            varchar(255)    DEFAULT NULL,
    `code_path`          varchar(255)    DEFAULT NULL,
    `item_cate_code`     varchar(32)     DEFAULT NULL COMMENT '品类编码',
    `item_cate_name`     varchar(32)     DEFAULT NULL COMMENT '品类名称',
    `item_cate_is_basic` int(5)     NULL DEFAULT 0 COMMENT '是否基础类目（0：不是，1：是）',
    `status`             varchar(8)      DEFAULT NULL COMMENT '状态',
    `tenant_id`          bigint(20)      DEFAULT NULL,
    `remark`             varchar(255)    DEFAULT NULL,
    `create_user_id`     bigint(20)      DEFAULT NULL,
    `creator`            varchar(255)    DEFAULT NULL,
    `create_time`        datetime(6)     DEFAULT NULL,
    `modify_user_id`     bigint(20)      DEFAULT NULL,
    `updater`            varchar(255)    DEFAULT NULL,
    `modify_time`        datetime(6)     DEFAULT NULL,
    `delete_flag`        int(11)    NOT NULL,
    `audit_data_version` int(11)         DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_cate_pid` (`pid`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '商品品类';

-- ----------------------------
-- Table structure for itm_item_combo
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_combo`
(
    `id`                    bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`             bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`           bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`             bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `item_combo_code`       varchar(32)  DEFAULT NULL COMMENT '组合商品编码',
    `item_combo_name`       varchar(32)  DEFAULT NULL COMMENT '组合商品名称',
    `item_combo_other_name` varchar(32)  DEFAULT NULL COMMENT '组合商品别名',
    `item_combo_type`       varchar(16)  DEFAULT NULL COMMENT '组合商品类型',
    `status`                varchar(8)   DEFAULT NULL COMMENT '状态',
    `tenant_id`             bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`                varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version`    int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '组合商品';

-- ----------------------------
-- Table structure for itm_item_cust_prop
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_cust_prop`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `item_id`            bigint(20)   DEFAULT NULL COMMENT '商品ID',
    `cust_prop_key`      varchar(32)  DEFAULT NULL COMMENT '自定义属性Key',
    `cust_prop_value`    varchar(32)  DEFAULT NULL COMMENT '自定义属性Value',
    `status`             varchar(8)   DEFAULT NULL COMMENT '状态',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '商品自定义属性';

-- ----------------------------
-- Table structure for itm_item_cust_prop_applyd
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_cust_prop_applyd`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `item_id`            bigint(20)   DEFAULT NULL COMMENT '商品ID',
    `cust_prop_key`      varchar(32)  DEFAULT NULL COMMENT '自定义属性Key',
    `cust_prop_value`    varchar(32)  DEFAULT NULL COMMENT '自定义属性Value',
    `status`             varchar(8)   DEFAULT NULL COMMENT '状态',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `doc_no`             varchar(32)  DEFAULT NULL COMMENT '单据编号',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '商品自定义属性_履历';

-- ----------------------------
-- Table structure for itm_item_prop
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_prop`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `item_id`            bigint(20)   DEFAULT NULL COMMENT '商品ID',
    `cate_prop_type`     varchar(40)  DEFAULT NULL COMMENT '属性类型',
    `cate_prop_code`     varchar(40)  DEFAULT NULL COMMENT '属性名编码',
    `cate_prop_name`     varchar(40)  DEFAULT NULL COMMENT '属性名名称',
    `prop_value`         varchar(255) DEFAULT NULL COMMENT '属性名属性值编码',
    `status`             varchar(40)  DEFAULT NULL COMMENT '状态',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '商品属性';

-- ----------------------------
-- Table structure for itm_item_prop_applyd
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_prop_applyd`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `item_id`            bigint(20)   DEFAULT NULL COMMENT '商品ID',
    `cate_prop_type`     varchar(40)  DEFAULT NULL COMMENT '属性类型',
    `cate_prop_code`     varchar(40)  DEFAULT NULL COMMENT '属性名编码',
    `cate_prop_name`     varchar(40)  DEFAULT NULL COMMENT '属性名名称',
    `prop_value`         varchar(255) DEFAULT NULL COMMENT '属性名属性值编码',
    `status`             varchar(40)  DEFAULT NULL COMMENT '状态',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `doc_no`             varchar(32)  DEFAULT NULL COMMENT '单据编号',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '商品属性_履历';

-- ----------------------------
-- Table structure for itm_item_publish
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_publish`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `user_id`            bigint(20)   DEFAULT NULL COMMENT '发布人ID',
    `publish_time`       datetime     DEFAULT NULL COMMENT '发布时间',
    `status`             varchar(8)   DEFAULT NULL COMMENT '状态',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '商品发布管理';

-- ----------------------------
-- Table structure for itm_item_qualify
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_qualify`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `ou_id`              bigint(20)   DEFAULT NULL COMMENT '公司ID',
    `ou_code`            varchar(40)  DEFAULT NULL COMMENT '公司编号',
    `ou_name`            varchar(40)  DEFAULT NULL COMMENT '公司名称',
    `bu_id`              bigint(20)   DEFAULT NULL COMMENT 'BU ID',
    `bu_code`            varchar(40)  DEFAULT NULL COMMENT 'BU编号',
    `bu_name`            varchar(40)  DEFAULT NULL COMMENT 'BU名称',
    `item_id`            bigint(20)   DEFAULT NULL COMMENT '商品ID',
    `item_code`          varchar(40)  DEFAULT NULL COMMENT '商品编号',
    `item_code2`         varchar(40)  DEFAULT NULL COMMENT '商品编号2',
    `item_code3`         varchar(40)  DEFAULT NULL COMMENT '商品编号3',
    `item_name`          varchar(40)  DEFAULT NULL COMMENT '商品名称',
    `item_name2`         varchar(40)  DEFAULT NULL COMMENT '商品名称2',
    `item_name3`         varchar(40)  DEFAULT NULL COMMENT '商品名称3',
    `spec`               varchar(255) DEFAULT NULL COMMENT '规格，比如：食品净含量',
    `spu_id`             bigint(20)   DEFAULT NULL COMMENT 'SPU_ID',
    `spu_code`           varchar(40)  DEFAULT NULL COMMENT 'SPU_CODE',
    `spu_code2`          varchar(40)  DEFAULT NULL COMMENT 'SPU_CODE2',
    `spu_code3`          varchar(40)  DEFAULT NULL COMMENT 'SPU_CODE3',
    `spu_name`           varchar(40)  DEFAULT NULL COMMENT 'SPU_NAME',
    `spu_name2`          varchar(40)  DEFAULT NULL COMMENT 'SPU_NAME2',
    `spu_name3`          varchar(40)  DEFAULT NULL COMMENT 'SPU_NAME3',
    `qualify_type`       varchar(40)  DEFAULT NULL COMMENT '资质类型 [UDC]ITM:QUALIFY_TYPE',
    `qualify_name`       varchar(40)  DEFAULT NULL COMMENT '资质名称',
    `qualify_no`         varchar(40)  DEFAULT NULL COMMENT '资质编号',
    `qualify_file_name`  varchar(255) DEFAULT NULL COMMENT '资质文件名称',
    `qualify_file_code`  varchar(255) DEFAULT NULL COMMENT '资质文件编号',
    `valid_from`         datetime(6)  DEFAULT NULL COMMENT '生效日期',
    `valid_to`           datetime(6)  DEFAULT NULL COMMENT '失效日期',
    `next_check_date`    datetime(6)  DEFAULT NULL COMMENT '下次检查日期',
    `longterm_flag`      int(11)      DEFAULT NULL COMMENT '是否长期有效',
    `qualify_status`     varchar(40)  DEFAULT NULL COMMENT '资质证照状态 [UDC]COM:STATUS_ACTIVEORNO',
    `qualify_status2`    varchar(40)  DEFAULT NULL COMMENT '资质证照状态2',
    `qualify_owner`      varchar(40)  DEFAULT NULL COMMENT '证照所有者',
    `related_id1`        bigint(20)   DEFAULT NULL COMMENT '关联ID1',
    `related_id2`        bigint(20)   DEFAULT NULL COMMENT '关联ID2',
    `es1`                varchar(40)  DEFAULT NULL COMMENT 'ES1',
    `es2`                varchar(40)  DEFAULT NULL COMMENT 'ES2',
    `es3`                varchar(40)  DEFAULT NULL COMMENT 'ES3',
    `es4`                varchar(40)  DEFAULT NULL COMMENT 'ES4',
    `es5`                varchar(40)  DEFAULT NULL COMMENT 'ES5',
    `es6`                varchar(40)  DEFAULT NULL COMMENT 'ES6',
    `es7`                varchar(40)  DEFAULT NULL COMMENT 'ES7',
    `es8`                varchar(40)  DEFAULT NULL COMMENT 'ES8',
    `es9`                varchar(40)  DEFAULT NULL COMMENT 'ES9',
    `es10`               varchar(40)  DEFAULT NULL COMMENT 'ES10',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '商品资质信息';

-- ----------------------------
-- Table structure for itm_item_qualify_applyd
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_qualify_applyd`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `ou_id`              bigint(20)   DEFAULT NULL COMMENT '公司ID',
    `ou_code`            varchar(40)  DEFAULT NULL COMMENT '公司编号',
    `ou_name`            varchar(40)  DEFAULT NULL COMMENT '公司名称',
    `bu_id`              bigint(20)   DEFAULT NULL COMMENT 'BU ID',
    `bu_code`            varchar(40)  DEFAULT NULL COMMENT 'BU编号',
    `bu_name`            varchar(40)  DEFAULT NULL COMMENT 'BU名称',
    `item_id`            bigint(20)   DEFAULT NULL COMMENT '商品ID',
    `item_code`          varchar(40)  DEFAULT NULL COMMENT '商品编号',
    `item_code2`         varchar(40)  DEFAULT NULL COMMENT '商品编号2',
    `item_code3`         varchar(40)  DEFAULT NULL COMMENT '商品编号3',
    `item_name`          varchar(40)  DEFAULT NULL COMMENT '商品名称',
    `item_name2`         varchar(40)  DEFAULT NULL COMMENT '商品名称2',
    `item_name3`         varchar(40)  DEFAULT NULL COMMENT '商品名称3',
    `spec`               varchar(255) DEFAULT NULL COMMENT '规格，比如：食品净含量',
    `spu_id`             bigint(20)   DEFAULT NULL COMMENT 'SPU_ID',
    `spu_code`           varchar(40)  DEFAULT NULL COMMENT 'SPU_CODE',
    `spu_code2`          varchar(40)  DEFAULT NULL COMMENT 'SPU_CODE2',
    `spu_code3`          varchar(40)  DEFAULT NULL COMMENT 'SPU_CODE3',
    `spu_name`           varchar(40)  DEFAULT NULL COMMENT 'SPU_NAME',
    `spu_name2`          varchar(40)  DEFAULT NULL COMMENT 'SPU_NAME2',
    `spu_name3`          varchar(40)  DEFAULT NULL COMMENT 'SPU_NAME3',
    `qualify_type`       varchar(40)  DEFAULT NULL COMMENT '资质类型 [UDC]ITM:QUALIFY_TYPE',
    `qualify_name`       varchar(40)  DEFAULT NULL COMMENT '资质名称',
    `qualify_no`         varchar(40)  DEFAULT NULL COMMENT '资质编号',
    `qualify_file_name`  varchar(255) DEFAULT NULL COMMENT '资质文件名称',
    `qualify_file_code`  varchar(255) DEFAULT NULL COMMENT '资质文件编号',
    `valid_from`         datetime(6)  DEFAULT NULL COMMENT '生效日期',
    `valid_to`           datetime(6)  DEFAULT NULL COMMENT '失效日期',
    `next_check_date`    datetime(6)  DEFAULT NULL COMMENT '下次检查日期',
    `longterm_flag`      int(11)      DEFAULT NULL COMMENT '是否长期有效',
    `qualify_status`     varchar(40)  DEFAULT NULL COMMENT '资质证照状态 [UDC]COM:STATUS_ACTIVEORNO',
    `qualify_status2`    varchar(40)  DEFAULT NULL COMMENT '资质证照状态2',
    `qualify_owner`      varchar(40)  DEFAULT NULL COMMENT '证照所有者',
    `related_id1`        bigint(20)   DEFAULT NULL COMMENT '关联ID1',
    `related_id2`        bigint(20)   DEFAULT NULL COMMENT '关联ID2',
    `es1`                varchar(40)  DEFAULT NULL COMMENT 'ES1',
    `es2`                varchar(40)  DEFAULT NULL COMMENT 'ES2',
    `es3`                varchar(40)  DEFAULT NULL COMMENT 'ES3',
    `es4`                varchar(40)  DEFAULT NULL COMMENT 'ES4',
    `es5`                varchar(40)  DEFAULT NULL COMMENT 'ES5',
    `es6`                varchar(40)  DEFAULT NULL COMMENT 'ES6',
    `es7`                varchar(40)  DEFAULT NULL COMMENT 'ES7',
    `es8`                varchar(40)  DEFAULT NULL COMMENT 'ES8',
    `es9`                varchar(40)  DEFAULT NULL COMMENT 'ES9',
    `es10`               varchar(40)  DEFAULT NULL COMMENT 'ES10',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `doc_no`             varchar(32)  DEFAULT NULL COMMENT '单据编号',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '商品资质信息_履历';

-- ----------------------------
-- Table structure for itm_item_sku_business
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_sku_business`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `item_id`            bigint(20)   DEFAULT NULL COMMENT 'skuId',
    `item_code`          varchar(32)  DEFAULT NULL COMMENT '商品编码（sku编码）',
    `spu_id`             bigint(20)   DEFAULT NULL COMMENT 'SPU_ID',
    `spu_code`           varchar(40)  DEFAULT NULL COMMENT 'SPU_CODE',
    `item_source`        varchar(40)  DEFAULT NULL COMMENT '商品来源组织',
    `bu_code`            varchar(40)  DEFAULT NULL COMMENT '商品所属公司',
    `item_life_status`   varchar(40)  DEFAULT NULL COMMENT '生命状态',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `bu_code` (`bu_code`, `item_code`) USING BTREE
) COMMENT = '商品sku经营目录表';

-- ----------------------------
-- Table structure for itm_item_status_config
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_status_config`
(
    `id`                       bigint(20) NOT NULL COMMENT '记录唯一ID',
    `business_type`            varchar(40)  DEFAULT NULL COMMENT '业务',
    `business_code`            varchar(40)  DEFAULT NULL COMMENT '对应场景代码',
    `business_name`            varchar(40)  DEFAULT NULL COMMENT '场景名称',
    `business_desc`            varchar(40)  DEFAULT NULL COMMENT '场景说明',
    `config_status`            varchar(40)  DEFAULT NULL COMMENT '配置状态',
    `check_basic_status`       int(11)      DEFAULT NULL COMMENT '是否校验basic商品状态',
    `check_shop_status`        int(11)      DEFAULT NULL COMMENT '是否校验经营目录商品状态',
    `tenant_id`                bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`                   varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`           bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                  varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`              datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`           bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                  varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`              datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`              int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version`       int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`                bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`              bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`                bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `data_sign`                varchar(40)  DEFAULT NULL COMMENT '数据标识',
    `busin_excu_sign_status1`  int(11)      DEFAULT NULL COMMENT '正常',
    `busin_excu_sign_status2`  int(11)      DEFAULT NULL COMMENT '销售冻结',
    `busin_excu_sign_status3`  int(11)      DEFAULT NULL COMMENT '采购冻结',
    `busin_excu_sign_status4`  int(11)      DEFAULT NULL COMMENT '业务执行标识4',
    `busin_excu_sign_status5`  int(11)      DEFAULT NULL COMMENT '业务执行标识5',
    `busin_excu_sign_status6`  int(11)      DEFAULT NULL COMMENT '业务执行标识6',
    `busin_excu_sign_status7`  int(11)      DEFAULT NULL COMMENT '业务执行标识7',
    `busin_excu_sign_status8`  int(11)      DEFAULT NULL COMMENT '业务执行标识8',
    `busin_excu_sign_status9`  int(11)      DEFAULT NULL COMMENT '业务执行标识9',
    `busin_excu_sign_status10` int(11)      DEFAULT NULL COMMENT '业务执行标识4910',
    `enable`                   int(11)      DEFAULT NULL COMMENT '正常',
    `sale_freeze`              int(11)      DEFAULT NULL COMMENT '销售冻结',
    `purc_freeze`              int(11)      DEFAULT NULL COMMENT '采购冻结',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '商品状态配置表';

-- ----------------------------
-- Table structure for itm_item_tag
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_tag`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `item_id`            bigint(20)   DEFAULT NULL COMMENT '商品ID',
    `upper_tag_code`     varchar(32)  DEFAULT NULL COMMENT '上级标签编码',
    `upper_tag_name`     varchar(32)  DEFAULT NULL COMMENT '上级标签名称',
    `tag_code`           varchar(32)  DEFAULT NULL COMMENT '标签编码',
    `tag_name`           varchar(32)  DEFAULT NULL COMMENT '标签名称',
    `status`             varchar(8)   DEFAULT NULL COMMENT '状态',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `ux_tag` (`tag_code`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '商品标签';

-- ----------------------------
-- Table structure for itm_item_tag_applyd
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_tag_applyd`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `item_id`            bigint(20)   DEFAULT NULL COMMENT '商品ID',
    `upper_tag_code`     varchar(32)  DEFAULT NULL COMMENT '上级标签编码',
    `upper_tag_name`     varchar(32)  DEFAULT NULL COMMENT '上级标签名称',
    `tag_code`           varchar(32)  DEFAULT NULL COMMENT '标签编码',
    `tag_name`           varchar(32)  DEFAULT NULL COMMENT '标签名称',
    `status`             varchar(8)   DEFAULT NULL COMMENT '状态',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `doc_no`             varchar(32)  DEFAULT NULL COMMENT '单据编号',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '商品标签_履历';

-- ----------------------------
-- Table structure for itm_itemuom_conv
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_itemuom_conv`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)     DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)     DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)     DEFAULT NULL COMMENT 'sec_ou_id',
    `item_id`            bigint(20)     DEFAULT NULL COMMENT '商品id',
    `from_uom`           varchar(40)    DEFAULT NULL COMMENT '从单位',
    `to_uom`             varchar(40)    DEFAULT NULL COMMENT '到单位',
    `ratio`              decimal(20, 8) DEFAULT NULL COMMENT '转换系数',
    `revert_ratio`       decimal(20, 8) DEFAULT NULL COMMENT '反向系数',
    `tenant_id`          bigint(20)     DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)   DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)     DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)   DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)    DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)     DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)   DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)    DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)        DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '商品计量单位转换';

-- ----------------------------
-- Table structure for itm_itemuom_conv_applyd
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_itemuom_conv_applyd`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `item_id`            bigint(20)     DEFAULT NULL COMMENT '商品id',
    `from_uom`           varchar(40)    DEFAULT NULL COMMENT '从单位',
    `to_uom`             varchar(40)    DEFAULT NULL COMMENT '到单位',
    `ratio`              decimal(20, 8) DEFAULT NULL COMMENT '转换系数',
    `revert_ratio`       decimal(20, 8) DEFAULT NULL COMMENT '反向系数',
    `tenant_id`          bigint(20)     DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)   DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)     DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)   DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)    DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)     DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)   DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)    DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)        DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)     DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)     DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)     DEFAULT NULL COMMENT 'sec_ou_id',
    `doc_no`             varchar(32)    DEFAULT NULL COMMENT '单据编号',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '商品计量单位转换_履历';

-- ----------------------------
-- Table structure for itm_life_status_scheduling
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_life_status_scheduling`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `ou_id`              bigint(20)   DEFAULT NULL COMMENT '创建人所属公司id',
    `ou_code`            varchar(40)  DEFAULT NULL COMMENT '创建人所属公司编码',
    `ou_name`            varchar(40)  DEFAULT NULL COMMENT '创建人所属公司名称',
    `bu_id`              bigint(20)   DEFAULT NULL COMMENT 'BU ID',
    `bu_code`            varchar(40)  DEFAULT NULL COMMENT 'BU编号',
    `bu_name`            varchar(40)  DEFAULT NULL COMMENT 'BU名称',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `life_status_code`   varchar(40)  DEFAULT NULL COMMENT '生命状态编码',
    `item_source`        varchar(40)  DEFAULT NULL COMMENT '商品来源',
    `item_id`            bigint(20)   DEFAULT NULL COMMENT '商品ID',
    `item_code`          varchar(40)  DEFAULT NULL COMMENT '商品编号',
    `item_name`          varchar(40)  DEFAULT NULL COMMENT '商品名称',
    `branch_plant`       varchar(40)  DEFAULT NULL COMMENT '范围',
    `global_or_not`      int(11)      DEFAULT NULL COMMENT '是否全局',
    `item_life_status`   varchar(40)  DEFAULT NULL COMMENT '生命状态',
    `valid_from`         datetime(6)  DEFAULT NULL COMMENT '生效时间',
    `valid_to`           datetime(6)  DEFAULT NULL COMMENT '失效时间',
    `status`             int(11)      DEFAULT NULL COMMENT '活动状态',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '商品生命状态日程表';

-- ----------------------------
-- Table structure for itm_prop
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_prop`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `cate_prop_code`     varchar(40)  DEFAULT NULL COMMENT '属性名编码',
    `cate_prop_name`     varchar(40)  DEFAULT NULL COMMENT '属性名名称',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `ux_prop_code` (`cate_prop_code`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '属性表';

-- ----------------------------
-- Table structure for itm_tag
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_tag`
(
    `id`                 bigint(20) NOT NULL,
    `sec_bu_id`          bigint(20)   DEFAULT NULL,
    `sec_user_id`        bigint(20)   DEFAULT NULL,
    `sec_ou_id`          bigint(20)   DEFAULT NULL,
    `pid`                bigint(20) NOT NULL,
    `sort_no`            int(11)      DEFAULT NULL,
    `grade`              int(11)      DEFAULT NULL,
    `id_path`            varchar(255) DEFAULT NULL,
    `code_path`          varchar(255) DEFAULT NULL,
    `tag_code`           varchar(32)  DEFAULT NULL COMMENT '标签编码',
    `tag_name`           varchar(32)  DEFAULT NULL COMMENT '标签名称',
    `tag_type`           varchar(8)   DEFAULT NULL COMMENT '标签类型',
    `tag_desc`           varchar(255) DEFAULT NULL COMMENT '标签描述',
    `status`             varchar(8)   DEFAULT NULL COMMENT '状态',
    `tenant_id`          bigint(20)   DEFAULT NULL,
    `remark`             varchar(255) DEFAULT NULL,
    `create_user_id`     bigint(20)   DEFAULT NULL,
    `creator`            varchar(255) DEFAULT NULL,
    `create_time`        datetime(6)  DEFAULT NULL,
    `modify_user_id`     bigint(20)   DEFAULT NULL,
    `updater`            varchar(255) DEFAULT NULL,
    `modify_time`        datetime(6)  DEFAULT NULL,
    `delete_flag`        int(11)    NOT NULL,
    `audit_data_version` int(11)      DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_tag_pid` (`pid`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '标签';

-- ----------------------------
-- Table structure for org_addr
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_addr`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `bu_id`              bigint(20)   DEFAULT NULL COMMENT 'BU_ID',
    `bu_code`            varchar(32)  DEFAULT NULL COMMENT 'BU编号',
    `bu_name`            varchar(32)  DEFAULT NULL COMMENT 'BU名称',
    `addr_no`            bigint(20) NOT NULL COMMENT '地址号',
    `line_no`            int(20)      DEFAULT NULL COMMENT '行号',
    `addr_code`          varchar(32)  DEFAULT NULL COMMENT '地址薄编号',
    `addr_type`          varchar(32)  DEFAULT NULL COMMENT '地址薄类型:[UDC]ORG:ADDR_TYPE',
    `addr_type2`         varchar(32)  DEFAULT NULL COMMENT '地址薄类型2',
    `addr_type3`         varchar(32)  DEFAULT NULL COMMENT '地址薄类型3',
    `addr_name`          varchar(32)  DEFAULT NULL COMMENT '地址薄名称',
    `addr_abbr`          varchar(32)  DEFAULT NULL COMMENT '地址薄简称',
    `addr_status`        varchar(32)  DEFAULT NULL COMMENT '地址薄状态',
    `addr_status2`       varchar(32)  DEFAULT NULL COMMENT '地址薄状态2',
    `addr_status3`       varchar(32)  DEFAULT NULL COMMENT '地址薄状态3',
    `legal_addr_no`      bigint(20)   DEFAULT NULL COMMENT '法人地址号',
    `src_cls`            varchar(32)  DEFAULT NULL COMMENT '来源类别',
    `src_id`             bigint(20)   DEFAULT NULL COMMENT '来源ID',
    `outer_code`         varchar(32)  DEFAULT NULL COMMENT '外部编码',
    `es1`                varchar(32)  DEFAULT NULL COMMENT 'ES1',
    `es2`                varchar(32)  DEFAULT NULL COMMENT 'ES2',
    `es3`                varchar(32)  DEFAULT NULL COMMENT 'ES3',
    `es4`                varchar(32)  DEFAULT NULL COMMENT 'ES4',
    `es5`                varchar(32)  DEFAULT NULL COMMENT 'ES5',
    `es6`                varchar(32)  DEFAULT NULL COMMENT 'ES6',
    `es7`                varchar(32)  DEFAULT NULL COMMENT 'ES7',
    `es8`                varchar(32)  DEFAULT NULL COMMENT 'ES8',
    `es9`                varchar(32)  DEFAULT NULL COMMENT 'ES9',
    `es10`               varchar(32)  DEFAULT NULL COMMENT 'ES10',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_org_addr_no` (`addr_no`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '地址簿';

-- ----------------------------
-- Table structure for org_addr_address
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_addr_address`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)     DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)     DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)     DEFAULT NULL COMMENT 'sec_ou_id',
    `bu_id`              bigint(20)     DEFAULT NULL COMMENT 'BU_ID',
    `bu_code`            varchar(32)    DEFAULT NULL COMMENT 'BU编号',
    `bu_name`            varchar(32)    DEFAULT NULL COMMENT 'BU名称',
    `addr_no`            bigint(20) NOT NULL COMMENT '地址号',
    `line_no`            int(20)        DEFAULT NULL COMMENT '行号',
    `address_name`       varchar(32)    DEFAULT NULL COMMENT '地址名称',
    `address_type`       varchar(32)    DEFAULT NULL COMMENT '地址类型(指送货地址，开票地址等):[UDC]ORG:ADDRESS_TYPE',
    `address_type2`      varchar(32)    DEFAULT NULL COMMENT '地址类型2',
    `default_flag`       tinyint(1)     DEFAULT NULL COMMENT '是否默认：1是，0否',
    `address_status`     varchar(32)    DEFAULT NULL COMMENT '地址状态',
    `cont_person`        varchar(32)    DEFAULT NULL COMMENT '联系人姓名',
    `mobile`             varchar(32)    DEFAULT NULL COMMENT '手机号码',
    `mobile2`            varchar(32)    DEFAULT NULL COMMENT '手机号码2',
    `tel`                varchar(32)    DEFAULT NULL COMMENT '电话',
    `tel2`               varchar(32)    DEFAULT NULL COMMENT '电话2',
    `fax`                varchar(32)    DEFAULT NULL COMMENT '传真',
    `email`              varchar(32)    DEFAULT NULL COMMENT '电邮',
    `email2`             varchar(32)    DEFAULT NULL COMMENT '电邮2',
    `country`            varchar(32)    DEFAULT NULL COMMENT '国家',
    `province`           varchar(32)    DEFAULT NULL COMMENT '省份',
    `city`               varchar(32)    DEFAULT NULL COMMENT '城市',
    `county`             varchar(32)    DEFAULT NULL COMMENT '区县',
    `street`             varchar(255)   DEFAULT NULL COMMENT '街道/乡镇',
    `detail_addr`        varchar(255)   DEFAULT NULL COMMENT '详细地址',
    `tp_type`            varchar(255)   DEFAULT NULL COMMENT '默认运输方式',
    `x_lon`              decimal(10, 6) DEFAULT NULL COMMENT '经度',
    `y_lat`              decimal(10, 6) DEFAULT NULL COMMENT '纬度',
    `coord_type`         varchar(32)    DEFAULT NULL COMMENT '经纬度标准',
    `zip_code`           varchar(32)    DEFAULT NULL COMMENT '邮政编码',
    `web_address`        varchar(32)    DEFAULT NULL COMMENT '网址',
    `weibo`              varchar(32)    DEFAULT NULL COMMENT '微博',
    `wechat_mp`          varchar(32)    DEFAULT NULL COMMENT '微信公众号',
    `other_info1`        varchar(32)    DEFAULT NULL COMMENT '其它联系信息1',
    `other_info2`        varchar(32)    DEFAULT NULL COMMENT '其它联系信息2',
    `other_info3`        varchar(32)    DEFAULT NULL COMMENT '其它联系信息3',
    `position`           varchar(32)    DEFAULT NULL COMMENT '职位',
    `pid`                bigint(20)     DEFAULT NULL COMMENT '上级联系人ID',
    `es1`                varchar(255)   DEFAULT NULL COMMENT 'ES1',
    `es2`                varchar(255)   DEFAULT NULL COMMENT 'ES2',
    `es3`                varchar(255)   DEFAULT NULL COMMENT 'ES3',
    `es4`                varchar(255)   DEFAULT NULL COMMENT 'ES4',
    `es5`                varchar(255)   DEFAULT NULL COMMENT 'ES5',
    `es6`                varchar(255)   DEFAULT NULL COMMENT 'ES6',
    `es7`                varchar(255)   DEFAULT NULL COMMENT 'ES7',
    `es8`                varchar(255)   DEFAULT NULL COMMENT 'ES8',
    `es9`                varchar(255)   DEFAULT NULL COMMENT 'ES9',
    `es10`               varchar(255)   DEFAULT NULL COMMENT 'ES10',
    `tenant_id`          bigint(20)     DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)   DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)     DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)   DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)    DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)     DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)   DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)    DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)        DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '地址簿地址信息';

-- ----------------------------
-- Table structure for org_addr_bank_acc
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_addr_bank_acc`
(
    `id`                         bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`                  bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`                bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`                  bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `thirdparty_virtual_user_id` varchar(255) DEFAULT NULL COMMENT '第三方虚拟用户ID',
    `thirdparty_virtual_acc`     varchar(255) DEFAULT NULL COMMENT '第三方虚拟帐户',
    `bu_id`                      bigint(20)   DEFAULT NULL COMMENT 'BU_ID',
    `bu_code`                    varchar(32)  DEFAULT NULL COMMENT 'BU编号',
    `bu_name`                    varchar(32)  DEFAULT NULL COMMENT 'BU名称',
    `addr_no`                    bigint(20) NOT NULL COMMENT '地址号',
    `line_no`                    int(20)      DEFAULT NULL COMMENT '行号',
    `acc_code`                   varchar(32)  DEFAULT NULL COMMENT '账号编号',
    `acc_type`                   varchar(32)  DEFAULT NULL COMMENT '账号类型:[UDC]ORG:ADDR_BANKACC_TYPE',
    `default_flag`               tinyint(1)   DEFAULT NULL COMMENT '是否默认：1是，0否',
    `bank_id`                    bigint(20)   DEFAULT NULL COMMENT '银行ID',
    `bank_code`                  varchar(32)  DEFAULT NULL COMMENT '银行编号',
    `bank_name`                  varchar(32)  DEFAULT NULL COMMENT '银行名称',
    `branch_name`                varchar(32)  DEFAULT NULL COMMENT '网点名称',
    `bank_acc`                   varchar(255) DEFAULT NULL COMMENT '开户行账号',
    `holder_name`                varchar(32)  DEFAULT NULL COMMENT '开户人姓名',
    `curr_code`                  varchar(32)  DEFAULT NULL COMMENT '币种',
    `tenant_id`                  bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`                     varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`             bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                    varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`                datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`             bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                    varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`                datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`                int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version`         int(11)      DEFAULT NULL COMMENT '锁版本',
    `bank_account_name`          varchar(255) DEFAULT NULL COMMENT '开户行账户名称',
    `bank_account_comp`          varchar(255) DEFAULT NULL COMMENT '开户行账户组合',
    `pay_collect_method`         varchar(32)  DEFAULT NULL COMMENT '收付款方式 [UDC]COM:PAY_METHOD',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '地址簿银行账号信息';

-- ----------------------------
-- Table structure for org_addr_qualify
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_addr_qualify`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `bu_id`              bigint(20)   DEFAULT NULL COMMENT 'BU_ID',
    `bu_code`            varchar(32)  DEFAULT NULL COMMENT 'BU编号',
    `bu_name`            varchar(32)  DEFAULT NULL COMMENT 'BU名称',
    `addr_no`            bigint(20) NOT NULL COMMENT '地址号',
    `line_no`            int(20)      DEFAULT NULL COMMENT '行号',
    `qualify_type`       varchar(32)  DEFAULT NULL COMMENT '资质类型:[UDC]ORG:ADDR_QUALIFY_TYPE',
    `qualify_name`       varchar(32)  DEFAULT NULL COMMENT '资质名称',
    `qualify_no`         varchar(32)  DEFAULT NULL COMMENT '资质文件编号(文件自己的编号)',
    `qualify_file_id`    bigint(20)   DEFAULT NULL COMMENT '资质文件ID',
    `qualify_file_name`  varchar(255) DEFAULT NULL COMMENT '资质文件名称',
    `qualify_file_code`  varchar(255) DEFAULT NULL COMMENT '资质文件编号(上传后系统生成的编号',
    `valid_from`         datetime     DEFAULT NULL COMMENT '生效日期',
    `valid_to`           datetime     DEFAULT NULL COMMENT '失效日期',
    `next_check_date`    datetime     DEFAULT NULL COMMENT '下次检验日期',
    `lang_term_flag`     tinyint(1)   DEFAULT NULL COMMENT '是否长期有效：1是，0否',
    `qualify_status`     varchar(32)  DEFAULT NULL COMMENT '资质证照状态:[UDC]COM:STATUS_ACTIVEORNO',
    `qualify_status2`    varchar(32)  DEFAULT NULL COMMENT '资质证照状态2',
    `qualify_owner`      varchar(32)  DEFAULT NULL COMMENT '证照所有者',
    `es1`                varchar(255) DEFAULT NULL COMMENT 'ES1',
    `es2`                varchar(255) DEFAULT NULL COMMENT 'ES2',
    `es3`                varchar(255) DEFAULT NULL COMMENT 'ES3',
    `es4`                varchar(255) DEFAULT NULL COMMENT 'ES4',
    `es5`                varchar(255) DEFAULT NULL COMMENT 'ES5',
    `es6`                varchar(255) DEFAULT NULL COMMENT 'ES6',
    `es7`                varchar(255) DEFAULT NULL COMMENT 'ES7',
    `es8`                varchar(255) DEFAULT NULL COMMENT 'ES8',
    `es9`                varchar(255) DEFAULT NULL COMMENT 'ES9',
    `es10`               varchar(255) DEFAULT NULL COMMENT 'ES10',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '地址簿资质信息';

-- ----------------------------
-- Table structure for org_area
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_area`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `ou_id`              bigint(20)   DEFAULT NULL COMMENT 'OU_ID',
    `bu_id`              bigint(20)   DEFAULT NULL COMMENT 'BU_ID',
    `bu_code`            varchar(32)  DEFAULT NULL COMMENT 'BU编号',
    `bu_name`            varchar(32)  DEFAULT NULL COMMENT 'BU名称',
    `province`           varchar(32)  DEFAULT NULL COMMENT '省份',
    `city`               varchar(32)  DEFAULT NULL COMMENT '城市',
    `county`             varchar(32)  DEFAULT NULL COMMENT '区县',
    `street`             varchar(255) DEFAULT NULL COMMENT '街道/乡镇',
    `detail_addr`        varchar(255) DEFAULT NULL COMMENT '详细地址',
    `nationwide_sts`     varchar(10)  DEFAULT NULL COMMENT '详细地址',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '公司行政区划';

-- ----------------------------
-- Table structure for org_bg_bu
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_bg_bu`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = 'BU组与BU';

-- ----------------------------
-- Table structure for org_bu
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_bu`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)      DEFAULT NULL COMMENT 'sec_ou_id',
    `bu_code`            varchar(32)     DEFAULT NULL COMMENT 'BU编号',
    `bu_name`            varchar(32)     DEFAULT NULL COMMENT 'BU名称',
    `bu_name2`           varchar(32)     DEFAULT NULL COMMENT 'BU名称2',
    `bu_name3`           varchar(32)     DEFAULT NULL COMMENT 'BU名称3',
    `bu_name4`           varchar(32)     DEFAULT NULL COMMENT 'BU名称4',
    `bu_abbr`            varchar(32)     DEFAULT NULL COMMENT 'BU简称',
    `bu_type`            varchar(255)    DEFAULT NULL COMMENT 'BU类型',
    `bu_type2`           varchar(32)     DEFAULT NULL COMMENT '店铺类型 [UDC]ORG:BU_TYPE2',
    `bu_type3`           varchar(32)     DEFAULT NULL COMMENT 'BU类型3',
    `bu_type4`           varchar(32)     DEFAULT NULL COMMENT 'BU类型4',
    `bu_type5`           varchar(32)     DEFAULT NULL COMMENT 'BU类型5',
    `bu_type6`           varchar(32)     DEFAULT NULL COMMENT 'BU类型6',
    `bu_type7`           varchar(32)     DEFAULT NULL COMMENT 'BU类型7',
    `bu_status`          varchar(32)     DEFAULT NULL COMMENT 'BU状态 [UDC]COM:STATUS_BU',
    `bu_status2`         varchar(32)     DEFAULT NULL COMMENT 'BU状态2',
    `bu_status3`         varchar(32)     DEFAULT NULL COMMENT 'BU状态3',
    `ou_id`              bigint(20)      DEFAULT NULL COMMENT '公司ID',
    `ou_code`            varchar(32)     DEFAULT NULL COMMENT '公司编号',
    `ou_name`            varchar(32)     DEFAULT NULL COMMENT '公司名称',
    `pid`                bigint(20)      DEFAULT NULL COMMENT '上级ID',
    `bu_path`            varchar(32)     DEFAULT NULL COMMENT '关系路径',
    `addr_no`            varchar(32)     DEFAULT NULL COMMENT '地址号',
    `bu_level`           varchar(32)     DEFAULT NULL COMMENT 'BU层级 [UDC]ORG:BU_LEVEL',
    `bu_region`          varchar(32)     DEFAULT NULL COMMENT '区域 [UDC]COM:REGION',
    `sort_no`            int(11)         DEFAULT NULL COMMENT '排序号码',
    `pic_emp_id`         bigint(20)      DEFAULT NULL COMMENT '负责人员工ID',
    `pic_name`           varchar(32)     DEFAULT NULL COMMENT '负责人姓名',
    `cat`                varchar(40)     DEFAULT NULL COMMENT '类别码',
    `cat2`               varchar(40)     DEFAULT NULL COMMENT '类别码2',
    `cat3`               varchar(40)     DEFAULT NULL COMMENT '类别码3',
    `cat4`               varchar(40)     DEFAULT NULL COMMENT '类别码4',
    `cat5`               varchar(40)     DEFAULT NULL COMMENT '类别码5',
    `cat6`               varchar(40)     DEFAULT NULL COMMENT '类别码6',
    `cat7`               varchar(40)     DEFAULT NULL COMMENT '类别码7',
    `cat8`               varchar(40)     DEFAULT NULL COMMENT '类别码8',
    `cat9`               varchar(40)     DEFAULT NULL COMMENT '类别码9',
    `cat10`              varchar(40)     DEFAULT NULL COMMENT '类别码10',
    `cat11`              varchar(40)     DEFAULT NULL COMMENT '类别码11',
    `cat12`              varchar(40)     DEFAULT NULL COMMENT '类别码12',
    `cat13`              varchar(40)     DEFAULT NULL COMMENT '类别码13',
    `cat14`              varchar(40)     DEFAULT NULL COMMENT '类别码14',
    `cat15`              varchar(40)     DEFAULT NULL COMMENT '类别码15',
    `cat16`              varchar(40)     DEFAULT NULL COMMENT '类别码16',
    `cat17`              varchar(40)     DEFAULT NULL COMMENT '类别码17',
    `cat18`              varchar(40)     DEFAULT NULL COMMENT '类别码18',
    `cat19`              varchar(40)     DEFAULT NULL COMMENT '类别码19',
    `cat20`              varchar(40)     DEFAULT NULL COMMENT '类别码20',
    `cat21`              varchar(40)     DEFAULT NULL COMMENT '类别码21',
    `cat22`              varchar(40)     DEFAULT NULL COMMENT '类别码22',
    `cat23`              varchar(40)     DEFAULT NULL COMMENT '类别码23',
    `cat24`              varchar(40)     DEFAULT NULL COMMENT '类别码24',
    `cat25`              varchar(40)     DEFAULT NULL COMMENT '类别码25',
    `cat26`              varchar(40)     DEFAULT NULL COMMENT '类别码26',
    `cat27`              varchar(40)     DEFAULT NULL COMMENT '类别码27',
    `cat28`              varchar(40)     DEFAULT NULL COMMENT '类别码28',
    `cat29`              varchar(40)     DEFAULT NULL COMMENT '类别码29',
    `cat30`              varchar(40)     DEFAULT NULL COMMENT '类别码30',
    `tenant_id`          bigint(20)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)         DEFAULT NULL COMMENT '锁版本',
    `cost_centre_code`   varchar(40)     DEFAULT NULL COMMENT '成本中心编码',
    `cost_centre_name`   varchar(40)     DEFAULT NULL COMMENT '成本中心名称',
    `jdy_flag`           int(11)         DEFAULT NULL COMMENT '是否同步激荡云',
    `data_source`        varchar(40)     DEFAULT NULL COMMENT '数据来源',
    `sync_status`        tinyint(1) NULL DEFAULT 0 COMMENT '同步的数据是否需要覆盖 false:忽略  true:覆盖',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = 'BU';

-- ----------------------------
-- Table structure for org_bu_ref
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_bu_ref`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '组织关联';

-- ----------------------------
-- Table structure for org_bu_tree
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_bu_tree`
(
    `id`                  bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`           bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`         bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`           bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `bu_tree_type`        varchar(32)  DEFAULT NULL COMMENT '组织树类型',
    `bu_tree_type2`       varchar(32)  DEFAULT NULL COMMENT '组织树类型2',
    `bu_tree_type3`       varchar(32)  DEFAULT NULL COMMENT '组织树类型3',
    `bu_tree_status`      varchar(32)  DEFAULT NULL COMMENT '组织树状态',
    `bu_tree_code`        varchar(32)  DEFAULT NULL COMMENT '组织树编号',
    `bu_tree_name`        varchar(64)  DEFAULT NULL COMMENT '组织树名称',
    `bu_tree_version`     varchar(32)  DEFAULT NULL COMMENT '组织树版本',
    `now_version`         varchar(32)  DEFAULT NULL COMMENT '组织树当前版本',
    `cat`                 varchar(32)  DEFAULT NULL COMMENT '类别码',
    `cat2`                varchar(32)  DEFAULT NULL COMMENT '类别码2',
    `cat3`                varchar(32)  DEFAULT NULL COMMENT '类别码3',
    `cat4`                varchar(32)  DEFAULT NULL COMMENT '类别码4',
    `cat5`                varchar(32)  DEFAULT NULL COMMENT '类别码5',
    `cat6`                varchar(32)  DEFAULT NULL COMMENT '类别码6',
    `cat7`                varchar(32)  DEFAULT NULL COMMENT '类别码7',
    `cat8`                varchar(32)  DEFAULT NULL COMMENT '类别码8',
    `cat9`                varchar(32)  DEFAULT NULL COMMENT '类别码9',
    `cat10`               varchar(32)  DEFAULT NULL COMMENT '类别码10',
    `tenant_id`           bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`              varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`      bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`             varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`         datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`      bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`             varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`         datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`         int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version`  int(11)      DEFAULT NULL COMMENT '锁版本',
    `release_time`        datetime(6)  DEFAULT NULL COMMENT '发布时间',
    `is_now_version`      bit(1)       DEFAULT NULL COMMENT '是否当前版本',
    `disable_time`        datetime(6)  DEFAULT NULL COMMENT '停用时间',
    `release_user`        varchar(255) DEFAULT NULL COMMENT '发布人',
    `version_instruction` varchar(255) DEFAULT NULL COMMENT '版本说明',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '组织树';

-- ----------------------------
-- Table structure for org_bu_tree_d
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_bu_tree_d`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)      DEFAULT NULL COMMENT 'sec_ou_id',
    `bu_tree_id`         bigint(20)      DEFAULT NULL COMMENT '组织树ID',
    `bu_id`              bigint(20)      DEFAULT NULL COMMENT '组织ID',
    `pid`                bigint(20)      DEFAULT NULL COMMENT '上级ID',
    `bu_path`            varchar(64)     DEFAULT NULL COMMENT '路径',
    `bu_level`           varchar(64)     DEFAULT NULL COMMENT '组织层级',
    `sort_no`            int(11)         DEFAULT NULL COMMENT '排序',
    `grade`              int(8)          DEFAULT NULL COMMENT '级别',
    `tenant_id`          bigint(20)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)         DEFAULT NULL COMMENT '锁版本',
    `code_path`          varchar(255)    DEFAULT NULL,
    `bu_code`            varchar(40)     DEFAULT NULL,
    `data_source`        varchar(40)     DEFAULT NULL COMMENT '数据来源',
    `sync_status`        tinyint(1) NULL DEFAULT 0 COMMENT '同步的数据是否需要覆盖 false:忽略  true:覆盖',
    `jdy_flag`           int(11)         DEFAULT NULL COMMENT '是否同步激荡云 默认:1',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_bu_tree_pid` (`pid`) USING BTREE,
    INDEX `idx_bu_tree_code_path` (`code_path`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '组织树明细';

-- ----------------------------
-- Table structure for org_bu_tree_version
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_bu_tree_version`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '组织树版本';

-- ----------------------------
-- Table structure for org_emp
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_emp`
(
    `id`                 bigint(20) NOT NULL,
    `sec_bu_id`          bigint(20)      DEFAULT NULL,
    `sec_user_id`        bigint(20)      DEFAULT NULL,
    `sec_ou_id`          bigint(20)      DEFAULT NULL,
    `pid`                bigint(20) NOT NULL,
    `sort_no`            int(11)         DEFAULT NULL,
    `grade`              int(11)         DEFAULT NULL,
    `id_path`            varchar(255)    DEFAULT NULL,
    `code_path`          varchar(255)    DEFAULT NULL,
    `ou_id`              bigint(20)      DEFAULT NULL COMMENT '公司ID',
    `ou_code`            varchar(40)     DEFAULT NULL COMMENT '公司编号',
    `ou_name`            varchar(40)     DEFAULT NULL COMMENT '公司名称',
    `bu_id`              bigint(20)      DEFAULT NULL COMMENT 'BU ID',
    `bu_code`            varchar(40)     DEFAULT NULL COMMENT 'BU编号',
    `bu_name`            varchar(40)     DEFAULT NULL COMMENT 'BU名称',
    `emp_bu_id`          bigint(20)      DEFAULT NULL COMMENT '员工所属 BU ID',
    `emp_bu_tree_id`     bigint(20)      DEFAULT NULL COMMENT '员工所属BU树ID',
    `emp_bu_treedid`     bigint(20)      DEFAULT NULL COMMENT '员工所属BU树详情ID',
    `user_id`            bigint(20)      DEFAULT NULL COMMENT '用户id',
    `user_name`          varchar(40)     DEFAULT NULL COMMENT '用户名',
    `emp_code`           varchar(40)     DEFAULT NULL COMMENT '雇员编号',
    `emp_name`           varchar(40)     DEFAULT NULL COMMENT '雇员姓名',
    `emp_type`           varchar(255)    DEFAULT NULL COMMENT '员工类型 [UDC]ORG:EMP_TYPE',
    `emp_type2`          varchar(40)     DEFAULT NULL COMMENT '员工类型2',
    `emp_type3`          varchar(40)     DEFAULT NULL COMMENT '员工类型3',
    `emp_status`         varchar(40)     DEFAULT NULL COMMENT '员工状态 [UDC]ORG:EMP_STATUS',
    `foreign_name`       varchar(40)     DEFAULT NULL COMMENT '雇员外文名',
    `addr_no`            bigint(20)      DEFAULT NULL COMMENT '地址号',
    `emp_gender`         varchar(40)     DEFAULT NULL COMMENT '员工性别',
    `birth_date`         datetime(6)     DEFAULT NULL COMMENT '出生日期',
    `email`              varchar(40)     DEFAULT NULL COMMENT '工作邮箱',
    `mobile`             varchar(40)     DEFAULT NULL COMMENT '工作手机号',
    `id_type`            varchar(40)     DEFAULT NULL COMMENT '证件类型',
    `id_no`              varchar(255)    DEFAULT NULL COMMENT '证件号码',
    `emp_level`          varchar(40)     DEFAULT NULL COMMENT '职级',
    `title`              varchar(40)     DEFAULT NULL COMMENT '行政职位, [UDC]ORG:TITLE',
    `join_date`          datetime(6)     DEFAULT NULL COMMENT '入职日期',
    `leave_date`         datetime(6)     DEFAULT NULL COMMENT '离职日期',
    `tenant_id`          bigint(20)      DEFAULT NULL,
    `remark`             varchar(255)    DEFAULT NULL,
    `create_user_id`     bigint(20)      DEFAULT NULL,
    `creator`            varchar(255)    DEFAULT NULL,
    `create_time`        datetime(6)     DEFAULT NULL,
    `modify_user_id`     bigint(20)      DEFAULT NULL,
    `updater`            varchar(255)    DEFAULT NULL,
    `modify_time`        datetime(6)     DEFAULT NULL,
    `delete_flag`        int(11)    NOT NULL,
    `audit_data_version` int(11)         DEFAULT NULL,
    `jdy_flag`           int(11)         DEFAULT NULL COMMENT '是否同步激荡云',
    `data_source`        varchar(40)     DEFAULT NULL COMMENT '数据来源',
    `sync_status`        tinyint(1) NULL DEFAULT 0 COMMENT '同步的数据是否需要覆盖 false:忽略  true:覆盖',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_emp_pid` (`pid`) USING BTREE,
    INDEX `idx_emp_id_path` (`id_path`) USING BTREE,
    INDEX `idx_emp_code_path` (`code_path`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '员工';

-- ----------------------------
-- Table structure for org_emp_bu
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_emp_bu`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)      DEFAULT NULL COMMENT 'sec_ou_id',
    `emp_id`             bigint(20)      DEFAULT NULL COMMENT '员工ID',
    `emp_bu_id`          bigint(20)      DEFAULT NULL COMMENT '员工绑定组织ID',
    `emp_bu_tree_id`     bigint(20)      DEFAULT NULL COMMENT '员工绑定的组织树ID',
    `emp_bu_tree_code`   varchar(40)     DEFAULT NULL COMMENT '员工绑定的组织树编号',
    `emp_bu_treedid`     bigint(20)      DEFAULT NULL COMMENT '员工绑定的组织树详情ID',
    `tenant_id`          bigint(20)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)         DEFAULT NULL COMMENT '锁版本',
    `data_source`        varchar(40)     DEFAULT NULL COMMENT '数据来源',
    `sync_status`        tinyint(1) NULL DEFAULT 0 COMMENT '同步的数据是否需要覆盖 false:忽略  true:覆盖',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '员工组织关系表';

-- ----------------------------
-- Table structure for org_ou
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_ou`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)      DEFAULT NULL COMMENT 'sec_ou_id',
    `ou_code`            varchar(32)     DEFAULT NULL COMMENT '公司编号',
    `ou_name`            varchar(32)     DEFAULT NULL COMMENT '公司名称',
    `ou_name2`           varchar(32)     DEFAULT NULL COMMENT '公司名称2',
    `ou_name3`           varchar(32)     DEFAULT NULL COMMENT '公司名称3',
    `ou_name4`           varchar(32)     DEFAULT NULL COMMENT '公司名称4',
    `ou_abbr`            varchar(32)     DEFAULT NULL COMMENT '公司简称',
    `abbr_alpha`         varchar(10)     DEFAULT NULL COMMENT '字母缩写',
    `ou_type`            varchar(32)     DEFAULT NULL COMMENT '公司类型 [UDC]ORG:OU_TYPE',
    `ou_type2`           varchar(32)     DEFAULT NULL COMMENT '公司类型2',
    `ou_type3`           varchar(32)     DEFAULT NULL COMMENT '公司类型3',
    `ou_status`          varchar(32)     DEFAULT NULL COMMENT '公司状态 [UDC]COM:STATUS_ACTIVEORNO',
    `ou_status2`         varchar(32)     DEFAULT NULL COMMENT '公司状态2',
    `ou_status3`         varchar(32)     DEFAULT NULL COMMENT '公司状态3',
    `bu_id`              varchar(32)     DEFAULT NULL COMMENT '经营单位ID',
    `bu_code`            varchar(32)     DEFAULT NULL COMMENT 'BU编号',
    `bu_name`            varchar(32)     DEFAULT NULL COMMENT 'BU名称',
    `pid`                bigint(20)      DEFAULT NULL COMMENT '上级ID',
    `legal_ou_id`        bigint(20)      DEFAULT NULL COMMENT '法人公司ID',
    `ou_path`            varchar(128)    DEFAULT NULL COMMENT '路径',
    `ou_curr`            varchar(10)     DEFAULT NULL COMMENT '本位币',
    `fin_cal_code`       varchar(128)    DEFAULT NULL COMMENT '财务日历编号',
    `fin_year`           int(20)         DEFAULT NULL COMMENT '财务年度',
    `fin_period`         int(20)         DEFAULT NULL COMMENT '财务期间',
    `addr_no`            varchar(32)     DEFAULT NULL COMMENT '地址号',
    `country`            varchar(32)     DEFAULT NULL COMMENT '国家 [UDC]COM:COUNTRY',
    `region`             varchar(32)     DEFAULT NULL COMMENT '区域 [UDC]ORG:OU_REGION',
    `sort_no`            int(11)         DEFAULT NULL COMMENT '排序号 用于相同层级的排序',
    `biz_code_cert`      varchar(32)     DEFAULT NULL COMMENT '组织机构代码证号',
    `ic_register_no`     varchar(32)     DEFAULT NULL COMMENT '工商登记号',
    `uni_cert_no`        varchar(32)     DEFAULT NULL COMMENT '统一信用代码',
    `repr_name`          varchar(64)     DEFAULT NULL COMMENT '法人代表',
    `tax_reg_no`         varchar(32)     DEFAULT NULL COMMENT '税务登记号',
    `taxpayer_type`      varchar(32)     DEFAULT NULL COMMENT '纳税人类型',
    `taxer_code`         varchar(32)     DEFAULT NULL COMMENT '纳税人识别号',
    `inv_type`           varchar(40)     DEFAULT NULL COMMENT '发票类型',
    `inv_title`          varchar(40)     DEFAULT NULL COMMENT '开票抬头',
    `inv_address`        varchar(40)     DEFAULT NULL COMMENT '开票地址',
    `inv_tel`            varchar(40)     DEFAULT NULL COMMENT '开票电话',
    `inv_pic_name`       varchar(40)     DEFAULT NULL COMMENT '开票联系人',
    `inv_pic_phone`      varchar(40)     DEFAULT NULL COMMENT '开票联系人电话',
    `inv_bank_name`      varchar(40)     DEFAULT NULL COMMENT '开票银行名称',
    `inv_bank_branch`    varchar(40)     DEFAULT NULL COMMENT '开票银行支行',
    `inv_bank_acc`       varchar(40)     DEFAULT NULL COMMENT '开票银行账号',
    `tax_rate_no`        varchar(40)     DEFAULT NULL COMMENT '税率编号',
    `tax_rate`           decimal(18, 4)  DEFAULT NULL COMMENT '税率',
    `cat`                varchar(40)     DEFAULT NULL COMMENT '类别码',
    `cat2`               varchar(40)     DEFAULT NULL COMMENT '类别码2',
    `cat3`               varchar(40)     DEFAULT NULL COMMENT '类别码3',
    `cat4`               varchar(40)     DEFAULT NULL COMMENT '类别码4',
    `cat5`               varchar(40)     DEFAULT NULL COMMENT '类别码5',
    `cat6`               varchar(40)     DEFAULT NULL COMMENT '类别码6',
    `cat7`               varchar(40)     DEFAULT NULL COMMENT '类别码7',
    `cat8`               varchar(40)     DEFAULT NULL COMMENT '类别码8',
    `cat9`               varchar(40)     DEFAULT NULL COMMENT '类别码9',
    `cat10`              varchar(40)     DEFAULT NULL COMMENT '类别码10',
    `cat11`              varchar(40)     DEFAULT NULL COMMENT '类别码11',
    `cat12`              varchar(40)     DEFAULT NULL COMMENT '类别码12',
    `cat13`              varchar(40)     DEFAULT NULL COMMENT '类别码13',
    `cat14`              varchar(40)     DEFAULT NULL COMMENT '类别码14',
    `cat15`              varchar(40)     DEFAULT NULL COMMENT '类别码15',
    `cat16`              varchar(40)     DEFAULT NULL COMMENT '类别码16',
    `cat17`              varchar(40)     DEFAULT NULL COMMENT '类别码17',
    `cat18`              varchar(40)     DEFAULT NULL COMMENT '类别码18',
    `cat19`              varchar(40)     DEFAULT NULL COMMENT '类别码19',
    `cat20`              varchar(40)     DEFAULT NULL COMMENT '类别码20',
    `tenant_id`          bigint(20)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)         DEFAULT NULL COMMENT '锁版本',
    `external_code`      varchar(32)     DEFAULT NULL COMMENT '核算编码',
    `data_source`        varchar(40)     DEFAULT NULL COMMENT '数据来源',
    `sync_status`        tinyint(1) NULL DEFAULT 0 COMMENT '同步的数据是否需要覆盖 false:忽略  true:覆盖',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '公司';

-- ----------------------------
-- Table structure for org_store
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_store`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `ou_id`              bigint(20)   DEFAULT NULL,
    `ou_code`            varchar(32)  DEFAULT NULL COMMENT '公司编号',
    `ou_name`            varchar(32)  DEFAULT NULL COMMENT '公司名称',
    `bu_id`              bigint(20)   DEFAULT NULL,
    `bu_code`            varchar(32)  DEFAULT NULL,
    `bu_name`            varchar(32)  DEFAULT NULL,
    `store_code`         varchar(32)  DEFAULT NULL,
    `store_name`         varchar(32)  DEFAULT NULL,
    `store_name2`        varchar(32)  DEFAULT NULL,
    `store_abbr`         varchar(32)  DEFAULT NULL,
    `store_type`         varchar(32)  DEFAULT NULL,
    `store_type2`        varchar(32)  DEFAULT NULL,
    `store_type3`        varchar(32)  DEFAULT NULL,
    `store_status`       varchar(32)  DEFAULT NULL,
    `store_status2`      varchar(32)  DEFAULT NULL,
    `store_status3`      varchar(32)  DEFAULT NULL,
    `addr_no`            varchar(32)  DEFAULT NULL COMMENT '地址号',
    `region`             varchar(32)  DEFAULT NULL COMMENT '区域',
    `sort_no`            int(11)      DEFAULT NULL,
    `pic_user_id`        bigint(20)   DEFAULT NULL,
    `pic_emp_id`         bigint(20)   DEFAULT NULL,
    `pic_name`           varchar(32)  DEFAULT NULL,
    `open_time_span`     varchar(32)  DEFAULT NULL,
    `open_time_span2`    varchar(32)  DEFAULT NULL,
    `start_date`         date         DEFAULT NULL,
    `end_date`           date         DEFAULT NULL,
    `pid`                bigint(20)   DEFAULT NULL COMMENT '上级ID',
    `store_path`         varchar(32)  DEFAULT NULL,
    `cat`                varchar(40)  DEFAULT NULL COMMENT '类别码',
    `cat2`               varchar(40)  DEFAULT NULL COMMENT '类别码2',
    `cat3`               varchar(40)  DEFAULT NULL COMMENT '类别码3',
    `cat4`               varchar(40)  DEFAULT NULL COMMENT '类别码4',
    `cat5`               varchar(40)  DEFAULT NULL COMMENT '类别码5',
    `cat6`               varchar(40)  DEFAULT NULL COMMENT '类别码6',
    `cat7`               varchar(40)  DEFAULT NULL COMMENT '类别码7',
    `cat8`               varchar(40)  DEFAULT NULL COMMENT '类别码8',
    `cat9`               varchar(40)  DEFAULT NULL COMMENT '类别码9',
    `cat10`              varchar(40)  DEFAULT NULL COMMENT '类别码10',
    `cat11`              varchar(40)  DEFAULT NULL COMMENT '类别码11',
    `cat12`              varchar(40)  DEFAULT NULL COMMENT '类别码12',
    `cat13`              varchar(40)  DEFAULT NULL COMMENT '类别码13',
    `cat14`              varchar(40)  DEFAULT NULL COMMENT '类别码14',
    `cat15`              varchar(40)  DEFAULT NULL COMMENT '类别码15',
    `cat16`              varchar(40)  DEFAULT NULL COMMENT '类别码16',
    `cat17`              varchar(40)  DEFAULT NULL COMMENT '类别码17',
    `cat18`              varchar(40)  DEFAULT NULL COMMENT '类别码18',
    `cat19`              varchar(40)  DEFAULT NULL COMMENT '类别码19',
    `cat20`              varchar(40)  DEFAULT NULL COMMENT '类别码20',
    `cat21`              varchar(40)  DEFAULT NULL COMMENT '类别码21',
    `cat22`              varchar(40)  DEFAULT NULL COMMENT '类别码22',
    `cat23`              varchar(40)  DEFAULT NULL COMMENT '类别码23',
    `cat24`              varchar(40)  DEFAULT NULL COMMENT '类别码24',
    `cat25`              varchar(40)  DEFAULT NULL COMMENT '类别码25',
    `cat26`              varchar(40)  DEFAULT NULL COMMENT '类别码26',
    `cat27`              varchar(40)  DEFAULT NULL COMMENT '类别码27',
    `cat28`              varchar(40)  DEFAULT NULL COMMENT '类别码28',
    `cat29`              varchar(40)  DEFAULT NULL COMMENT '类别码29',
    `cat30`              varchar(40)  DEFAULT NULL COMMENT '类别码30',
    `outer_code`         varchar(40)  DEFAULT NULL COMMENT '外部编码',
    `outer_code2`        varchar(40)  DEFAULT NULL COMMENT '外部编码2',
    `es1`                varchar(256) DEFAULT NULL COMMENT 'ES1',
    `es2`                varchar(256) DEFAULT NULL COMMENT 'ES2',
    `es3`                varchar(256) DEFAULT NULL COMMENT 'ES3',
    `es4`                varchar(256) DEFAULT NULL COMMENT 'ES4',
    `es5`                varchar(256) DEFAULT NULL COMMENT 'ES5',
    `es6`                varchar(256) DEFAULT NULL COMMENT 'ES6',
    `es7`                varchar(256) DEFAULT NULL COMMENT 'ES7',
    `es8`                varchar(256) DEFAULT NULL COMMENT 'ES8',
    `es9`                varchar(256) DEFAULT NULL COMMENT 'ES9',
    `es10`               varchar(256) DEFAULT NULL COMMENT 'ES10',
    `ed1`                date         DEFAULT NULL COMMENT 'ED1',
    `ed2`                date         DEFAULT NULL COMMENT 'ED2',
    `ed3`                date         DEFAULT NULL COMMENT 'ED3',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '门店表';

-- ----------------------------
-- Table structure for pri_main_price_alter
-- ----------------------------
CREATE TABLE IF NOT EXISTS `pri_main_price_alter`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `ou_id`              bigint(20)   DEFAULT NULL COMMENT 'OU公司ID',
    `bu_id`              bigint(20)   DEFAULT NULL COMMENT 'BU组织ID',
    `doc_no`             varchar(32)  DEFAULT NULL COMMENT '单据编号',
    `doc_type`           varchar(32)  DEFAULT NULL COMMENT '单据类型',
    `doc_type2`          varchar(32)  DEFAULT NULL COMMENT '单据类型2',
    `doc_type3`          varchar(32)  DEFAULT NULL COMMENT '单据类型3',
    `doc_status`         varchar(32)  DEFAULT NULL COMMENT '单据状态',
    `apply_emp_id`       bigint(20)   DEFAULT NULL COMMENT '申请人员工ID',
    `apply_date`         datetime     DEFAULT NULL COMMENT '申请日期',
    `apply_desc`         varchar(128) DEFAULT NULL COMMENT '申请描述',
    `appr_status`        varchar(32)  DEFAULT NULL COMMENT '审批状态',
    `appr_time`          datetime     DEFAULT NULL COMMENT '审批时间',
    `apply_user_id`      bigint(20)   DEFAULT NULL COMMENT '审批人ID',
    `apply_comment`      varchar(128) DEFAULT NULL COMMENT '审批意见',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `proc_inst_id`       varchar(255) DEFAULT NULL COMMENT '流程实例ID',
    `proc_inst_status`   varchar(255) DEFAULT NULL COMMENT '流程实例状态',
    `submit_time`        datetime(6)  DEFAULT NULL COMMENT '提交时间',
    `approved_time`      datetime(6)  DEFAULT NULL COMMENT '审批通过时间',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '主档价格变更单据表';

-- ----------------------------
-- Table structure for pri_main_price_alter_d_row
-- ----------------------------
CREATE TABLE IF NOT EXISTS `pri_main_price_alter_d_row`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)     DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)     DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)     DEFAULT NULL COMMENT 'sec_ou_id',
    `mas_id`             bigint(20)     DEFAULT NULL COMMENT '单据ID',
    `pri_main_price_id`  bigint(20)     DEFAULT NULL COMMENT '商品价格表ID',
    `ou_id`              bigint(20)     DEFAULT NULL COMMENT 'OU公司ID',
    `ou_code`            varchar(32)    DEFAULT NULL COMMENT 'OU公司编号',
    `ou_name`            varchar(32)    DEFAULT NULL COMMENT 'OU公司名称',
    `bu_id`              bigint(20)     DEFAULT NULL COMMENT 'BU组织ID',
    `bu_code`            varchar(32)    DEFAULT NULL COMMENT 'BU组织编号',
    `bu_name`            varchar(32)    DEFAULT NULL COMMENT 'BU组织名称',
    `item_id`            bigint(20)     DEFAULT NULL COMMENT '商品ID',
    `item_code`          varchar(32)    DEFAULT NULL COMMENT '品项编号',
    `item_code2`         varchar(32)    DEFAULT NULL COMMENT '第二编号',
    `item_code3`         varchar(32)    DEFAULT NULL COMMENT '第三编号',
    `item_name`          varchar(32)    DEFAULT NULL COMMENT '品项名称',
    `item_name2`         varchar(32)    DEFAULT NULL COMMENT '第二名称',
    `item_name3`         varchar(32)    DEFAULT NULL COMMENT '第三名称',
    `spu_id`             bigint(20)     DEFAULT NULL COMMENT 'SPU_ID',
    `spu_code`           varchar(40)    DEFAULT NULL COMMENT 'SPU_CODE',
    `spu_code2`          varchar(40)    DEFAULT NULL COMMENT 'SPU_CODE2',
    `spu_code3`          varchar(40)    DEFAULT NULL COMMENT 'SPU_CODE3',
    `spu_name`           varchar(40)    DEFAULT NULL COMMENT 'SPU_NAME',
    `spu_name2`          varchar(40)    DEFAULT NULL COMMENT 'SPU_NAME2',
    `spu_name3`          varchar(40)    DEFAULT NULL COMMENT 'SPU_NAME3',
    `spec`               varchar(40)    DEFAULT NULL COMMENT '一般规格，比如：食品净含量',
    `item_cate_code`     varchar(32)    DEFAULT NULL COMMENT '品类编码',
    `uom`                varchar(16)    DEFAULT NULL COMMENT '单位',
    `price_type`         varchar(32)    DEFAULT NULL COMMENT '价格类型',
    `tax_code`           varchar(32)    DEFAULT NULL COMMENT '税码',
    `tax_rate_no`        varchar(32)    DEFAULT NULL COMMENT '税率编号',
    `tax_rate`           decimal(20, 8) DEFAULT NULL COMMENT '税率',
    `install_flag`       int(11)        DEFAULT NULL COMMENT '是否含税',
    `price1`             decimal(20, 8) DEFAULT NULL COMMENT '市场价',
    `price2`             decimal(20, 8) DEFAULT NULL COMMENT 'B端指导价',
    `price3`             decimal(20, 8) DEFAULT NULL COMMENT 'C端零售价',
    `price4`             decimal(20, 8) DEFAULT NULL COMMENT 'B端毛利控制率',
    `price5`             decimal(20, 8) DEFAULT NULL COMMENT 'C端毛利控制率',
    `price6`             decimal(20, 8) DEFAULT NULL COMMENT 'B端毛利率',
    `price7`             decimal(20, 8) DEFAULT NULL COMMENT 'C端毛利率',
    `price8`             decimal(20, 8) DEFAULT NULL COMMENT '采购价',
    `price9`             decimal(20, 8) DEFAULT NULL COMMENT '价格9',
    `price10`            decimal(20, 8) DEFAULT NULL COMMENT '价格10',
    `curr_code`          varchar(32)    DEFAULT NULL COMMENT '币种',
    `valid_from`         datetime(6)    DEFAULT NULL COMMENT '生效时间',
    `valid_to`           datetime(6)    DEFAULT NULL COMMENT '失效时间',
    `price_status`       varchar(32)    DEFAULT NULL COMMENT '状态',
    `tenant_id`          bigint(20)     DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)   DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)     DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)   DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)    DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)     DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)   DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)    DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)        DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '主档价格变更单据明细表';

-- ----------------------------
-- Table structure for pri_main_price_row
-- ----------------------------
CREATE TABLE IF NOT EXISTS `pri_main_price_row`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)     DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)     DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)     DEFAULT NULL COMMENT 'sec_ou_id',
    `ou_id`              bigint(20)     DEFAULT NULL COMMENT 'OU公司ID',
    `ou_code`            varchar(32)    DEFAULT NULL COMMENT 'OU公司编号',
    `ou_name`            varchar(32)    DEFAULT NULL COMMENT 'OU公司名称',
    `bu_id`              bigint(20)     DEFAULT NULL COMMENT 'BU组织ID',
    `bu_code`            varchar(32)    DEFAULT NULL COMMENT 'BU组织编号',
    `bu_name`            varchar(32)    DEFAULT NULL COMMENT 'BU组织名称',
    `item_id`            bigint(20)     DEFAULT NULL COMMENT '商品ID',
    `item_code`          varchar(32)    DEFAULT NULL COMMENT '品项编号',
    `item_code2`         varchar(32)    DEFAULT NULL COMMENT '第二编号',
    `item_code3`         varchar(32)    DEFAULT NULL COMMENT '第三编号',
    `item_name`          varchar(32)    DEFAULT NULL COMMENT '品项名称',
    `item_name2`         varchar(32)    DEFAULT NULL COMMENT '第二名称',
    `item_name3`         varchar(32)    DEFAULT NULL COMMENT '第三名称',
    `spu_id`             bigint(20)     DEFAULT NULL COMMENT 'SPU_ID',
    `spu_code`           varchar(40)    DEFAULT NULL COMMENT 'SPU_CODE',
    `spu_code2`          varchar(40)    DEFAULT NULL COMMENT 'SPU_CODE2',
    `spu_code3`          varchar(40)    DEFAULT NULL COMMENT 'SPU_CODE3',
    `spu_name`           varchar(40)    DEFAULT NULL COMMENT 'SPU_NAME',
    `spu_name2`          varchar(40)    DEFAULT NULL COMMENT 'SPU_NAME2',
    `spu_name3`          varchar(40)    DEFAULT NULL COMMENT 'SPU_NAME3',
    `spec`               varchar(40)    DEFAULT NULL COMMENT '一般规格，比如：食品净含量',
    `item_cate_code`     varchar(32)    DEFAULT NULL COMMENT '品类编码',
    `uom`                varchar(16)    DEFAULT NULL COMMENT '单位',
    `price_type`         varchar(32)    DEFAULT NULL COMMENT '价格类型',
    `tax_code`           varchar(32)    DEFAULT NULL COMMENT '税码',
    `tax_rate_no`        varchar(32)    DEFAULT NULL COMMENT '税率编号',
    `tax_rate`           decimal(20, 8) DEFAULT NULL COMMENT '税率',
    `install_flag`       int(11)        DEFAULT NULL COMMENT '是否含税',
    `price1`             decimal(20, 8) DEFAULT NULL COMMENT '市场价',
    `price2`             decimal(20, 8) DEFAULT NULL COMMENT 'B端指导价',
    `price3`             decimal(20, 8) DEFAULT NULL COMMENT 'C端零售价',
    `price4`             decimal(20, 8) DEFAULT NULL COMMENT 'B端毛利控制率',
    `price5`             decimal(20, 8) DEFAULT NULL COMMENT 'C端毛利控制率',
    `price6`             decimal(20, 8) DEFAULT NULL COMMENT 'B端毛利率',
    `price7`             decimal(20, 8) DEFAULT NULL COMMENT 'C端毛利率',
    `price8`             decimal(20, 8) DEFAULT NULL COMMENT '采购价',
    `price9`             decimal(20, 8) DEFAULT NULL COMMENT '价格9',
    `price10`            decimal(20, 8) DEFAULT NULL COMMENT '价格10',
    `curr_code`          varchar(32)    DEFAULT NULL COMMENT '币种',
    `valid_from`         datetime(6)    DEFAULT NULL COMMENT '生效时间',
    `valid_to`           datetime(6)    DEFAULT NULL COMMENT '失效时间',
    `price_status`       varchar(32)    DEFAULT NULL COMMENT '状态',
    `tenant_id`          bigint(20)     DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)   DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)     DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)   DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)    DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)     DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)   DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)    DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)        DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '商品主档价格列表';

-- ----------------------------
-- Table structure for sys_dp
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_dp`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `domain_code`        varchar(64)  DEFAULT NULL COMMENT '领域编号',
    `domain_code_name`   varchar(64)  DEFAULT NULL COMMENT '领域名称',
    `table_code`         varchar(64)  DEFAULT NULL COMMENT '表名编码',
    `table_name`         varchar(64)  DEFAULT NULL COMMENT '表名中文',
    `table_desc`         varchar(64)  DEFAULT NULL COMMENT '表说明',
    `dp_type`            varchar(64)  DEFAULT NULL COMMENT '数据权限类型',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '数据权限开关';

-- ----------------------------
-- Table structure for sys_dp_role
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_dp_role`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)      DEFAULT NULL COMMENT 'sec_ou_id',
    `dp_role_code`       varchar(64)     DEFAULT NULL COMMENT '数据权限编码',
    `dp_role_name`       varchar(64)     DEFAULT NULL COMMENT '数据权限名称',
    `bu_tree_id`         bigint(20)      DEFAULT NULL COMMENT '组织树ID',
    `enable`             int(11)    NULL DEFAULT 0 COMMENT '是否启用',
    `tenant_id`          bigint(20)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)         DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '数据权限表';

-- ----------------------------
-- Table structure for sys_dp_role_power
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_dp_role_power`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `dp_role_code`       varchar(64)  DEFAULT NULL COMMENT '数据权限编码',
    `bu_tree_id`         bigint(20)   DEFAULT NULL COMMENT '组织树ID',
    `bu_id`              bigint(20)   DEFAULT NULL COMMENT '组织ID',
    `bu_tree_d_id`       bigint(20)   DEFAULT NULL COMMENT '组织树节点ID',
    `ac_type`            varchar(16)  DEFAULT NULL COMMENT '访问控制类型 [UDC]USR:AC_TYPE',
    `inherit_type`       varchar(16)  DEFAULT NULL COMMENT '继承类型 [UDC]USR:INHERIT_TYPE',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '数据权限明细表';

-- ----------------------------
-- Table structure for table_column_extensions
-- ----------------------------
CREATE TABLE IF NOT EXISTS `table_column_extensions`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `table_name`         varchar(40)  DEFAULT NULL COMMENT '被扩展表名称',
    `column_name`        varchar(40)  DEFAULT NULL COMMENT '被扩展列名',
    `row_id`             bigint(20)   DEFAULT NULL COMMENT '关联行ID',
    `row_code`           varchar(40)  DEFAULT NULL COMMENT '关联行编号',
    `sort_no`            int(11)      DEFAULT NULL COMMENT '排序号',
    `column_value`       varchar(255) DEFAULT NULL COMMENT '扩展列值',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '表字段扩展';

SET FOREIGN_KEY_CHECKS = 1;
