-- -- -- ----------------------------
-- -- -- Table structure for common_org_bu_treed
-- -- -- ----------------------------
create table  ITM_ITEM_SPU
(
       ID                NUMBER(20) not null 	/*编号*/,
       SPU_CODE          VARCHAR2(200),
       SPU_NAME          VARCHAR2(50) 	/*SPU名称*/,
       BRAND             VARCHAR2(20) 	/*品牌*/,
       UNIT              VARCHAR2(20) 	/*计量单位*/,
       CAT_ID            NUMBER(20) 	/*分类ID*/,
       DELETE_FLAG       NUMBER(1) 	    /*是否删除（0：未删除 1：删除）*/,
       TENANT_ID         NUMBER(20)     /*租户ID*/,
       REMARK	 		 NVARCHAR2(255) /*备注*/,
       CREATE_TIME       DATE 		    /*创建时间*/,
       CREATE_USER_ID    NUMBER(20)  	/*创建人ID*/,
       CREATOR 			 NVARCHAR2(255) /*创建人*/,
       MODIFY_TIME       DATE 		    /*修改时间*/,
       MODIFY_USER_ID    NUMBER(20) 	/*修改人ID*/,
       UPDATER 			 NVARCHAR2(255) /*修改人*/,
       AUDIT_DATA_VERSION NUMBER(11) 	/*锁版本*/,
       SEC_BU_ID         NUMBER(20) 	/*数据归属组织id 参考公共类字段做权限处理*/,
       SEC_USER_ID       NUMBER(20) 	/*数据归属雇员id 参考公共类字段做权限处理*/,
       SEC_OU_ID         NUMBER(20) 	/*数据归属公司id 参考公共类字段做权限处理*/
);
alter  table ITM_ITEM_SPU
       add constraint PK_ITM_ITEM_SPU_ID primary key (ID);
comment on table ITM_ITEM_SPU is 'SPU表';
comment on column ITM_ITEM_SPU.ID is '编号';
comment on column ITM_ITEM_SPU.SPU_NAME is 'SPU名称';
comment on column ITM_ITEM_SPU.BRAND is '品牌';
comment on column ITM_ITEM_SPU.UNIT is '计量单位';
comment on column ITM_ITEM_SPU.CAT_ID is '分类ID';
comment on column ITM_ITEM_SPU.DELETE_FLAG is '是否删除';
comment on column ITM_ITEM_SPU.REMARK is '备注';
comment on column ITM_ITEM_SPU.TENANT_ID is '租户ID';
comment on column ITM_ITEM_SPU.CREATE_TIME is '创建时间';
comment on column ITM_ITEM_SPU.CREATOR is '创建人';
comment on column ITM_ITEM_SPU.CREATE_USER_ID is '创建人ID';
comment on column ITM_ITEM_SPU.MODIFY_TIME is '修改时间';
comment on column ITM_ITEM_SPU.UPDATER is '创建日期';
comment on column ITM_ITEM_SPU.MODIFY_USER_ID is '数据级别';
comment on column ITM_ITEM_SPU.AUDIT_DATA_VERSION is '版本号';
comment on column ITM_ITEM_SPU.SEC_USER_ID is '归属雇员ID';
comment on column ITM_ITEM_SPU.SEC_OU_ID is '归属公司ID';

