-- -- -- ----------------------------
-- -- -- Table structure for ITM_ITEM_RELEVANCE
-- -- -- ----------------------------
create table  ITM_ITEM_RELEVANCE
(
       ID                NUMBER(20) not null 	/*ID*/,
       ITEM_ID           NUMBER(20) 	/*商品ID*/,
       CAT_ID            NUMBER(20) 	/*分类ID*/,
       DELETE_FLAG       NUMBER(1) 	    /*是否删除（0：未删除 1：删除）*/,
       TENANT_ID         NUMBER(20)     /*租户ID*/,
       REMARK	 		 NVARCHAR2(255) /*备注*/,
       CREATE_TIME       DATE 		    /*创建时间*/,
       CREATE_USER_ID    NUMBER(20)  	/*创建人ID*/,
       CREATOR 			 NVARCHAR2(255) /*创建人*/,
       MODIFY_TIME       DATE 		    /*修改时间*/,
       MODIFY_USER_ID    NUMBER(20) 	/*修改人ID*/,
       UPDATER 			 NVARCHAR2(255) /*修改人*/,
       AUDIT_DATA_VERSION NUMBER(11) 	/*锁版本*/,
       SEC_BU_ID         NUMBER(20) 	/*数据归属组织id 参考公共类字段做权限处理*/,
       SEC_USER_ID       NUMBER(20) 	/*数据归属雇员id 参考公共类字段做权限处理*/,
       SEC_OU_ID         NUMBER(20) 	/*数据归属公司id 参考公共类字段做权限处理*/
);
alter  table ITM_ITEM_RELEVANCE
       add constraint PK_ITM_ITEM_RELEVANCE_ID primary key (ID);
comment on table ITM_ITEM_RELEVANCE is '产品关联表';
comment on column ITM_ITEM_RELEVANCE.ID is 'ID';
comment on column ITM_ITEM_RELEVANCE.ITEM_ID is '商品ID';
comment on column ITM_ITEM_RELEVANCE.DELETE_FLAG is '是否删除（0：未删除，1：删除）';
comment on column ITM_ITEM_RELEVANCE.TENANT_ID is '租户ID';
comment on column ITM_ITEM_RELEVANCE.REMARK is '备注';
comment on column ITM_ITEM_RELEVANCE.CREATE_TIME is '创建时间';
comment on column ITM_ITEM_RELEVANCE.CREATE_USER_ID is '创建人ID';
comment on column ITM_ITEM_RELEVANCE.CREATOR is '创建人';
comment on column ITM_ITEM_RELEVANCE.MODIFY_TIME is '修改时间';
comment on column ITM_ITEM_RELEVANCE.MODIFY_USER_ID is '修改人ID';
comment on column ITM_ITEM_RELEVANCE.UPDATER is '修改人';
comment on column ITM_ITEM_RELEVANCE.AUDIT_DATA_VERSION is '锁版本';
comment on column ITM_ITEM_RELEVANCE.SEC_BU_ID is '数据归属组织id 参考公共类字段做权限处理';
comment on column ITM_ITEM_RELEVANCE.SEC_USER_ID is '数据归属雇员id 参考公共类字段做权限处理';
comment on column ITM_ITEM_RELEVANCE.SEC_OU_ID is '数据归属公司id 参考公共类字段做权限处理';
comment on column ITM_ITEM_RELEVANCE.CAT_ID is '分类ID';










