CREATE TABLE YST_SERVICESET_D (
  ID NUMBER(20) VISIBLE NOT NULL ,
  TENANT_ID NUMBER(20) VISIBLE ,
  REMARK NVARCHAR2(255) VISIBLE ,
  CREATE_USER_ID NUMBER(20) VISIBLE ,
  CREATOR NVARCHAR2(255) VISIBLE ,
  CREATE_TIME DATE VISIBLE ,
  MODIFY_USER_ID NUMBER(20) VISIBLE ,
  UPDATER NVARCHAR2(255) VISIBLE ,
  MODIFY_TIME DATE VISIBLE ,
  DELETE_FLAG NUMBER(11) VISIBLE NOT NULL ,
  OU_ID NUMBER(20) VISIBLE ,
  AUDIT_DATA_VERSION NUMBER(11) VISIBLE ,
  SEC_BU_ID NUMBER(20) VISIBLE ,
  SEC_USER_ID NUMBER(20) VISIBLE ,
  SEC_OU_ID NUMBER(20) VISIBLE ,
  MAS_CODE NVARCHAR2(40) VISIBLE ,
  MAS_ID NUMBER(20) VISIBLE ,
  FUNCTION NVARCHAR2(40) VISIBLE ,
  FUNCTIONUDC NVARCHAR2(40) VISIBLE ,
  FUNCTIONVALUE NVARCHAR2(40) VISIBLE ,
  FUNCTIONDESC NVARCHAR2(40) VISIBLE ,
  IS_DEFAULT NUMBER(11) VISIBLE ,
  MONTHS NVARCHAR2(40) VISIBLE ,
  DAYS NVARCHAR2(40) VISIBLE ,
  SCORE NVARCHAR2(40) VISIBLE ,
  OPERATION_TIME DATE VISIBLE ,
  PROPORTION NUMBER VISIBLE 
);
COMMENT ON COLUMN YST_SERVICESET_D.ID IS '记录唯一ID';
COMMENT ON COLUMN YST_SERVICESET_D.TENANT_ID IS '租户ID';
COMMENT ON COLUMN YST_SERVICESET_D.REMARK IS '备注';
COMMENT ON COLUMN YST_SERVICESET_D.CREATE_USER_ID IS '记录创建者ID';
COMMENT ON COLUMN YST_SERVICESET_D.CREATOR IS '记录创建者';
COMMENT ON COLUMN YST_SERVICESET_D.CREATE_TIME IS '记录创建时间';
COMMENT ON COLUMN YST_SERVICESET_D.MODIFY_USER_ID IS '记录最后更新者ID';
COMMENT ON COLUMN YST_SERVICESET_D.UPDATER IS '记录最后更新者';
COMMENT ON COLUMN YST_SERVICESET_D.MODIFY_TIME IS '记录最后更新时间';
COMMENT ON COLUMN YST_SERVICESET_D.DELETE_FLAG IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN YST_SERVICESET_D.OU_ID IS '公司id';
COMMENT ON COLUMN YST_SERVICESET_D.AUDIT_DATA_VERSION IS '锁版本';
COMMENT ON COLUMN YST_SERVICESET_D.SEC_BU_ID IS 'sec_bu_id';
COMMENT ON COLUMN YST_SERVICESET_D.SEC_USER_ID IS 'sec_user_id';
COMMENT ON COLUMN YST_SERVICESET_D.SEC_OU_ID IS 'sec_ou_id';
COMMENT ON COLUMN YST_SERVICESET_D.MAS_CODE IS '明细code';
COMMENT ON COLUMN YST_SERVICESET_D.MAS_ID IS '明细id';
COMMENT ON COLUMN YST_SERVICESET_D.FUNCTION IS '功能';
COMMENT ON COLUMN YST_SERVICESET_D.FUNCTIONUDC IS '功能udc';
COMMENT ON COLUMN YST_SERVICESET_D.FUNCTIONVALUE IS '功能设置值';
COMMENT ON COLUMN YST_SERVICESET_D.FUNCTIONDESC IS '功能值描述';
COMMENT ON COLUMN YST_SERVICESET_D.IS_DEFAULT IS '是否是全部公司默认：1是，0否';
COMMENT ON COLUMN YST_SERVICESET_D.MONTHS IS '月';
COMMENT ON COLUMN YST_SERVICESET_D.DAYS IS '日';
COMMENT ON COLUMN YST_SERVICESET_D.SCORE IS '分值';
COMMENT ON COLUMN YST_SERVICESET_D.OPERATION_TIME IS '操作时间';
COMMENT ON COLUMN YST_SERVICESET_D.PROPORTION IS '比例';
COMMENT ON TABLE YST_SERVICESET_D IS '设置表明细';

CREATE TABLE YST_SERVICESET (
  ID NUMBER(20) VISIBLE NOT NULL ,
  TENANT_ID NUMBER(20) VISIBLE ,
  REMARK NVARCHAR2(255) VISIBLE ,
  CREATE_USER_ID NUMBER(20) VISIBLE ,
  CREATOR NVARCHAR2(255) VISIBLE ,
  CREATE_TIME DATE VISIBLE ,
  MODIFY_USER_ID NUMBER(20) VISIBLE ,
  UPDATER NVARCHAR2(255) VISIBLE ,
  MODIFY_TIME DATE VISIBLE ,
  DELETE_FLAG NUMBER(11) VISIBLE NOT NULL ,
  AUDIT_DATA_VERSION NUMBER(11) VISIBLE ,
  SEC_BU_ID NUMBER(20) VISIBLE ,
  SEC_USER_ID NUMBER(20) VISIBLE ,
  SEC_OU_ID NUMBER(20) VISIBLE ,
  OU_ID NUMBER(20) VISIBLE ,
  PROC_INST_ID NVARCHAR2(255) VISIBLE ,
  PROC_INST_STATUS NVARCHAR2(255) VISIBLE ,
  SUBMIT_TIME DATE VISIBLE ,
  APPROVED_TIME DATE VISIBLE ,
  MORE_PROPORTION NUMBER VISIBLE ,
  LESS_PROPORTION NUMBER VISIBLE ,
  ITEM_PROPORTION NUMBER VISIBLE ,
  SUPP_SUMMARY NVARCHAR2(40) VISIBLE ,
  TIME_SUMMARY NVARCHAR2(40) VISIBLE ,
  PURTIME_SUMMARY NVARCHAR2(40) VISIBLE ,
  ALL_OU NUMBER(11) VISIBLE 
)
TABLESPACE USERS
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN YST_SERVICESET.ID IS '记录唯一ID';
COMMENT ON COLUMN YST_SERVICESET.TENANT_ID IS '租户ID';
COMMENT ON COLUMN YST_SERVICESET.REMARK IS '备注';
COMMENT ON COLUMN YST_SERVICESET.CREATE_USER_ID IS '记录创建者ID';
COMMENT ON COLUMN YST_SERVICESET.CREATOR IS '记录创建者';
COMMENT ON COLUMN YST_SERVICESET.CREATE_TIME IS '记录创建时间';
COMMENT ON COLUMN YST_SERVICESET.MODIFY_USER_ID IS '记录最后更新者ID';
COMMENT ON COLUMN YST_SERVICESET.UPDATER IS '记录最后更新者';
COMMENT ON COLUMN YST_SERVICESET.MODIFY_TIME IS '记录最后更新时间';
COMMENT ON COLUMN YST_SERVICESET.DELETE_FLAG IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN YST_SERVICESET.AUDIT_DATA_VERSION IS '锁版本';
COMMENT ON COLUMN YST_SERVICESET.SEC_BU_ID IS 'sec_bu_id';
COMMENT ON COLUMN YST_SERVICESET.SEC_USER_ID IS 'sec_user_id';
COMMENT ON COLUMN YST_SERVICESET.SEC_OU_ID IS 'sec_ou_id';
COMMENT ON COLUMN YST_SERVICESET.OU_ID IS '公司ID';
COMMENT ON COLUMN YST_SERVICESET.PROC_INST_ID IS '流程实例ID';
COMMENT ON COLUMN YST_SERVICESET.PROC_INST_STATUS IS '流程实例状态';
COMMENT ON COLUMN YST_SERVICESET.SUBMIT_TIME IS '提交时间';
COMMENT ON COLUMN YST_SERVICESET.APPROVED_TIME IS '审批通过时间';
COMMENT ON COLUMN YST_SERVICESET.MORE_PROPORTION IS '超量比例';
COMMENT ON COLUMN YST_SERVICESET.LESS_PROPORTION IS '欠量比例';
COMMENT ON COLUMN YST_SERVICESET.ITEM_PROPORTION IS '比例';
COMMENT ON COLUMN YST_SERVICESET.SUPP_SUMMARY IS '按照供应商汇总';
COMMENT ON COLUMN YST_SERVICESET.TIME_SUMMARY IS '按照时间汇总';
COMMENT ON COLUMN YST_SERVICESET.PURTIME_SUMMARY IS '按照时间汇总';
COMMENT ON COLUMN YST_SERVICESET.ALL_OU IS '是否是全部公司默认：1是，0否';

