CREATE TABLE YST_SUPP_C13 (
  ID NUMBER(20) VISIBLE NOT NULL ,
  TENANT_ID NUMBER(20) VISIBLE ,
  REMARK NVARCHAR2(255) VISIBLE ,
  CREATE_USER_ID NUMBER(20) VISIBLE ,
  CREATOR NVARCHAR2(255) VISIBLE ,
  CREATE_TIME DATE VISIBLE ,
  MODIFY_USER_ID NUMBER(20) VISIBLE ,
  UPDATER NVARCHAR2(255) VISIBLE ,
  MODIFY_TIME DATE VISIBLE ,
  DELETE_FLAG NUMBER(11) VISIBLE NOT NULL ,
  AUDIT_DATA_VERSION NUMBER(11) VISIBLE ,
  SEC_BU_ID NUMBER(20) VISIBLE ,
  SEC_USER_ID NUMBER(20) VISIBLE ,
  SEC_OU_ID NUMBER(20) VISIBLE ,
  OU_ID NUMBER(20) VISIBLE ,
  SUPP_ID NUMBER(20) VISIBLE ,
  C3_ID NUMBER(20) VISIBLE ,
  SUPP_CODE NVARCHAR2(40) VISIBLE ,
  ITEM_CATE_CODE NVARCHAR2(32) VISIBLE ,
  MORE_PROPORTION NUMBER VISIBLE ,
  LESS_PROPORTION NUMBER VISIBLE ,
  ITEM_PROPORTION NUMBER VISIBLE ,
  LESS_NUMBER NVARCHAR2(40) VISIBLE ,
  C1_CODE VARCHAR2(40 BYTE) VISIBLE ,
  C2_CODE VARCHAR2(40 BYTE) VISIBLE ,
  C3_CODE VARCHAR2(40 BYTE) VISIBLE
);
COMMENT ON COLUMN YST_SUPP_C13.ID IS '记录唯一ID';
COMMENT ON COLUMN YST_SUPP_C13.TENANT_ID IS '租户ID';
COMMENT ON COLUMN YST_SUPP_C13.REMARK IS '备注';
COMMENT ON COLUMN YST_SUPP_C13.CREATE_USER_ID IS '记录创建者ID';
COMMENT ON COLUMN YST_SUPP_C13.CREATOR IS '记录创建者';
COMMENT ON COLUMN YST_SUPP_C13.CREATE_TIME IS '记录创建时间';
COMMENT ON COLUMN YST_SUPP_C13.MODIFY_USER_ID IS '记录最后更新者ID';
COMMENT ON COLUMN YST_SUPP_C13.UPDATER IS '记录最后更新者';
COMMENT ON COLUMN YST_SUPP_C13.MODIFY_TIME IS '记录最后更新时间';
COMMENT ON COLUMN YST_SUPP_C13.DELETE_FLAG IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN YST_SUPP_C13.AUDIT_DATA_VERSION IS '锁版本';
COMMENT ON COLUMN YST_SUPP_C13.SEC_BU_ID IS 'sec_bu_id';
COMMENT ON COLUMN YST_SUPP_C13.SEC_USER_ID IS 'sec_user_id';
COMMENT ON COLUMN YST_SUPP_C13.SEC_OU_ID IS 'sec_ou_id';
COMMENT ON COLUMN YST_SUPP_C13.OU_ID IS '公司ID';
COMMENT ON COLUMN YST_SUPP_C13.SUPP_ID IS '供应商ID';
COMMENT ON COLUMN YST_SUPP_C13.C3_ID IS '品项小类ID';
COMMENT ON COLUMN YST_SUPP_C13.SUPP_CODE IS '供应商SRM编码';
COMMENT ON COLUMN YST_SUPP_C13.ITEM_CATE_CODE IS '品类编码';
COMMENT ON COLUMN YST_SUPP_C13.MORE_PROPORTION IS '超量比例';
COMMENT ON COLUMN YST_SUPP_C13.LESS_PROPORTION IS '欠量比例';
COMMENT ON COLUMN YST_SUPP_C13.ITEM_PROPORTION IS '比例';
COMMENT ON COLUMN YST_SUPP_C13.LESS_NUMBER IS '可欠量';
COMMENT ON COLUMN YST_SUPP_C13.C1_CODE IS '大类';
COMMENT ON COLUMN YST_SUPP_C13.C2_CODE IS '中类';
COMMENT ON COLUMN YST_SUPP_C13.C3_CODE IS '小类';
COMMENT ON TABLE YST_SUPP_C13 IS '品类供货目录';

CREATE TABLE YST_SUPP_ITEM (
  ID NUMBER(20) VISIBLE NOT NULL ,
  TENANT_ID NUMBER(20) VISIBLE ,
  REMARK NVARCHAR2(255) VISIBLE ,
  CREATE_USER_ID NUMBER(20) VISIBLE ,
  CREATOR NVARCHAR2(255) VISIBLE ,
  CREATE_TIME DATE VISIBLE ,
  MODIFY_USER_ID NUMBER(20) VISIBLE ,
  UPDATER NVARCHAR2(255) VISIBLE ,
  MODIFY_TIME DATE VISIBLE ,
  DELETE_FLAG NUMBER(11) VISIBLE NOT NULL ,
  AUDIT_DATA_VERSION NUMBER(11) VISIBLE ,
  SEC_BU_ID NUMBER(20) VISIBLE ,
  SEC_USER_ID NUMBER(20) VISIBLE ,
  SEC_OU_ID NUMBER(20) VISIBLE ,
  OU_ID NUMBER(20) VISIBLE ,
  SUPP_ID NUMBER(20) VISIBLE ,
  ITEM_ID NUMBER(20) VISIBLE ,
  SUPP_SCORE NUMBER VISIBLE ,
  SUPP_CODE NVARCHAR2(40) VISIBLE ,
  ITEM_CODE NVARCHAR2(100) VISIBLE NOT NULL ,
  ITEM_CODE2 NVARCHAR2(40) VISIBLE ,
  ITEM_CODE3 NVARCHAR2(40) VISIBLE ,
  ITEM_NAME NVARCHAR2(100) VISIBLE ,
  C3_ID NUMBER(20) VISIBLE ,
  ITEM_CATE_CODE NVARCHAR2(32) VISIBLE ,
  MORE_PROPORTION NUMBER VISIBLE ,
  LESS_PROPORTION NUMBER VISIBLE ,
  ITEM_PROPORTION NUMBER VISIBLE ,
  MORE_NUMBER NVARCHAR2(6) VISIBLE ,
  LESS_NUMBER NVARCHAR2(40) VISIBLE 
);

COMMENT ON COLUMN YST_SUPP_ITEM.ID IS '记录唯一ID';
COMMENT ON COLUMN YST_SUPP_ITEM.TENANT_ID IS '租户ID';
COMMENT ON COLUMN YST_SUPP_ITEM.REMARK IS '备注';
COMMENT ON COLUMN YST_SUPP_ITEM.CREATE_USER_ID IS '记录创建者ID';
COMMENT ON COLUMN YST_SUPP_ITEM.CREATOR IS '记录创建者';
COMMENT ON COLUMN YST_SUPP_ITEM.CREATE_TIME IS '记录创建时间';
COMMENT ON COLUMN YST_SUPP_ITEM.MODIFY_USER_ID IS '记录最后更新者ID';
COMMENT ON COLUMN YST_SUPP_ITEM.UPDATER IS '记录最后更新者';
COMMENT ON COLUMN YST_SUPP_ITEM.MODIFY_TIME IS '记录最后更新时间';
COMMENT ON COLUMN YST_SUPP_ITEM.DELETE_FLAG IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN YST_SUPP_ITEM.AUDIT_DATA_VERSION IS '锁版本';
COMMENT ON COLUMN YST_SUPP_ITEM.SEC_BU_ID IS 'sec_bu_id';
COMMENT ON COLUMN YST_SUPP_ITEM.SEC_USER_ID IS 'sec_user_id';
COMMENT ON COLUMN YST_SUPP_ITEM.SEC_OU_ID IS 'sec_ou_id';
COMMENT ON COLUMN YST_SUPP_ITEM.OU_ID IS '公司ID';
COMMENT ON COLUMN YST_SUPP_ITEM.SUPP_ID IS '供应商ID';
COMMENT ON COLUMN YST_SUPP_ITEM.ITEM_ID IS '品项ID';
COMMENT ON COLUMN YST_SUPP_ITEM.SUPP_SCORE IS '供应商评分';
COMMENT ON COLUMN YST_SUPP_ITEM.SUPP_CODE IS '供应商SRM编码';
COMMENT ON COLUMN YST_SUPP_ITEM.ITEM_CODE IS '品项编号';
COMMENT ON COLUMN YST_SUPP_ITEM.ITEM_CODE2 IS '短项目号';
COMMENT ON COLUMN YST_SUPP_ITEM.ITEM_CODE3 IS '项目号';
COMMENT ON COLUMN YST_SUPP_ITEM.ITEM_NAME IS '品项名称';
COMMENT ON COLUMN YST_SUPP_ITEM.ITEM_CATE_CODE IS '品类编码';
COMMENT ON COLUMN YST_SUPP_ITEM.MORE_PROPORTION IS '超量比例';
COMMENT ON COLUMN YST_SUPP_ITEM.LESS_PROPORTION IS '欠量比例';
COMMENT ON COLUMN YST_SUPP_ITEM.ITEM_PROPORTION IS '比例';
COMMENT ON COLUMN YST_SUPP_ITEM.MORE_NUMBER IS '可超量';
COMMENT ON COLUMN YST_SUPP_ITEM.LESS_NUMBER IS '可欠量';
COMMENT ON TABLE YST_SUPP_ITEM IS '品项供货目录';

