create table YST_ITEM_PROPORTION
(
    ID                 NUMBER(20) not null,
    TENANT_ID          NUMBER(20),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(20),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(20),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(11) not null,
    AUDIT_DATA_VERSION NUMBER(11),
    SEC_BU_ID          NUMBER(20),
    SEC_USER_ID        NUMBER(20),
    SEC_OU_ID          NUMBER(20),
    OU_ID              NUMBER(20),
    SUPP_ID            NUMBER(20),
    ITEM_ID            NUMBER(20),
    SUPP_SCORE         NUMBER,
    SUPP_CODE          NVARCHAR2(40),
    ITEM_CODE          NVARCHAR2(100),
    ITEM_CODE2         NVARCHAR2(40),
    ITEM_NAME          NVARCHAR2(100),
    C3_ID              NUMBER(20),
    ITEM_CATE_CODE     NVARCHAR2(32),
    ITEM_CODE3         NVARCHAR2(40),
    MORE_PROPORTION    NUMBER,
    LESS_PROPORTION    NUMBER,
    ITEM_PROPORTION    NUMBER,
    MORE_NUMBER        NVARCHAR2(6),
    LESS_NUMBER        NVARCHAR2(40)
)
    /

comment on table YST_ITEM_PROPORTION is '比例表'
/

comment on column YST_ITEM_PROPORTION.ID is '记录唯一ID'
/

comment on column YST_ITEM_PROPORTION.TENANT_ID is '租户ID'
/

comment on column YST_ITEM_PROPORTION.REMARK is '备注'
/

comment on column YST_ITEM_PROPORTION.CREATE_USER_ID is '记录创建者ID'
/

comment on column YST_ITEM_PROPORTION.CREATOR is '记录创建者'
/

comment on column YST_ITEM_PROPORTION.CREATE_TIME is '记录创建时间'
/

comment on column YST_ITEM_PROPORTION.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column YST_ITEM_PROPORTION.UPDATER is '记录最后更新者'
/

comment on column YST_ITEM_PROPORTION.MODIFY_TIME is '记录最后更新时间'
/

comment on column YST_ITEM_PROPORTION.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column YST_ITEM_PROPORTION.AUDIT_DATA_VERSION is '锁版本'
/

comment on column YST_ITEM_PROPORTION.SEC_BU_ID is 'sec_bu_id'
/

comment on column YST_ITEM_PROPORTION.SEC_USER_ID is 'sec_user_id'
/

comment on column YST_ITEM_PROPORTION.SEC_OU_ID is 'sec_ou_id'
/

comment on column YST_ITEM_PROPORTION.OU_ID is '公司ID'
/

comment on column YST_ITEM_PROPORTION.SUPP_ID is '供应商ID'
/

comment on column YST_ITEM_PROPORTION.ITEM_ID is '品项ID'
/

comment on column YST_ITEM_PROPORTION.SUPP_SCORE is '供应商评分'
/

comment on column YST_ITEM_PROPORTION.SUPP_CODE is '供应商SRM编码'
/

comment on column YST_ITEM_PROPORTION.ITEM_CODE is '品项编号'
/

comment on column YST_ITEM_PROPORTION.ITEM_CODE2 is '第二编号'
/

comment on column YST_ITEM_PROPORTION.ITEM_NAME is '品项名称'
/

comment on column YST_ITEM_PROPORTION.ITEM_CATE_CODE is '品类编码'
/

comment on column YST_ITEM_PROPORTION.ITEM_CODE3 is '项目号'
/

comment on column YST_ITEM_PROPORTION.MORE_PROPORTION is '超量比例'
/

comment on column YST_ITEM_PROPORTION.LESS_PROPORTION is '欠量比例'
/

comment on column YST_ITEM_PROPORTION.ITEM_PROPORTION is '比例'
/

comment on column YST_ITEM_PROPORTION.MORE_NUMBER is '可超量'
/

comment on column YST_ITEM_PROPORTION.LESS_NUMBER is '可欠量'
/

