
ALTER TABLE org_addr_address ADD (property_type NVARCHAR2(40) ,property_vale NVARCHAR2(40) ,
users_type VARCHAR2(40) );
COMMENT ON COLUMN org_addr_address.property_type IS '对账允查';
COMMENT ON COLUMN org_addr_address.property_vale IS '对账允差值';
COMMENT ON COLUMN org_addr_address.users_type IS '联系人类型';

-- YST_ADDR_HISTORY definition

CREATE TABLE "YST_ADDR_HISTORY" 
   (	"ID" NUMBER(20,0) NOT NULL ENABLE, 
	"OU_ID" NUMBER(20,0), 
	"BU_ID" NUMBER(20,0), 
	"BU_PATH" VARCHAR2(100), 
	"OWNER_ADDR_NO" NUMBER(11,0), 
	"TENANT_ID" NUMBER(20,0), 
	"REMARK" VARCHAR2(255), 
	"CREATE_USER_ID" NUMBER(20,0), 
	"CREATOR" VARCHAR2(255), 
	"CREATE_TIME" DATE, 
	"MODIFY_USER_ID" NUMBER(20,0), 
	"UPDATER" VARCHAR2(255), 
	"MODIFY_TIME" DATE, 
	"DELETE_FLAG" NUMBER(11,0) NOT NULL ENABLE, 
	"AUDIT_DATA_VERSION" NUMBER(11,0), 
	"SEC_BU_ID" NUMBER(20,0), 
	"SEC_USER_ID" NUMBER(20,0), 
	"SEC_OU_ID" NUMBER(20,0), 
	"ADDR_NO" VARCHAR2(40), 
	"OPER_TYPE" VARCHAR2(40), 
	"OPER_COMMENT" VARCHAR2(40), 
	"SRC_ID" NUMBER(20,0), 
	"SRC_D_ID" NUMBER(20,0), 
	"SRC_CLS" VARCHAR2(40)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;

COMMENT ON COLUMN YST_ADDR_HISTORY.ID IS '记录唯一ID';
COMMENT ON COLUMN YST_ADDR_HISTORY.TENANT_ID IS '租户ID';
COMMENT ON COLUMN YST_ADDR_HISTORY.REMARK IS '备注';
COMMENT ON COLUMN YST_ADDR_HISTORY.CREATE_USER_ID IS '记录创建者ID';
COMMENT ON COLUMN YST_ADDR_HISTORY.CREATOR IS '记录创建者';
COMMENT ON COLUMN YST_ADDR_HISTORY.CREATE_TIME IS '记录创建时间';
COMMENT ON COLUMN YST_ADDR_HISTORY.MODIFY_USER_ID IS '记录最后更新者ID';
COMMENT ON COLUMN YST_ADDR_HISTORY.UPDATER IS '记录最后更新者';
COMMENT ON COLUMN YST_ADDR_HISTORY.MODIFY_TIME IS '记录最后更新时间';
COMMENT ON COLUMN YST_ADDR_HISTORY.DELETE_FLAG IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN YST_ADDR_HISTORY.AUDIT_DATA_VERSION IS '锁版本';
COMMENT ON COLUMN YST_ADDR_HISTORY.SEC_BU_ID IS 'sec_bu_id';
COMMENT ON COLUMN YST_ADDR_HISTORY.SEC_USER_ID IS 'sec_user_id';
COMMENT ON COLUMN YST_ADDR_HISTORY.SEC_OU_ID IS 'sec_ou_id';
COMMENT ON COLUMN YST_ADDR_HISTORY.ADDR_NO IS '地址号';
COMMENT ON COLUMN YST_ADDR_HISTORY.OPER_TYPE IS '操作类型';
COMMENT ON COLUMN YST_ADDR_HISTORY.OPER_COMMENT IS '操作说明';
COMMENT ON COLUMN YST_ADDR_HISTORY.SRC_ID IS '来源ID';
COMMENT ON COLUMN YST_ADDR_HISTORY.SRC_D_ID IS '来源明细ID';
COMMENT ON COLUMN YST_ADDR_HISTORY.SRC_CLS IS '来源类型';