package com.elitesland.yst.comm.consumer.service;

import com.elitesland.yst.comm.consumer.dto.ComCurrRpcDTO;
import com.elitesland.yst.comm.consumer.param.ComCurrRpcDtoParam;

import java.util.List;

/**
 * 对外服务提供者
 * @author Chris
 * @date 2021-04-02
 */
public interface ComCurrRpcService {

    /**
     * 获取币种信息列表，该接口一般应用与如下场景
     * 1. 第三方通过code获取一些基本信息，用于后端组装数据
     * 2. 检查数据是否存在，存在则会返回数据，不存在则不会返回数据
     *
     * 如果传入的查询参数均为空，则不返回任何数据，防止获取全部数据
     *
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 查询条件，每个条件使用 and 关联
     * @return dto
     */
    List<ComCurrRpcDTO> findRpcDtoByParam(ComCurrRpcDtoParam param);
}
