package com.elitesland.yst.comm.service;


import com.elitesland.yst.comm.vo.ComCurrRateVO;
import com.elitesland.yst.comm.vo.param.ComCurrRateQueryParamVO;
import com.elitesland.yst.common.base.PagingVO;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 汇率
 * </p>
 *
 * @author ssy
 * @date 2020/7/3
 */
public interface ComCurrRateService{
    /**
     * 货币汇率转换
     * @param param
     * @return 汇率
     */
    Double findRatio(ComCurrRateQueryParamVO param);


    /**
     * 检索
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<ComCurrRateVO> search(ComCurrRateQueryParamVO queryParam);

    /**
     * 根据关键字段，返回对应的
     * @param Id ID
     * @return 对象
     */
    Optional<ComCurrRateVO> findIdOne(Long Id);
    /**
     * 创建
     *
     * @param  objDo 对象
     */
    Long createOne(ComCurrRateVO objDo);
    /**
     * 根据关键字段，返回对应的
     * @param idList ID集合
     * @return 对象
     */
    List<ComCurrRateVO> findIdBatch(List<Long> idList);
    /**
     * 创建
     *
     * @param List 对象集合
     */
    List<Long> createBatch(List<ComCurrRateVO> List);
    /**
     * 更新
     *
     * @param  objDo 对象
     */
    void update(ComCurrRateVO objDo) ;

    /**
     * 删除
     *
     * @param Id 对象
     */
    void deleteOne(Long Id);
    /**
     * 删除
     *
     * @param idList 对象集合
     */
    void deleteBatch(List<Long> idList);


    /**
     * 更新删除标识
     *
     * @param id id
     */
    void updateDeleteFlag(Long id);
}
