package com.elitesland.yst.comm.service;

import com.elitesland.yst.comm.vo.resp.ComCurrRespVO;
import com.elitesland.yst.comm.vo.save.ComCurrSaveVO;

import java.util.List;
import java.util.Optional;

/**
 * @author Chris
 * @date 2021-03-25
 */
public interface ComCurrService extends ComCurrProviderService {
    Optional<ComCurrRespVO> findCodeOne(String Code);

    Optional<ComCurrRespVO> findIdOne(Long Id);

    /**
     * 创建
     *
     * @param objVo
     */
    Long createOne(ComCurrSaveVO objVo);

    /**
     * 创建
     *
     * @param List 对象集合
     */
    List<Long> createBatch(List<ComCurrSaveVO> List);

    /**
     * 更新
     *
     * @param objDo 对象
     */
    void update(ComCurrSaveVO objDo);

    /**
     * 删除
     *
     * @param Id 对象
     */
    void deleteOne(Long Id);

    /**
     * 删除
     *
     * @param idList 对象集合
     */
    void deleteBatch(List<Long> idList);


    /**
     * 更新删除标识
     *
     * @param id id
     */
    void updateDeleteFlag(Long id);
}
