package com.elitesland.yst.comm.vo.resp;

import com.elitesland.yst.common.annotation.SysCode;
import com.elitesland.yst.common.base.BaseViewModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "税率", description = "税率")
public class ComTaxRateVO extends BaseViewModel implements Serializable {

    private static final long serialVersionUID = -7197577625040996865L;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率说明")
    private String taxRateDesc;

    @ApiModelProperty("生效日期")
    private LocalDateTime validFrom;

    @ApiModelProperty("失效日期")
    private LocalDateTime validTo;

    @ApiModelProperty("税率值")
    private Double taxRateValue;

    @ApiModelProperty("税率索引")
    @SysCode(sys = "COM", mod = "TAX_RATE_INDEX")
    private String taxRateIndex;

    @ApiModelProperty("税率索引 名称")
    String taxRateIndexName;

}
