package com.elitesland.yst.comm.vo.save;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author shihao.ma
 * @since 2020/7/3
 */
@Data
@Accessors(chain = false)
public class ComPaymentTermSaveVO implements Serializable {

    private static final long serialVersionUID = 5671989233522408473L;

    @ApiModelProperty("代码")
    private String ptCode;

    @ApiModelProperty("名称")
    private String ptName;

    @ApiModelProperty("天数")
    private Integer days;

    @ApiModelProperty("基于日期类型")
    private String baseDayType;

    @ApiModelProperty("日期计算方式 是否含工作日")
    private String dayCalcMethod;

    @ApiModelProperty("生效日期")
    private LocalDateTime validFrom;

    @ApiModelProperty("失效日期")
    private LocalDateTime validTo;

    @ApiModelProperty("是否有效")
    private Integer enableFlag;

    @ApiModelProperty("对账报账编码")
    private String accountCode;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("账号唯一ID")
    private Long id;

    @ApiModelProperty(value = "租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long tenantId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    private LocalDateTime createTime ;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;

    private LocalDateTime modifyTime;

    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;

    @ApiModelProperty(value = "版本")
    private Integer auditDataVersion;
    /**
     * 操作人姓名
     */
    @ApiModelProperty("操作人姓名")
    private String operUserName;
}
