package com.elitesland.yst.system.develop.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 数据源表(SysDatabaseSource)实体类
 *
 * @author roman.zhang
 * @since 2022-02-16 16:42:45
 */

@Data
@ApiModel(value = "sys_database_source", description = "数据源表")
public class SysDatabaseSourceVO implements Serializable {
    private static final long serialVersionUID = 242979711356432437L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 数据源名称
     */
    @ApiModelProperty("数据源名称-即数据库Schema的名称")
    private String dbsName;
    /**
     * 驱动类
     */
    @ApiModelProperty("驱动类")
    private String dbsDriverClass;
    /**
     * 连接地址
     */
    @ApiModelProperty("连接地址-包含驱动类型，ip,端口")
    private String dbsUrl;
    /**
     * 驱动类
     */
    @ApiModelProperty("驱动类")
    private String dbsUsername;
    /**
     * 驱动类
     */
    @ApiModelProperty("驱动类")
    private String dbsPassword;
    /**
     * 租户ID
     */
    @ApiModelProperty("租户ID")
    private Long tenantId;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    /**
     * 记录创建者
     */
    @ApiModelProperty("记录创建者")
    private String creator;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;
    /**
     * 记录最后更新者
     */
    @ApiModelProperty("记录最后更新者")
    private String updater;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 锁版本
     */
    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;
    /**
     * sec_bu_id
     */
    @ApiModelProperty("sec_bu_id")
    private Long secBuId;
    /**
     * sec_user_id
     */
    @ApiModelProperty("sec_user_id")
    private Long secUserId;
    /**
     * sec_ou_id
     */
    @ApiModelProperty("sec_ou_id")
    private Long secOuId;


}
