package com.elitesland.yst.system.param;

import com.elitesland.yst.common.constant.Terminal;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**
 * <pre>
 * [功能说明]
 * </pre>
 *
 * @author Michael Li
 * @date 2020/7/18
 */
@Data
@Accessors(chain = true)
@ApiModel("用户账号创建对象")
public class SysUserNewParam implements Serializable {

    private static final long serialVersionUID = 5984016044888675161L;

    /**
     * 用户账号名称
     */
    @ApiModelProperty(value = "用户账号名称")
    private String username;

    /**
     * 用户姓氏
     */
    @ApiModelProperty(value = "用户姓氏")
    private String lastName;

    /**
     * 用户名称
     */
    @ApiModelProperty(value = "用户名称")
    private String firstName;

    /**
     * 用户手机号码
     */
    @ApiModelProperty(value = "用户手机号码")
    private String mobile;

    /**
     * 用户邮箱地址
     */
    @ApiModelProperty(value = "用户邮箱地址")
    private String email;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用")
    private Boolean enabled;

    /**
     * 用户所属公司ID
     */
    @ApiModelProperty("用户所属公司ID")
    private Long ouId;

    /**
     * 用户所属公司编号
     */
    @ApiModelProperty("用户所属公司编号")
    private String ouCode;

    /**
     * 用户所属公司名称
     */
    @ApiModelProperty("用户所属公司名称")
    private String ouName;

    /**
     * 用户所属组织ID
     */
    @ApiModelProperty("用户所属组织ID")
    private Long buId;

    @ApiModelProperty("所属租户ID")
    private String tenantId;

    @ApiModelProperty("所属租户名称")
    private String tenantName;

    /**
     * 功能角色ID列表
     */
    @ApiModelProperty("功能角色ID列表")
    private List<Long> roleIds;

    /**
     * 数据角色ID列表
     */
    @ApiModelProperty("数据角色ID列表")
    private List<Long> dataRoleIds;

    /**
     * 流程角色ID列表
     */
    @ApiModelProperty("流程角色ID列表")
    private List<Long> flowRoleIds;

    /**
     * <Strong>Mir 2020-09-15 增加账号信息来源字段，默认sys，由系统创建</Strong>
     */
    @ApiModelProperty("账号来源, sys： 系统创建；wec：微信创建；oth：其他方式")
    private String sourceType;

    /**
     * 用户终端
     * 可登录的端
     */
    @ApiModelProperty("用户终端, BACKEND： 管理端；APP：移动端")
    private Set<Terminal> terminals;
}
