package com.elitesland.yst.system.provider;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.system.provider.dto.SysFlowRoleDTO;
import com.elitesland.yst.system.provider.dto.SysUserFlowRoleDTO;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 流程角色.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/05
 */
public interface SysFlowRoleService {

    /**
     * 根据流程角色ID获取流程角色信息
     *
     * @param id 流程角色ID
     * @return 流程角色信息
     */
    ApiResult<SysFlowRoleDTO> get(@NotNull(message = "ID为空") Long id);

    /**
     * 根据流程角色ID获取流程角色信息
     *
     * @param ids 流程角色ID
     * @return 流程角色信息
     */
    ApiResult<List<SysFlowRoleDTO>> get(@NotEmpty(message = "ID为空") List<Long> ids);

    /**
     * 根据流程角色编码获取流程角色信息
     *
     * @param code 流程角色编码
     * @return 流程角色信息
     */
    ApiResult<SysFlowRoleDTO> getByCode(@NotBlank(message = "编号为空") String code);

    /**
     * 根据流程角色编码获取流程角色信息
     *
     * @param codes 流程角色编码
     * @return 流程角色信息
     */
    ApiResult<List<SysFlowRoleDTO>> getByCode(@NotEmpty(message = "编号为空") List<String> codes);

    /**
     * 获取用户绑定的流程角色信息
     *
     * @param userId 用户ID
     * @return 流程角色信息
     */
    ApiResult<List<SysFlowRoleDTO>> getByUserId(@NotNull(message = "用户ID为空") Long userId);

    /**
     * 获取用户绑定的流程角色信息
     *
     * @param userIds 用户ID
     * @return 流程角色信息
     */
    ApiResult<List<SysUserFlowRoleDTO>> getByUserId(@NotEmpty(message = "用户ID为空") List<Long> userIds);
}
