package com.elitesland.yst.system.provider;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.system.provider.dto.SysUserRpcDTO;
import com.elitesland.yst.system.provider.param.SysUserRpcDtoParam;
import com.elitesland.yst.system.provider.param.SysUserRpcSaveParam;
import com.elitesland.yst.system.vo.SysUserDTO;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author Chris
 * @date 2021-08-27
 */
public interface SysUserRpcService {

    /**
     * 更新用户绑定的微信id
     *
     * @param userName 用户登录号
     * @param openid   微信id
     * @return 用户登录号
     */
    ApiResult<String> updateUserWechatOpenid(@NotBlank(message = "登录号不能为空") String userName, String openid);

    /**
     * 查询用户信息
     *
     * @param param 查询条件
     * @return dto
     */
    List<SysUserRpcDTO> findUserRpcDtoByParam(SysUserRpcDtoParam param);

    /**
     * 第三方，创建用户账号，创建的默认来源为 oth
     *
     * @param param 保存参数
     * @return 用户id
     */
    ApiResult<Object> sysUserAccountCreate(SysUserRpcSaveParam param);

    /**
     * 根据用户名获取用户ID
     *
     * @param username 用户名
     * @return 用户ID
     */
    ApiResult<Long> getUserIdByUsername(@NotBlank(message = "用户名为空") String username);

    /**
     * 根据用户账号查询用户详细信息
     * <p>
     * 用于登录
     *
     * @param username 用户账号
     * @return 用户详细信息
     */
    ApiResult<SysUserDTO> getUserByUsername(@NotBlank(message = "用户名为空") String username);

    /**
     * 根据用户手机号查询用户详细信息
     * <p>
     * 用于登录
     *
     * @param mobile 手机号
     * @return 用户详细信息
     */
    ApiResult<SysUserDTO> getUserByMobile(@NotBlank(message = "手机号为空") String mobile);

    /**
     * 根据用户微信号查询用户详细信息
     * <p>
     * 用于登录
     *
     * @param wechatOpenid 用户微信号
     * @return 用户详细信息
     */
    ApiResult<SysUserDTO> getUserByWechatOpenid(@NotBlank(message = "微信号为空") String wechatOpenid);
}
