package com.elitesland.yst.system.service;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.system.param.SysButableQParam;
import com.elitesland.yst.system.vo.SysTableVO;

import java.util.List;
import java.util.Optional;

public interface SysButableService {

    /**
     * 查询所有需要配置 bu_id 使用的表记录
     * @return
     */
    public List<SysTableVO> listButable();

    public PagingVO<SysTableVO> search(SysButableQParam sysButableQParam);

    /**
     * 创建butable
     * @param sysTableVO
     * @return
     */
    public Long create(SysTableVO sysTableVO);

    public void update(SysTableVO sysTableVO);

    /**
     * 逻辑删除
     * @param id
     */
    public void logicDelete(Long id);

    /**
     * 根据ID返回对应记录
     *
     * @param id 记录ID
     * @return 记录对象
     */
    Optional<SysTableVO> findOneById(Long id);
}
