package com.elitesland.yst.system.service;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.system.param.SysNextNumberQParam;
import com.elitesland.yst.system.vo.SysNextNumberVO;

import java.util.List;
import java.util.Optional;

/**
 * <pre></pre>
 *
 * @author Michael Li
 * @date 2020-10-12
 */
public interface SysNextNumberService {

    /**
     * 根据code获取下一编号值
     * @param code 下一编号定义code
     * @return 下一编号的值
     */
    Long getNextNumber(String code, Integer nnLen);

    Long getNextNumberForRuntime(String code, Integer nnLen);

    /**
     * 检索系统下一编号配置
     *
     * @param param 查询条件对象
     * @return 分页的系统下一编号对象列表
     */
    PagingVO<SysNextNumberVO> search(SysNextNumberQParam param);

    /**
     * 根据下一编号ID，获取下一编号记录
     *
     * @param id 下一编号ID
     * @return 下一编号记录，可能为空
     */
    Optional<SysNextNumberVO> oneById(Long id);

    /**
     * 创建下一编号
     *
     * @param nextNumber 下一编号对象
     * @return 新建下一编号的ID
     */
    Long create(SysNextNumberVO nextNumber);

    /**
     * 更新下一编号
     *
     * @param nextNumber 下一编号更新对象
     */
    void update(SysNextNumberVO nextNumber);

    /**
     * 根据下一编号ID的列表，删除对应下一编号
     *
     * @param ids 下一编号ID列表
     */
    void deleteByIds(List<Long> ids);
}
