package com.elitesland.yst.system.service;

import com.elitesland.yst.system.dto.SysNumberRuleDtlDTO;
import com.elitesland.yst.system.vo.SysNumberRuleDtlVO;

import java.util.List;
import java.util.Optional;

/**
 * <pre></pre>
 *
 * @author Michael Li
 * @date 2020-10-11
 */
public interface SysNumberRuleDtlService {

    /**
     * 根据规则ID列出明细，按seq排序
     *
     * @param ruleId 规则ID
     * @return 规则明细列表
     */
    List<SysNumberRuleDtlVO> listByRuleId(Long ruleId);

    /**
     * 根据规则ID获取规则信息
     *
     * @param ruleId 规则ID
     * @return 规则信息
     */
    List<SysNumberRuleDtlDTO> listDtoByRuleId(Long ruleId);

    /**
     * 根据规则明细ID获取规则明细对象
     * @param id 规则明细ID
     * @return 规则明细对象
     */
    Optional<SysNumberRuleDtlVO> oneById(Long id);

    /**
     * 批量更新规则明细
     *
     * @param details 规则明细列表
     */
    void updateInBatch(List<SysNumberRuleDtlVO> details);

    /**
     * 根据规则明细ID删除对应规则
     *
     * @param id 规则ID
     */
    void removeByIds(List<Long> ids);

    /**
     * 根据规则ID删除对应所有的规则明细
     *
     * @param ruleId 规则ID
     */
    void removeByRuleId(Long ruleId);
}
