package com.elitesland.yst.system.service;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.system.param.SysNumberRuleQParam;
import com.elitesland.yst.system.vo.SysNumberRuleVO;

import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.Optional;

/**
 * <pre></pre>
 *
 * @author Michael Li
 * @date 2020-10-11
 */
public interface SysNumberRuleService {

    /**
     * 根据发号规则ID，生成样例号
     *
     * @param ruleId        发号规则ID
     * @param runtimeValues 基于UDC选择值的列表
     * @return 生成样例号，下一编号用默认，1
     */
    String generateSampleCode(Long ruleId, List<String> runtimeValues);

    /**
     * 根据发号规则编码，生成样例号
     *
     * @param ruleCode      发号规则编码
     * @param runtimeValues 基于UDC选择值的列表
     * @return 生成样例号，洗衣编号默认用，1
     */
    String generateSampleCode(@NotBlank(message = "发号规则编码为空") String ruleCode, List<String> runtimeValues);

    /**
     * 根据发号规则ID，生成对应号码
     *
     * @param ruleId        发号规则ID
     * @param runtimeValues 选择的UDC的值列表
     * @return 生成的号码
     */
    String generateCode(Long ruleId, List<String> runtimeValues);

    /**
     * 根据发号规则编码，生成对应号码
     *
     * @param ruleCode      发号规则编码
     * @param runtimeValues 选择UDC的值列表
     * @return 生成的号码
     */
    String generateCode(String ruleCode, List<String> runtimeValues);

    /**
     * 检索发号器规则
     *
     * @param param 检索条件对象
     * @return 分页的规则集合
     */
    PagingVO<SysNumberRuleVO> search(SysNumberRuleQParam param);

    /**
     * 根据发号器规则ID，返回规则主信息和关联且排序的规则明细
     *
     * @param id 规则ID
     * @return 规则对象
     */
    Optional<SysNumberRuleVO> oneCombined(Long id);

    /**
     * 创建发号器规则
     *
     * @param rule 规则对象
     * @return 新建规则的ID
     */
    Long create(SysNumberRuleVO rule);

    /**
     * 更新发号器规则
     *
     * @param rule 规则对象
     */
    void update(SysNumberRuleVO rule);

    /**
     * 删除发号器规则
     *
     * @param id 规则ID
     */
    void removeById(Long id);
}
