package com.elitesland.yst.system.service;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.system.param.SysSettingQParam;
import com.elitesland.yst.system.vo.SysSettingVO;

import java.util.List;

/**
 * @author mir
 */
public interface SysSettingService {

    /**
     * 根据查询条件对象，将找到的设置记录分页返回
     *
     * @param param 查询条件对象
     * @return 分页后的设置记录集合
     */
    PagingVO<SysSettingVO> search(SysSettingQParam param);

    /**
     * 列出所有的配置记录
     *
     * @return 所有配置记录的集合
     */
    List<SysSettingVO> all();

    /**
     * 通过记录ID，查找对应的设置记录
     *
     * @param id 记录ID
     * @return 找到的设置记录，没找到返回null
     */
    SysSettingVO oneById(Long id);

    /**
     * 通过设置编码，查找对应的设置记录
     *
     * @param no 设置编码
     * @return 找到的设置记录，没找到返回null
     */
    SysSettingVO oneByNo(String no);

    /**
     * 将提交的设置对象，在数据库中创建新的纪录
     *
     * @param sysSetting 待创建的设置对象
     * @return 新建设置记录的记录ＩＤ
     */
    Long create(SysSettingVO sysSetting);

    /**
     * 将提交的设置对象，更新数据库记录
     *
     * @param sysSettingVO 待更新的设置对象
     */
    void update(SysSettingVO sysSettingVO);

    /**
     * 将提供的记录ID对应的记录删除
     *
     * @param ids
     */
    void removeByIds(List<Long> ids);

    /**
     * 将提供的编码对应的记录删除
     *
     * @param nos 设置编码列表
     */
    void removeByNos(List<String> nos);
}
