package com.elitesland.yst.system.vo;

/**
 * @ProjectName: yst-metadata
 * @Package: com.elitesland.yst.metadata.enums
 * @ClassName: CompropEnum
 * @Author: chen
 * @Description: 比较符编码  对应UDC:META:COMPROP
 * @Date: 2021-09-01 11:27
 * @Version: 1.0
 */
public enum SysMetaDataCompropEnum {
    BETWEEN("BETWEEN", "在...之间，值只允许两个，不能少于两个，多于两个的取前两个"),
    CONTAINS("CONTAINS", "包含，只取第一个值来包含"),
    IN("IN", "在列表中"),
    EQ("EQ", "相等"),
    ;

    private final String code;
    private final String msg;

    SysMetaDataCompropEnum(final String code, final String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static SysMetaDataCompropEnum getApiCode(String code) {
        SysMetaDataCompropEnum[] ecs = SysMetaDataCompropEnum.values();
        for (SysMetaDataCompropEnum ec : ecs) {
            if (ec.getCode().equals(code) ) {
                return ec;
            }
        }
        return null;
    }
    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
