package com.elitesland.yst.system.vo;

import com.elitesland.yst.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@ApiModel("系统下一编号VO")
public class SysNextNumberVO implements Serializable {

    private static final long serialVersionUID = -8322372860111529382L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("唯一编号ID")
    Long id;

    @ApiModelProperty(value = "下一编号代码")
    String code;

    @ApiModelProperty(value = "下一编号名称")
    String name;

    @ApiModelProperty(value = "下一编号分类")
    String numberClass;

    @ApiModelProperty(value = "下一编号步长")
    Integer step;

    @ApiModelProperty(value = "下一编号取值")
    Long nextNumber;

    @ApiModelProperty(value = "下一编号周期[UDC]SYS:NNPERIOD")
    @SysCode(sys = "SYS", mod = "NNPERIOD")
    String nnPeriod;

    @ApiModelProperty(value = "下一编号周期名称[UDC]SYS:NNPERIOD")
    String nnPeriodName;

    @ApiModelProperty(value = "发号时间")
    LocalDateTime nnTime;
}
