package com.elitesland.yst.system.vo;

import com.elitesland.yst.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <pre></pre>
 *
 * @author Michael Li
 * @date 2020-10-11
 */
@Data
@ApiModel("发号器规则明细")
public class SysNumberRuleDtlVO implements Serializable {
    private static final long serialVersionUID = -7368713667265447277L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("唯一编号ID")
    Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "发号器规则ID")
    Long ruleId;

    @ApiModelProperty(value = "排序号")
    Integer seq;

    @ApiModelProperty(value = "取号类型：sys:numbertype, fs:固定字符串；dp：格式化日期；nn：自增序号")
    @SysCode(sys = "SYS", mod = "NUMBERTYPE")
    String numberType;

    @ApiModelProperty("取号类型名称")
    String numberTypeName;

    @ApiModelProperty(value = "取号模式，根据取号类型填写对应的固定字符串、日期格式化字符串、自增序号码")
    String numberPattern;

    @ApiModelProperty(value = "自增序号宽度，默认左补零")
    Integer nnLen;
}
