package com.elitesland.yst.system.vo;

import com.elitesland.yst.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <pre></pre>
 *
 * @author Michael Li
 * @date 2020-10-11
 */
@Data
@ApiModel("发号器规则VO")
public class SysNumberRuleVO implements Serializable {
    private static final long serialVersionUID = 2516122099027482881L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("唯一编号ID")
    Long id;

    @ApiModelProperty("规则编码")
    String ruleCode;

    @ApiModelProperty(value = "规则名称")
    String ruleName;

    @ApiModelProperty(value = "规则分类码：COM:DOMAIN")
    @SysCode(sys = "COM", mod = "DOMAIN")
    String ruleClass;

    @ApiModelProperty("规则分类码名称")
    String ruleClassName;

    @ApiModelProperty(value = "取号示例")
    String sampleCode;

    @ApiModelProperty("规则明细列表")
    List<SysNumberRuleDtlVO> ruleDetails;
}
