package com.elitesland.yst.system.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * <pre>
 * [功能说明]
 * </pre>
 *
 * @author Michael Li
 * @date 2020/7/19
 */
@Data
@ApiModel("权限查询结果对象，涵盖菜单、能力")
public class SysPermissionVO implements Serializable {

    private static final long serialVersionUID = -8608753467743271466L;

    @ApiModelProperty("权限ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long id;

    @ApiModelProperty(value = "权限代码")
    @NotBlank(message = "权限代码不能为空")
    private String code;

    @ApiModelProperty(value = "权限名称")
    @NotBlank(message = "权限名称不能为空")
    private String name;

    @ApiModelProperty(value = "权限类型: 1.菜单；0.按钮或API调用")
    private Integer permType;

    @ApiModelProperty(value = "父权限ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long parentId;

    @ApiModelProperty("父权限名称")
    String parentName;

    @ApiModelProperty(value = "权限层级路径")
    private String path;

    @ApiModelProperty(value = "权限层级")
    private Integer permLevel;

    @ApiModelProperty("排列顺序")
    private Integer sortNo;

    @ApiModelProperty(value = "URL路径模式")
    @NotBlank(message = "URL路径不能为空")
    private String pattern;

    @ApiModelProperty(value = "URL的HTTP方法[COM:HTTP_METH]")
    String httpMethod;

    @ApiModelProperty(value = "菜单是否隐藏")
    Boolean isHidden;

    @ApiModelProperty("菜单深度")
    Integer menuDepth;
}
