package com.elitesland.yst.system.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Michael Li
 * @date AD 2021.04.27 22:19
 */
@Data
@ApiModel("权限和角色的一一对应关系")
public class SysPermissionWithRoleVO implements Serializable {
    private static final long serialVersionUID = -3366435063384377576L;

    /**
     * id
     */
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 父权限ID
     */
    @ApiModelProperty(value = "父权限ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long parentId;

    /**
     * 后端用
     */
    @ApiModelProperty("角色Code")
    private String roleCode;

    /**
     * 编号，前端用
     */
    @ApiModelProperty(value = "权限代码")
    private String code;

    /**
     * 名称，前端用
     */
    @ApiModelProperty(value = "权限名称")
    private String name;

    /**
     * 后端用
     */
    @ApiModelProperty(value = "权限类型: 0.菜单权限，menu表示；1.按钮或API调用权限,action表示")
    private Integer permType;

    /**
     * 后端用
     */
    @ApiModelProperty("权限URL路径")
    private String pattern;

    /**
     * 后端用
     */
    @ApiModelProperty("权限URL对应HTTP方法")
    private String httpMethod;

    @ApiModelProperty("菜单是否隐藏")
    private Boolean isHidden;

    @ApiModelProperty("排序")
    private Integer sortNo;
}
