package com.elitesland.yst.system.vo;

import com.elitesland.yst.common.base.BaseViewModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Set;

/**
 * <pre>
 * 系统用户信息，脱敏
 * </pre>
 *
 * @author Michael Li
 * @date 2020/6/16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("系统用户信息，脱敏后")
public class SysUserVO extends BaseViewModel implements Serializable {

    private static final long serialVersionUID = 5583360083063856158L;

    @ApiModelProperty("用户账号")
    private String username;

    @ApiModelProperty("用户姓氏")
    private String lastName;

    @ApiModelProperty("用户名称")
    private String firstName;

    @ApiModelProperty("手机号")
    private String mobile;

    @ApiModelProperty("电子邮箱")
    private String email;

    @ApiModelProperty("角色名称列表")
    String roleNames;

    @ApiModelProperty("角色ids")
    String roleIds;


    @ApiModelProperty("所属租户名称")
    private String tenantName;

    @ApiModelProperty("用户账号启用状态")
    Boolean enabled;

    @ApiModelProperty("角色集合")
    Set<SysRoleVO> roles;

    @ApiModelProperty("权限集合")
    Set<SysPermissionVO> permissions;
}
