package com.elitesland.yst.comm.service;


import com.elitesland.yst.comm.vo.param.ComCommonTaxRateQueryParamVO;
import com.elitesland.yst.comm.vo.resp.ComCommonTaxRateRespVO;
import com.elitesland.yst.comm.vo.resp.ComTaxRateRespVO;
import com.elitesland.yst.comm.vo.resp.ComTaxRateVO;
import com.elitesland.yst.comm.vo.save.ComTaxRateSaveVO;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 税率
 * </p>
 *
 * @author zhenghaiyang
 * @date 2020/7/2
 */
public interface ComTaxRateService extends ComTaxRateProviderService {

    /**
     * 查找税率共通方法
     *
     * @param param 单个入参
     * @return 返回 单个税率
     * @author 常昊阳 haoyang.chang@elitesland.com
     */
    Optional<ComCommonTaxRateRespVO> getRatio(ComCommonTaxRateQueryParamVO param);

    /**
     * 根据税率编号及索引查询唯一税率 liuqi 2020.10.23
     *
     * @param taxRateNo    税率编号
     * @param taxRateIndex 税率索引
     * @return 税率
     */
    Optional<ComTaxRateVO> findBytaxRateNoAndIndex(String taxRateNo, String taxRateIndex);

    /**
     * 根据关键字段，返回对应的vo
     *
     * @param Code code
     * @return 对象
     */
    Optional<ComTaxRateRespVO> findCodeOne(String Code);

    /**
     * 根据关键字段，返回对应的
     *
     * @param Id ID
     * @return 对象
     */
    Optional<ComTaxRateRespVO> findIdOne(Long Id);

    Long createOne(ComTaxRateSaveVO comTaxRateSaveVO);

    /**
     * 创建
     *
     * @param List 对象集合
     */
    List<Long> createBatch(List<ComTaxRateSaveVO> List);

    /**
     * 更新
     *
     * @param objDo 对象
     */
    void update(ComTaxRateSaveVO objDo);

    /**
     * 删除
     *
     * @param Id 对象
     */
    void deleteOne(Long Id);

    /**
     * 删除
     *
     * @param idList 对象集合
     */
    void deleteBatch(List<Long> idList);


    /**
     * 更新删除标识
     *
     * @param id id
     */
    void updateDeleteFlag(Long id);
}
