package com.elitesland.yst.comm.vo.save;

import com.elitesland.yst.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@ApiModel(value = "税率", description = "税率")
public class ComTaxRateSaveVO implements Serializable {

    private static final long serialVersionUID = -7197577625040996865L;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率说明")
    private String taxRateDesc;

    @ApiModelProperty("生效日期")
    private LocalDateTime validFrom;

    @ApiModelProperty("失效日期")
    private LocalDateTime validTo;

    @ApiModelProperty("税率值")
    private Double taxRateValue;

    @ApiModelProperty("税率索引")
    @SysCode(sys = "COM", mod = "TAX_RATE_INDEX")
    private String taxRateIndex;
    @ApiModelProperty("税率索引 名称")
    String taxRateIndexName;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("账号唯一ID")
    private Long id;

    @ApiModelProperty(value = "租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long tenantId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    private LocalDateTime createTime ;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;

    private LocalDateTime modifyTime;

    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;

    @ApiModelProperty(value = "版本")
    private Integer auditDataVersion;
    /**
     * 操作人姓名
     */
    @ApiModelProperty("操作人姓名")
    private String operUserName;

}
