package com.elitesland.yst.system.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * <pre>
 * [功能说明]
 * </pre>
 *
 * @author Michael Li
 * @date 2020/7/19
 */
@Data
@ApiModel("系统权限[菜单、能力]新增对象")
public class SysPermissionNewParam implements Serializable {

    private static final long serialVersionUID = 7855929173972625172L;
    @ApiModelProperty(value = "权限代码")
    @NotBlank(message = "权限代码不能为空")
    private String code;

    @ApiModelProperty(value = "权限名称")
    @NotBlank(message = "权限名称不能为空")
    private String name;

    @ApiModelProperty(value = "父权限ID")
    private Long parentId;

    @ApiModelProperty(value = "URL路径模式")
    @NotBlank(message = "URL路径不能为空")
    private String pattern;

    @ApiModelProperty(value = "URL的HTTP方法[COM:HTTP_METH]")
    private String httpMethod;

    @ApiModelProperty("排列顺序")
    private Integer sortNo;

    @ApiModelProperty(value = "菜单是否隐藏")
    private Boolean isHidden;
}
