package com.elitesland.yst.system.provider;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.constant.Terminal;
import com.elitesland.yst.system.dto.SysUserTerminalSaveDTO;

import java.util.List;
import java.util.Map;

/**
 * 用户终端服务.
 *
 * @author Kaiser（wang shao）
 * @date 2021/09/29
 */
public interface SysUserTerminalRpcService {

    /**
     * 保存用户与终端关联
     * <p>
     * 以参数中的终端作为用户的所有终端
     *
     * @param saveParam 保存参数
     * @return 用户ID
     */
    ApiResult<Long> save(SysUserTerminalSaveDTO saveParam);

    /**
     * 新增终端绑定
     * <p>
     * 在用户已有的终端的基础上新增
     *
     * @param saveParam 保存参数
     * @return 用户ID
     */
    ApiResult<Long> saveForAdd(SysUserTerminalSaveDTO saveParam);

    /**
     * 减少终端绑定
     * <p>
     * 在用户已有的终端的基础上减少
     *
     * @param saveParam 保存参数
     * @return 用户ID
     */
    ApiResult<Long> saveForReduce(SysUserTerminalSaveDTO saveParam);

    /**
     * 获取用户关联的终端
     *
     * @param userId 用户ID
     * @return 关联的终端列表
     */
    ApiResult<List<Terminal>> getByUser(Long userId);

    /**
     * 获取用户关联的终端
     *
     * @param username 用户名
     * @return 关联的终端列表
     */
    ApiResult<List<Terminal>> getByUsername(String username);

    /**
     * 批量获取用户关联的终端
     *
     * @param userIds 用户ID
     * @return 用户及管理的终端列表
     */
    ApiResult<Map<Long, List<Terminal>>> getByUserIds(List<Long> userIds);
}
