package com.elitesland.yst.system.provider.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author Chris
 * @date 2021-08-27
 */
@Data
public class SysUserRpcDTO implements Serializable {

    private static final long serialVersionUID = 4358328278819658579L;

    /**
     * 用户ID
     */
    private Long id;

    /**
     * 用户账号名称
     */
    private String username;

    /**
     * 用户姓氏
     */
    private String lastName;

    /**
     * 用户名称
     */
    private String firstName;

    /**
     * 用户手机号码
     */
    private String mobile;

    /**
     * 用户邮箱地址
     */
    private String email;

    /**
     * 账号来源, sys： 系统创建；wec：微信创建；oth：其他方式
     */
    private String sourceType;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 密码是否需要重新设置
     */
    private Boolean needReset;

    /**
     * 用户头像地址，可直接访问，如微信头像链接等
     */
    private String avatarUrl;

    /**
     * 用户头像在文件服务器中的标识
     */
    private String avatarCode;

    /**
     * 微信openid
     */
    private String wxOpenid;
}
